/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.queue.impl.single.PretoucherState;
import org.junit.Assert;
import org.junit.Test;

public class PretoucherStateTest {
    @Test
    public void pretouch() {
        long[] pos = new long[]{0L};
        StringBuilder record = new StringBuilder();
        DummyPretoucherState ps = new DummyPretoucherState(() -> {
            pos[0] = pos[0] + 4096L;
            return pos[0];
        }, 65536, record, () -> false);
        ps.pretouch(null);
        ps.pretouch(null);
        Assert.assertEquals((Object)"debug none - Reset pretoucher to pos 4096 as the underlying MappedBytes changed.\ntouchPage 1 til 17 count 17\ndebug pretouch for only 0 of 17 min: 0 MB.\ndebug none: Advanced 4 KB, avg 4 KB between pretouch() and 4 KB while mapping of 0 KB \n", (Object)record.toString());
    }

    @Test
    public void pretouchLeap() {
        long[] pos = new long[]{0x100000L};
        StringBuilder record = new StringBuilder();
        DummyPretoucherState ps = new DummyPretoucherState(() -> {
            pos[0] = pos[0] + 4096L;
            return pos[0];
        }, 16384, record, () -> true);
        ps.pretouch(null);
        for (int i = 0; i < 8; ++i) {
            ps.pretouch(null);
            pos[0] = pos[0] + 57344L;
        }
        ps.pretouch(null);
        Assert.assertEquals((Object)"debug none - Reset pretoucher to pos 1052672 as the underlying MappedBytes changed.\ntouchPage 257 til 273 count 17\ndebug none: Advanced 4 KB, avg 4 KB between pretouch() and 4 KB while mapping of 68 KB \ntouchPage 274 til 304 count 31\ndebug none: Advanced 64 KB, avg 7 KB between pretouch() and 4 KB while mapping of 124 KB \ntouchPage 305 til 335 count 31\ndebug none: Advanced 64 KB, avg 11 KB between pretouch() and 4 KB while mapping of 124 KB \ntouchPage 336 til 364 count 29\ndebug none: Advanced 64 KB, avg 14 KB between pretouch() and 4 KB while mapping of 116 KB \ntouchPage 365 til 392 count 28\ndebug none: Advanced 64 KB, avg 17 KB between pretouch() and 4 KB while mapping of 112 KB \ntouchPage 393 til 420 count 28\ndebug none: Advanced 64 KB, avg 20 KB between pretouch() and 4 KB while mapping of 112 KB \ntouchPage 421 til 447 count 27\ndebug none: Advanced 64 KB, avg 23 KB between pretouch() and 4 KB while mapping of 108 KB \ntouchPage 448 til 473 count 26\ndebug none: Advanced 64 KB, avg 25 KB between pretouch() and 4 KB while mapping of 104 KB \ntouchPage 474 til 498 count 25\ndebug none: Advanced 64 KB, avg 28 KB between pretouch() and 4 KB while mapping of 100 KB \n", (Object)record.toString());
    }

    @Test
    public void pretouchLongBreak() {
        long[] pos = new long[]{0L};
        StringBuilder record = new StringBuilder();
        DummyPretoucherState ps = new DummyPretoucherState(() -> {
            pos[0] = pos[0] + 2048L;
            return pos[0];
        }, 16384, record, () -> true);
        for (int i = 0; i <= 10; ++i) {
            record.append("pos: ").append(pos[0]).append(", i:").append(i).append("\n");
            ps.pretouch(null);
        }
        Assert.assertEquals((Object)"pos: 0, i:0\ndebug none - Reset pretoucher to pos 2048 as the underlying MappedBytes changed.\npos: 2048, i:1\ntouchPage 0 til 16 count 17\ndebug none: Advanced 2 KB, avg 3 KB between pretouch() and 2 KB while mapping of 68 KB \npos: 6144, i:2\ntouchPage 17 til 17 count 1\ndebug none: Advanced 4 KB, avg 3 KB between pretouch() and 2 KB while mapping of 4 KB \npos: 10240, i:3\ntouchPage 18 til 18 count 1\ndebug none: Advanced 4 KB, avg 3 KB between pretouch() and 2 KB while mapping of 4 KB \npos: 14336, i:4\ntouchPage 19 til 19 count 1\ndebug none: Advanced 4 KB, avg 3 KB between pretouch() and 2 KB while mapping of 4 KB \npos: 18432, i:5\ntouchPage 20 til 20 count 1\ndebug none: Advanced 4 KB, avg 3 KB between pretouch() and 2 KB while mapping of 4 KB \npos: 22528, i:6\ntouchPage 21 til 21 count 1\ndebug none: Advanced 4 KB, avg 3 KB between pretouch() and 2 KB while mapping of 4 KB \npos: 26624, i:7\ntouchPage 22 til 22 count 1\ndebug none: Advanced 4 KB, avg 3 KB between pretouch() and 2 KB while mapping of 4 KB \npos: 30720, i:8\ntouchPage 23 til 23 count 1\ndebug none: Advanced 4 KB, avg 3 KB between pretouch() and 2 KB while mapping of 4 KB \npos: 34816, i:9\ntouchPage 24 til 24 count 1\ndebug none: Advanced 4 KB, avg 3 KB between pretouch() and 2 KB while mapping of 4 KB \npos: 38912, i:10\ntouchPage 25 til 25 count 1\ndebug none: Advanced 4 KB, avg 3 KB between pretouch() and 2 KB while mapping of 4 KB \n", (Object)record.toString());
    }

    class DummyPretoucherState
    extends PretoucherState {
        private final BooleanSupplier touched;
        StringBuilder record;
        boolean first;
        private long last;

        DummyPretoucherState(LongSupplier posSupplier, int headRoom, StringBuilder record, BooleanSupplier touched) {
            super(posSupplier, headRoom);
            this.first = true;
            this.record = record;
            this.touched = touched;
        }

        protected void debug(String message) {
            this.record.append("debug ").append(message).append("\n");
        }

        protected boolean touchPage(MappedBytes bytes, long offset) {
            if (this.first) {
                this.record.append("touchPage ").append(offset / 4096L);
                this.first = false;
            }
            this.last = offset;
            return this.touched.getAsBoolean();
        }

        protected void onTouched(int count) {
            this.record.append(" til ").append(this.last / 4096L).append(" count ").append(count).append("\n");
            this.first = true;
        }
    }
}

