/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.AbstractFieldInfo;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.FieldInfo;
import net.openhft.chronicle.wire.SerializationStrategy;
import net.openhft.chronicle.wire.WireMarshaller;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaFieldInfo
extends AbstractFieldInfo
implements FieldInfo {
    private final Class parent;
    private transient Field field;

    public VanillaFieldInfo(String name, Class type, BracketType bracketType, @NotNull Field field) {
        super(type, bracketType, name);
        this.parent = field.getDeclaringClass();
        this.field = field;
    }

    @NotNull
    public static Wires.FieldInfoPair lookupClass(@NotNull Class aClass) {
        SerializationStrategy ss = (SerializationStrategy)Wires.CLASS_STRATEGY.get(aClass);
        if (ss.bracketType() != BracketType.MAP) {
            return Wires.FieldInfoPair.EMPTY;
        }
        @NotNull ArrayList<VanillaFieldInfo> fields = new ArrayList<VanillaFieldInfo>();
        WireMarshaller marshaller = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(aClass);
        for (WireMarshaller.FieldAccess fa : marshaller.fields) {
            String name = fa.field.getName();
            Class<?> type = fa.field.getType();
            SerializationStrategy ss2 = (SerializationStrategy)Wires.CLASS_STRATEGY.get(type);
            BracketType bracketType = ss2.bracketType();
            fields.add(new VanillaFieldInfo(name, type, bracketType, fa.field));
        }
        return new Wires.FieldInfoPair(Collections.unmodifiableList(fields), fields.stream().collect(Collectors.toMap(FieldInfo::name, f -> f)));
    }

    @Override
    @Nullable
    public Object get(Object value) {
        try {
            return this.getField().get(value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            Jvm.debug().on(VanillaFieldInfo.class, e);
            return null;
        }
    }

    @Override
    public long getLong(Object value) {
        try {
            return this.getField().getLong(value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            Jvm.debug().on(VanillaFieldInfo.class, e);
            return Long.MIN_VALUE;
        }
    }

    @Override
    public int getInt(Object value) {
        try {
            return this.getField().getInt(value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            Jvm.debug().on(VanillaFieldInfo.class, e);
            return Integer.MIN_VALUE;
        }
    }

    @Override
    public char getChar(Object value) {
        try {
            return this.getField().getChar(value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            Jvm.debug().on(VanillaFieldInfo.class, e);
            return '\uffff';
        }
    }

    @Override
    public double getDouble(Object value) {
        try {
            return this.getField().getDouble(value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            Jvm.debug().on(VanillaFieldInfo.class, e);
            return Double.NaN;
        }
    }

    @Override
    public void set(Object object, Object value) throws IllegalArgumentException {
        Object value2 = ObjectUtils.convertTo(this.type, value);
        try {
            this.getField().set(object, value2);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void set(Object object, int value) throws IllegalArgumentException {
        try {
            this.getField().setInt(object, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void set(Object object, char value) throws IllegalArgumentException {
        try {
            this.getField().setChar(object, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void set(Object object, long value) throws IllegalArgumentException {
        try {
            this.getField().setLong(object, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void set(Object object, double value) throws IllegalArgumentException {
        try {
            this.getField().setDouble(object, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Field getField() throws NoSuchFieldException {
        if (this.field == null) {
            this.field = this.parent.getDeclaredField(this.name);
            Jvm.setAccessible(this.field);
        }
        return this.field;
    }

    @Override
    @NotNull
    public Class genericType(int index) {
        ParameterizedType genericType = (ParameterizedType)this.field.getGenericType();
        Type type = genericType.getActualTypeArguments()[index];
        return (Class)type;
    }
}

