/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.StoreTailer;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public final class TailerSequenceRaceConditionTest
extends QueueTestCommon {
    private final AtomicBoolean failedToMoveToEnd = new AtomicBoolean(false);
    private final ExecutorService threadPool = Executors.newFixedThreadPool(8, (ThreadFactory)new NamedThreadFactory("test"));

    @Test
    public void shouldAlwaysBeAbleToTail() throws InterruptedException {
        Object[] queues = new ChronicleQueue[10];
        for (int i = 0; i < 10; ++i) {
            int j;
            ChronicleQueue queue;
            queues[i] = queue = this.createNewQueue();
            for (j = 0; j < 4; ++j) {
                this.threadPool.submit(() -> this.attemptToMoveToTail(queue));
            }
            this.threadPool.submit(() -> this.appendToQueue(queue));
            for (j = 0; j < 4; ++j) {
                this.threadPool.submit(() -> this.attemptToMoveToTail(queue));
            }
        }
        this.threadPool.shutdown();
        Assert.assertTrue((boolean)this.threadPool.awaitTermination(5L, TimeUnit.SECONDS));
        Assert.assertFalse((boolean)this.failedToMoveToEnd.get());
        Closeable.closeQuietly((Object[])queues);
    }

    @After
    public void tearDown() {
        this.threadPool.shutdownNow();
    }

    private void appendToQueue(ChronicleQueue queue) {
        for (int i = 0; i < 31; ++i) {
            ExcerptAppender appender = queue.acquireAppender();
            if (queue.isClosed()) {
                return;
            }
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write((CharSequence)"foo");
                continue;
            }
        }
    }

    private void attemptToMoveToTail(ChronicleQueue queue) {
        StoreTailer tailer = (StoreTailer)queue.createTailer();
        try {
            tailer.toEnd();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            this.failedToMoveToEnd.set(true);
        }
    }

    private ChronicleQueue createNewQueue() {
        return SingleChronicleQueueBuilder.binary((File)DirectoryUtils.tempDir(TailerSequenceRaceConditionTest.class.getSimpleName())).rollCycle((RollCycle)RollCycles.HOURLY).build();
    }
}

