/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.bench;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;

public class ThroughputPerfMain2 {
    static final int time = Integer.getInteger("time", 20);
    static final int size = Integer.getInteger("size", 40);
    static final String path = System.getProperty("path", OS.TMP);
    static NativeBytesStore nbs;

    public static void main(String[] args) {
        String base = path + "/delete-" + System.nanoTime() + ".me";
        long start = System.nanoTime();
        long count = 0L;
        nbs = NativeBytesStore.nativeStoreWithFixedCapacity((long)size);
        long blockSize = OS.is64Bit() ? 0x100000000L : 0x10000000L;
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((String)base).rollCycle((RollCycle)RollCycles.LARGE_HOURLY_XSPARSE).blockSize(blockSize).build();){
            ExcerptAppender appender = q.acquireAppender();
            count += appender.batchAppend(time * 1000, ThroughputPerfMain2::writeMessages);
        }
        nbs.releaseLast();
        long mid = System.nanoTime();
        long time1 = mid - start;
        NativeBytes bytes = Bytes.allocateElasticDirect((long)64L);
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((String)base).rollCycle((RollCycle)RollCycles.LARGE_HOURLY_XSPARSE).blockSize(blockSize).build();){
            ExcerptTailer tailer = q.createTailer();
            for (long i = 0L; i < count; ++i) {
                try (DocumentContext dc = tailer.readingDocument();){
                    bytes.clear();
                    bytes.write((BytesStore)dc.wire().bytes());
                    continue;
                }
            }
        }
        bytes.releaseLast();
        long end = System.nanoTime();
        long time2 = end - mid;
        System.out.printf("Writing %,d messages took %.3f seconds, at a rate of %,d per second%n", count, (double)time1 / 1.0E9, (long)(1.0E9 * (double)count / (double)time1));
        System.out.printf("Reading %,d messages took %.3f seconds, at a rate of %,d per second%n", count, (double)time2 / 1.0E9, (long)(1.0E9 * (double)count / (double)time2));
        System.gc();
        IOTools.deleteDirWithFiles((String)base, (int)2);
    }

    private static long writeMessages(long address, long canWrite, int writeCount) {
        long count;
        long length = 0L;
        long fromAddress = nbs.addressForRead(0L);
        for (count = 0L; (long)writeCount > count && length + 4L + (long)size <= canWrite; ++count) {
            UnsafeMemory.UNSAFE.copyMemory(fromAddress, address + 4L, size);
            UnsafeMemory.UNSAFE.putOrderedInt(null, address, size);
            address += (long)(4 + size);
            length += (long)(4 + size);
        }
        return count << 32 | length;
    }
}

