/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import org.junit.Assert;
import org.junit.Test;

public class PeekDocumentTest
extends QueueTestCommon {
    private static final String EXPECTED_MESSAGE = "hello world";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWrite10() {
        File tempDir = DirectoryUtils.tempDir("to-be-deleted");
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tempDir).build();){
            Throwable throwable;
            ExcerptAppender appender = queue.acquireAppender();
            for (int i = 0; i < 1024; ++i) {
                throwable = null;
                try (DocumentContext documentContext = appender.writingDocument();){
                    documentContext.wire().write((CharSequence)"value").text("hello" + i);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            ExcerptTailer tailer = queue.createTailer();
            for (int i = 0; i < 1024; ++i) {
                Assert.assertTrue((boolean)tailer.peekDocument());
                try (DocumentContext documentContext = tailer.readingDocument();){
                    Assert.assertTrue((boolean)documentContext.isPresent());
                    Assert.assertTrue((boolean)tailer.peekDocument());
                    Wire wire = documentContext.wire();
                    long l = wire.bytes().readPosition();
                    try {
                        Assert.assertEquals((Object)("hello" + i), (Object)wire.read("value").text());
                        continue;
                    }
                    finally {
                        if (l % 2L == 0L) {
                            wire.bytes().readPosition(l);
                        }
                    }
                }
            }
            Assert.assertFalse((boolean)tailer.peekDocument());
            throwable = null;
            try (DocumentContext documentContext = appender.writingDocument();){
                documentContext.wire().write((CharSequence)"value").text("hello10");
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            Assert.assertTrue((boolean)tailer.peekDocument());
        }
        finally {
            tempDir.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWrite10Backwards() {
        File tempDir = DirectoryUtils.tempDir("to-be-deleted");
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tempDir).build();){
            ExcerptAppender appender = queue.acquireAppender();
            try (DocumentContext documentContext = appender.writingDocument();){
                documentContext.wire().write((CharSequence)"value").text("hello");
            }
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertTrue((boolean)tailer.peekDocument());
            try (DocumentContext documentContext = tailer.readingDocument();){
                Assert.assertTrue((boolean)documentContext.isPresent());
                Assert.assertTrue((boolean)tailer.peekDocument());
                Wire wire = documentContext.wire();
                String result = wire.read("value").text();
                Assert.assertEquals((Object)"hello", (Object)result);
                System.out.println(result);
            }
            Assert.assertFalse((boolean)tailer.peekDocument());
            tailer.direction(TailerDirection.BACKWARD);
            Assert.assertTrue((boolean)tailer.peekDocument());
            documentContext = tailer.readingDocument();
            var7_11 = null;
            if (documentContext != null) {
                if (var7_11 != null) {
                    try {
                        documentContext.close();
                    }
                    catch (Throwable throwable) {
                        var7_11.addSuppressed(throwable);
                    }
                } else {
                    documentContext.close();
                }
            }
            Assert.assertFalse((boolean)tailer.peekDocument());
        }
        finally {
            tempDir.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWrite() {
        File tempDir = DirectoryUtils.tempDir("to-be-deleted");
        try {
            Bytes bytes = Bytes.from((String)EXPECTED_MESSAGE);
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tempDir).build();){
                ExcerptAppender appender = queue.acquireAppender();
                appender.writeText((CharSequence)"hello");
                ExcerptTailer tailer = queue.createTailer();
                Assert.assertTrue((boolean)tailer.peekDocument());
            }
        }
        finally {
            tempDir.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test2() {
        File tempDir = DirectoryUtils.tempDir("to-be-deleted");
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tempDir).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeText((CharSequence)"hello1");
            appender.writeText((CharSequence)"hello2");
            ExcerptTailer tailer = queue.createTailer();
            long address1a = (Long)Jvm.getValue((Object)tailer, (String)"address");
            Assert.assertTrue((boolean)tailer.moveToIndex(tailer.index() + 1L));
            long address1b = (Long)Jvm.getValue((Object)tailer, (String)"address");
            Assert.assertNotEquals((long)address1a, (long)address1b);
            Assert.assertFalse((boolean)tailer.moveToIndex(tailer.index() + 1L));
            long address1c = (Long)Jvm.getValue((Object)tailer, (String)"address");
            Assert.assertEquals((long)address1c, (long)NoBytesStore.NO_PAGE);
        }
        finally {
            tempDir.deleteOnExit();
        }
    }

    @Test
    public void testWhenNoDocument() {
        File tempDir = DirectoryUtils.tempDir("to-be-deleted");
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((File)tempDir).build();){
            ExcerptTailer tailer = queue.createTailer();
            ExcerptAppender appender = queue.acquireAppender();
            boolean peekDocumentBeforeWrite = tailer.peekDocument();
            Assert.assertFalse((boolean)peekDocumentBeforeWrite);
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().writeText((CharSequence)"testString");
            }
            boolean peekDocumentAfterWrite = tailer.peekDocument();
            Assert.assertTrue((boolean)peekDocumentAfterWrite);
            String text = null;
            try (DocumentContext dc = tailer.readingDocument();){
                text = dc.wire().readText();
            }
            Assert.assertEquals((Object)"testString", (Object)text);
            boolean peekDocumentAfterRead = tailer.peekDocument();
            Assert.assertFalse((boolean)peekDocumentAfterRead);
        }
    }
}

