/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.MethodWriterBuilder;
import net.openhft.chronicle.bytes.MethodWriterInterceptor;
import net.openhft.chronicle.bytes.MethodWriterInterceptorReturns;
import net.openhft.chronicle.bytes.MethodWriterInvocationHandler;
import net.openhft.chronicle.bytes.MethodWriterListener;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.wire.GenerateMethodWriter;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.MethodWriterInvocationHandlerSupplier;
import net.openhft.chronicle.wire.SharedDocumentContext;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;

public class VanillaMethodWriterBuilder<T>
implements Supplier<T>,
MethodWriterBuilder<T> {
    private static final boolean DISABLE_PROXY_GEN = Jvm.getBoolean("disableProxyCodegen", true);
    private static final Class<?> COMPILE_FAILED = ClassNotFoundException.class;
    private static final Map<String, Class> classCache = new ConcurrentHashMap<String, Class>();
    private final Set<Class> interfaces = Collections.synchronizedSet(new LinkedHashSet());
    private final String packageName;
    private ClassLoader classLoader;
    @NotNull
    private final MethodWriterInvocationHandlerSupplier handlerSupplier;
    private MarshallableOut out;
    private Closeable closeable;
    private String genericEvent;
    private MethodWriterListener methodWriterListener;
    private boolean metaData;
    private boolean useMethodIds;
    private WireType wireType;
    private Class<?> proxyClass;

    @NotNull
    public MethodWriterBuilder<T> classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> addInterface(Class additionalClass) {
        if (this.interfaces.contains(additionalClass)) {
            return this;
        }
        this.interfaces.add(additionalClass);
        for (Method method : additionalClass.getMethods()) {
            Class<?> returnType = method.getReturnType();
            if (!returnType.isInterface() || Jvm.dontChain(returnType)) continue;
            this.addInterface(returnType);
        }
        return this;
    }

    @Override
    @NotNull
    public MethodWriterBuilder<T> recordHistory(boolean recordHistory) {
        this.handlerSupplier.recordHistory(recordHistory);
        return this;
    }

    public VanillaMethodWriterBuilder(@NotNull Class<T> tClass, WireType wireType, @NotNull Supplier<MethodWriterInvocationHandler> handlerSupplier) {
        this.packageName = tClass.getPackage().getName();
        this.wireType = wireType;
        this.addInterface(tClass);
        this.classLoader = tClass.getClassLoader();
        this.handlerSupplier = new MethodWriterInvocationHandlerSupplier(handlerSupplier);
    }

    @NotNull
    public MethodWriterBuilder<T> methodWriterInterceptor(MethodWriterInterceptor methodWriterInterceptor) {
        this.handlerSupplier.methodWriterInterceptor(methodWriterInterceptor);
        return this;
    }

    @Override
    @NotNull
    public MethodWriterBuilder<T> methodWriterInterceptorReturns(MethodWriterInterceptorReturns methodWriterInterceptor) {
        this.handlerSupplier.methodWriterInterceptorReturns(methodWriterInterceptor);
        return this;
    }

    @Override
    @NotNull
    public MethodWriterBuilder<T> methodWriterListener(MethodWriterListener methodWriterListener) {
        this.methodWriterListener = methodWriterListener;
        this.handlerSupplier.methodWriterListener(methodWriterListener);
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> disableThreadSafe(boolean theadSafe) {
        this.handlerSupplier.disableThreadSafe(theadSafe);
        return this;
    }

    @Override
    @NotNull
    public T build() {
        return this.get();
    }

    @Override
    @NotNull
    public MethodWriterBuilder<T> onClose(Closeable closeable) {
        this.closeable = closeable;
        this.handlerSupplier.onClose(closeable);
        return this;
    }

    public WireType wireType() {
        return this.wireType;
    }

    public VanillaMethodWriterBuilder<T> wireType(WireType wireType) {
        this.wireType = wireType;
        return this;
    }

    @NotNull
    private String getClassName() {
        StringBuilder sb = new StringBuilder();
        this.interfaces.forEach(i -> sb.append(i.getSimpleName()));
        sb.append(this.genericEvent == null ? "" : this.genericEvent);
        sb.append(this.metaData ? "MetadataAware" : "");
        sb.append(this.useMethodIds ? "MethodIds" : "");
        sb.append(this.hasMethodWriterListener() ? "MethodListener" : "");
        sb.append(this.toFirstCapCase(this.wireType().toString()));
        sb.append("MethodWriter");
        return sb.toString();
    }

    @Override
    @NotNull
    public T get() {
        block8: {
            block7: {
                if (this.proxyClass != null) {
                    try {
                        Constructor<?> constructor = this.proxyClass.getConstructor(MethodWriterInvocationHandlerSupplier.class);
                        return (T)constructor.newInstance(this.handlerSupplier);
                    }
                    catch (Throwable e) {
                        if (!Jvm.isDebug()) break block7;
                        Jvm.debug().on(this.getClass(), e);
                    }
                }
            }
            if (!DISABLE_PROXY_GEN) {
                String className = this.getClassName();
                try {
                    Class clazz = classCache.computeIfAbsent(className, this::newClass);
                    if (clazz != null && clazz != COMPILE_FAILED) {
                        Object t = this.newInstance(clazz);
                        return (T)t;
                    }
                }
                catch (Throwable e) {
                    classCache.put(className, COMPILE_FAILED);
                    if (!Jvm.isDebug()) break block8;
                    Jvm.debug().on(this.getClass(), e);
                }
            }
        }
        @NotNull Class[] interfacesArr = this.interfaces.toArray(new Class[this.interfaces.size()]);
        return (T)Proxy.newProxyInstance(this.classLoader, interfacesArr, (InvocationHandler)new CallSupplierInvocationHandler());
    }

    private Class newClass(String name) {
        LinkedHashSet<Class> setOfInterfaces = new LinkedHashSet<Class>(this.interfaces);
        setOfInterfaces.add(SharedDocumentContext.class);
        return GenerateMethodWriter.newClass(this.packageName, setOfInterfaces, name, this.classLoader, this.wireType, this.genericEvent, this.hasMethodWriterListener(), this.metaData, this.useMethodIds);
    }

    private boolean hasMethodWriterListener() {
        return this.methodWriterListener != null;
    }

    private Object newInstance(Class aClass) {
        try {
            if (this.out == null) {
                throw new NullPointerException("marshallableOut(out) has not been set.");
            }
            return aClass.getDeclaredConstructors()[0].newInstance(this.out, this.closeable, this.methodWriterListener);
        }
        catch (Exception e) {
            throw Jvm.rethrow(e);
        }
    }

    @Override
    public MethodWriterBuilder<T> genericEvent(String genericEvent) {
        this.handlerSupplier.genericEvent(genericEvent);
        this.genericEvent = genericEvent;
        return this;
    }

    @Override
    public MethodWriterBuilder<T> useMethodIds(boolean useMethodIds) {
        this.handlerSupplier.useMethodIds(useMethodIds);
        this.useMethodIds = useMethodIds;
        return this;
    }

    public MethodWriterBuilder<T> marshallableOut(@NotNull MarshallableOut out) {
        this.out = out;
        return this;
    }

    @Override
    public MethodWriterBuilder<T> metaData(boolean metaData) {
        this.metaData = metaData;
        return this;
    }

    public Class<?> proxyClass() {
        return this.proxyClass;
    }

    public MethodWriterBuilder<T> proxyClass(Class<?> proxyClass) {
        if (proxyClass.isInterface()) {
            throw new IllegalArgumentException("expecting a class rather than an interface, proxyClass=" + proxyClass);
        }
        this.proxyClass = proxyClass;
        return this;
    }

    @NotNull
    private String toFirstCapCase(@NotNull String name) {
        return Character.toUpperCase(name.charAt(0)) + name.substring(1).toLowerCase();
    }

    class CallSupplierInvocationHandler
    implements InvocationHandler {
        CallSupplierInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return VanillaMethodWriterBuilder.this.handlerSupplier.get().invoke(proxy, method, args);
        }
    }
}

