/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.HotMethod;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.threads.CoreEventLoop;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.Threads;
import net.openhft.chronicle.threads.VanillaEventLoop;
import net.openhft.chronicle.threads.internal.EventLoopUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediumEventLoop
extends AbstractCloseable
implements CoreEventLoop,
Runnable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(MediumEventLoop.class);
    private final EventLoop parent;
    @NotNull
    private final ExecutorService service;
    private final List<EventHandler> mediumHandlers = new CopyOnWriteArrayList<EventHandler>();
    private final AtomicReference<EventHandler> newHandler = new AtomicReference();
    @NotNull
    private final AtomicBoolean running = new AtomicBoolean();
    private final Pauser pauser;
    private final boolean daemon;
    private final String name;
    private final String binding;
    @NotNull
    private EventHandler[] mediumHandlersArray = VanillaEventLoop.NO_EVENT_HANDLERS;
    private volatile long loopStartMS;
    @Nullable
    private volatile Thread thread = null;

    public MediumEventLoop(EventLoop parent, String name, Pauser pauser, boolean daemon, String binding) {
        this.parent = parent;
        this.name = name;
        this.pauser = pauser;
        this.daemon = daemon;
        this.binding = binding;
        this.loopStartMS = Long.MAX_VALUE;
        this.service = Executors.newSingleThreadExecutor(new NamedThreadFactory(name, daemon));
    }

    public static void closeAll(@NotNull List<EventHandler> handlers) {
        Closeable.closeQuietly(handlers);
    }

    @Override
    @Nullable
    public Thread thread() {
        return this.thread;
    }

    @Override
    public void awaitTermination() {
        try {
            this.service.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @NotNull
    public String toString() {
        return "MediumEventLoop{name='" + this.name + '\'' + ", parent=" + this.parent + ", service=" + this.service + ", mediumHandlers=" + this.mediumHandlers + ", newHandler=" + this.newHandler + ", pauser=" + this.pauser + '}';
    }

    @Override
    public void start() {
        block3: {
            this.throwExceptionIfClosed();
            if (!this.running.getAndSet(true)) {
                try {
                    this.service.submit(this);
                }
                catch (RejectedExecutionException e) {
                    if (this.isClosed()) break block3;
                    this.closeAll();
                    throw e;
                }
            }
        }
    }

    @Override
    public void unpause() {
        this.pauser.unpause();
    }

    @Override
    public void stop() {
        this.running.set(false);
    }

    @Override
    public void addHandler(@NotNull EventHandler handler) {
        this.throwExceptionIfClosed();
        HandlerPriority priority = handler.priority();
        if (this.parent == null && handler.priority() != HandlerPriority.MEDIUM) {
            if (handler.priority() == HandlerPriority.MONITOR) {
                Jvm.warn().on(this.getClass(), "Ignoring " + handler.getClass());
                return;
            }
            throw new IllegalArgumentException("Cannot handle " + handler.getClass() + " " + (Object)((Object)handler.priority()));
        }
        if (DEBUG_ADDING_HANDLERS) {
            System.out.println("Adding " + (Object)((Object)priority) + " " + handler + " to " + this.name);
        }
        if (priority.alias() != HandlerPriority.MEDIUM) {
            throw new IllegalStateException(this.name() + ": Unexpected priority " + (Object)((Object)priority) + " for " + handler);
        }
        this.throwExceptionIfClosed();
        this.checkInterrupted();
        if (this.thread == null || this.thread == Thread.currentThread()) {
            this.addNewHandler(handler);
            return;
        }
        do {
            this.pauser.unpause();
            this.throwExceptionIfClosed();
            this.checkInterrupted();
        } while (!this.newHandler.compareAndSet(null, handler));
    }

    void checkInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            throw new IllegalStateException(this.hasBeen("interrupted"));
        }
    }

    @Override
    public long loopStartMS() {
        return this.loopStartMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @HotMethod
    public void run() {
        try (AffinityLock lock2 = AffinityLock.acquireLock(this.binding);){
            this.thread = Thread.currentThread();
            this.runLoop();
        }
        catch (InvalidEventHandlerException lock2) {
        }
        catch (Throwable e) {
            Jvm.warn().on(this.getClass(), this.hasBeen("terminated due to exception"), e);
        }
        finally {
            this.close();
            this.loopStartMS = 0x7FFFFFFFFFFFFFFEL;
        }
    }

    private void loopFinishedAllHandlers() {
        this.mediumHandlers.forEach(Threads::loopFinishedQuietly);
    }

    private void runLoop() throws InvalidEventHandlerException {
        int acceptHandlerModCount = EventLoopUtil.ACCEPT_HANDLER_MOD_COUNT;
        while (this.running.get() && this.isNotInterrupted()) {
            if (this.isClosed()) {
                throw new InvalidEventHandlerException(this.hasBeen("closed"));
            }
            boolean busy = this.runMediumLoopOnly();
            if (busy) {
                this.pauser.reset();
                if (!EventLoopUtil.IS_ACCEPT_HANDLER_MOD_COUNT || --acceptHandlerModCount > 0) continue;
                this.acceptNewHandlers();
                acceptHandlerModCount = EventLoopUtil.ACCEPT_HANDLER_MOD_COUNT;
                continue;
            }
            if (this.acceptNewHandlers()) continue;
            this.loopStartMS = Long.MAX_VALUE;
            this.pauser.pause();
        }
    }

    private boolean isNotInterrupted() {
        return !VanillaEventLoop.CHECK_INTERRUPTS || !Thread.currentThread().isInterrupted();
    }

    private boolean runMediumLoopOnly() {
        this.loopStartMS = System.currentTimeMillis();
        return this.runAllMediumHandler();
    }

    private void closeAll() {
        this.closeAllHandlers();
        LOG.trace("Remaining handlers");
        this.dumpRunningHandlers();
    }

    @HotMethod
    private boolean runAllMediumHandler() {
        boolean busy = false;
        EventHandler[] handlers = this.mediumHandlersArray;
        try {
            switch (handlers.length) {
                case 4: {
                    try {
                        busy |= handlers[3].action();
                    }
                    catch (InvalidEventHandlerException e) {
                        this.removeMediumHandler(handlers[3]);
                    }
                }
                case 3: {
                    try {
                        busy |= handlers[2].action();
                    }
                    catch (InvalidEventHandlerException e) {
                        this.removeMediumHandler(handlers[2]);
                    }
                }
                case 2: {
                    try {
                        busy |= handlers[1].action();
                    }
                    catch (InvalidEventHandlerException e) {
                        this.removeMediumHandler(handlers[1]);
                    }
                }
                case 1: {
                    try {
                        busy |= handlers[0].action();
                        break;
                    }
                    catch (InvalidEventHandlerException e) {
                        this.removeMediumHandler(handlers[0]);
                    }
                }
                case 0: {
                    break;
                }
                default: {
                    for (EventHandler handler : handlers) {
                        try {
                            busy |= handler.action();
                        }
                        catch (InvalidEventHandlerException e) {
                            this.removeMediumHandler(handler);
                        }
                    }
                    break;
                }
            }
        }
        catch (Throwable e) {
            Jvm.warn().on(this.getClass(), e);
        }
        return busy;
    }

    private void removeMediumHandler(EventHandler handler) {
        this.removeHandler(handler, this.mediumHandlers);
        this.mediumHandlersArray = this.mediumHandlers.toArray(VanillaEventLoop.NO_EVENT_HANDLERS);
    }

    private void removeHandler(EventHandler handler, @NotNull List<EventHandler> handlers) {
        block2: {
            try {
                handlers.remove(handler);
                Threads.loopFinishedQuietly(handler);
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                if (handlers.isEmpty()) break block2;
                throw e2;
            }
        }
        Closeable.closeQuietly((Object)handler);
    }

    @HotMethod
    private boolean acceptNewHandlers() {
        EventHandler handler = this.newHandler.getAndSet(null);
        if (handler != null) {
            this.addNewHandler(handler);
            return true;
        }
        return false;
    }

    private void addNewHandler(@NotNull EventHandler handler) {
        HandlerPriority t1 = handler.priority();
        switch (t1 == null ? HandlerPriority.MEDIUM : t1.alias()) {
            case REPLICATION: 
            case CONCURRENT: 
            case HIGH: 
            case MEDIUM: 
            case DAEMON: {
                if (!this.mediumHandlers.contains(handler)) {
                    this.mediumHandlers.add(handler);
                    this.mediumHandlersArray = this.mediumHandlers.toArray(VanillaEventLoop.NO_EVENT_HANDLERS);
                }
                return;
            }
            case MONITOR: {
                if (this.parent != null) {
                    handler.eventLoop(this.parent);
                    break;
                }
                Jvm.warn().on(this.getClass(), "Handler " + handler.getClass() + " ignored");
            }
        }
        throw new IllegalArgumentException("Cannot add a " + (Object)((Object)handler.priority()) + " task to a busy waiting thread");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void dumpRunningState(@NotNull String message, @NotNull BooleanSupplier finalCheck) {
        Thread thread = this.thread;
        if (thread == null) {
            return;
        }
        StringBuilder out = new StringBuilder(message);
        Jvm.trimStackTrace(out, thread.getStackTrace());
        if (finalCheck.getAsBoolean() && LOG.isInfoEnabled()) {
            LOG.info(out.toString());
        }
    }

    public int nonDaemonHandlerCount() {
        return this.mediumHandlers.size();
    }

    public int handlerCount() {
        return this.mediumHandlers.size();
    }

    @Override
    protected void performClose() {
        block7: {
            try {
                this.stop();
                this.pauser.reset();
                this.pauser.unpause();
                LockSupport.unpark(this.thread);
                Threads.shutdown(this.service, this.daemon);
                if (this.thread == null) {
                    this.loopFinishedAllHandlers();
                    return;
                }
                if (this.thread == Thread.currentThread()) break block7;
                this.thread.interrupt();
                for (int i = 1; i <= 30; ++i) {
                    if (this.loopStartMS == 0x7FFFFFFFFFFFFFFEL) {
                        break;
                    }
                    Jvm.pause(i);
                    if (i % 10 != 0) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.name).append(": Shutting down thread is executing ").append(this.thread).append(", handlerCount=").append(this.nonDaemonHandlerCount());
                    Jvm.trimStackTrace(sb, this.thread.getStackTrace());
                    Jvm.warn().on(this.getClass(), sb.toString());
                    this.dumpRunningHandlers();
                }
            }
            finally {
                this.closeAllHandlers();
                this.mediumHandlers.clear();
                this.mediumHandlersArray = VanillaEventLoop.NO_EVENT_HANDLERS;
                this.newHandler.set(null);
            }
        }
    }

    public void closeAllHandlers() {
        MediumEventLoop.closeAll(this.mediumHandlers);
        Optional.ofNullable(this.newHandler.get()).ifPresent(eventHandler -> {
            Jvm.warn().on(this.getClass(), "Handler in newHandler was not accepted before close " + eventHandler);
            Closeable.closeQuietly(eventHandler);
        });
    }

    public void dumpRunningHandlers() {
        int handlerCount = this.handlerCount();
        if (handlerCount <= 0) {
            return;
        }
        List<EventHandler> collect = Stream.of(this.mediumHandlers).flatMap(Collection::stream).filter(e -> e instanceof Closeable).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return;
        }
        LOG.info("Handlers still running after being closed, handlerCount=" + handlerCount);
        collect.forEach(h -> LOG.info("\t" + h));
    }

    @Override
    public boolean isAlive() {
        Thread thread = this.thread;
        return thread != null && thread.isAlive();
    }

    private String hasBeen(String offendingProperty) {
        return String.format("%s has been %s.", MediumEventLoop.class.getSimpleName(), offendingProperty);
    }

    @Override
    protected boolean threadSafetyCheck(boolean isUsed) {
        return true;
    }
}

