/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.util.ThrowingFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceCountedCache<K, T extends ReferenceCounted & Closeable, V, E extends Throwable>
extends AbstractCloseable {
    private final Map<K, T> cache = new LinkedHashMap<K, T>();
    private final Function<T, V> transformer;
    private final ThrowingFunction<K, T, E> creator;
    private final ReferenceOwner storeOwner;

    public ReferenceCountedCache(Function<T, V> transformer, ThrowingFunction<K, T, E> creator, ReferenceOwner storeOwner) {
        this.transformer = transformer;
        this.creator = creator;
        this.storeOwner = storeOwner;
    }

    @NotNull
    synchronized V get(@NotNull K key) throws E {
        this.cache.entrySet().removeIf(entry -> ((ReferenceCounted)entry.getValue()).refCount() == 0);
        @Nullable ReferenceCounted value = (ReferenceCounted)this.cache.get(key);
        if (value == null) {
            value = (ReferenceCounted)this.creator.apply(key);
            value.reserveTransfer(INIT, this.storeOwner);
            this.cache.put(key, value);
        }
        return this.transformer.apply(value);
    }

    @Override
    protected synchronized void performClose() {
        this.cache.forEach((k, v) -> v.release(this.storeOwner));
    }

    @Override
    protected boolean threadSafetyCheck(boolean isUsed) {
        return true;
    }
}

