/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.QueryCloseable;
import net.openhft.chronicle.core.io.ReferenceCountedTracer;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import org.jetbrains.annotations.NotNull;

public final class TracingReferenceCounted
implements ReferenceCountedTracer {
    private final Map<ReferenceOwner, StackTrace> references = Collections.synchronizedMap(new IdentityHashMap());
    private final Map<ReferenceOwner, StackTrace> releases = Collections.synchronizedMap(new IdentityHashMap());
    private final Runnable onRelease;
    private final String uniqueId;
    private final StackTrace createdHere;
    private volatile StackTrace releasedHere;

    TracingReferenceCounted(Runnable onRelease, String uniqueId) {
        this.onRelease = onRelease;
        this.uniqueId = uniqueId;
        this.createdHere = this.stackTrace("init", INIT);
        this.references.put(INIT, this.createdHere);
    }

    static String asString(Object id) {
        return id == INIT ? "INIT" : (id instanceof ReferenceOwner ? ((ReferenceOwner)id).referenceName() : id.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(id)));
    }

    @Override
    public StackTrace createdHere() {
        return this.createdHere;
    }

    @Override
    public boolean reservedBy(ReferenceOwner owner) {
        if (this.references.containsKey(owner)) {
            return true;
        }
        StackTrace stackTrace = this.releases.get(owner);
        if (stackTrace == null) {
            throw new IllegalStateException("Never reserved by " + TracingReferenceCounted.asString(owner));
        }
        throw new IllegalStateException("No longer reserved by " + TracingReferenceCounted.asString(owner), stackTrace);
    }

    @Override
    public void reserve(ReferenceOwner id) throws IllegalStateException {
        this.tryReserve(id, true);
    }

    @Override
    public boolean tryReserve(ReferenceOwner id) {
        return this.tryReserve(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryReserve(ReferenceOwner id, boolean must) {
        if (id == this) {
            throw new IllegalArgumentException("The counter cannot reserve itself");
        }
        if (Jvm.isDebug()) {
            System.out.println(Thread.currentThread().getName() + " " + this.uniqueId + " - tryReserve " + TracingReferenceCounted.asString(id));
        }
        Map<ReferenceOwner, StackTrace> map = this.references;
        synchronized (map) {
            if (this.references.isEmpty()) {
                if (must) {
                    throw new IllegalStateException("Cannot reserve freed resource", this.createdHere);
                }
                return false;
            }
            StackTrace stackTrace = this.references.get(id);
            if (stackTrace != null) {
                throw new IllegalStateException("Already reserved resource by " + TracingReferenceCounted.asString(id) + " here", stackTrace);
            }
            this.references.putIfAbsent(id, this.stackTrace("reserve", id));
        }
        this.releases.remove(id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(ReferenceOwner id) throws IllegalStateException {
        if (Jvm.isDebug()) {
            System.out.println(Thread.currentThread().getName() + " " + this.uniqueId + " - release " + TracingReferenceCounted.asString(id));
        }
        Map<ReferenceOwner, StackTrace> map = this.references;
        synchronized (map) {
            if (this.references.remove(id) == null) {
                StackTrace stackTrace = this.releases.get(id);
                if (stackTrace == null) {
                    Throwable cause = this.createdHere;
                    if (!this.references.isEmpty()) {
                        StackTrace ste = this.references.values().iterator().next();
                        cause = new IllegalStateException("Reserved by " + this.referencesAsString(), ste);
                    }
                    throw new IllegalStateException("Not reserved by " + TracingReferenceCounted.asString(id), cause);
                }
                throw new IllegalStateException("Already released " + TracingReferenceCounted.asString(id) + " location ", stackTrace);
            }
            this.releases.put(id, this.stackTrace("release", id));
            if (this.references.isEmpty()) {
                if (this.releasedHere != null) {
                    throw new IllegalStateException("Already released", this.releasedHere);
                }
                this.releasedHere = new StackTrace("release here");
                this.onRelease.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<String> referencesAsString() {
        Map<ReferenceOwner, StackTrace> map = this.references;
        synchronized (map) {
            return this.references.keySet().stream().map(TracingReferenceCounted::asString).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseLast(ReferenceOwner id) throws IllegalStateException {
        Map<ReferenceOwner, StackTrace> map = this.references;
        synchronized (map) {
            if (this.references.size() > 1) {
                Exception e0 = null;
                try {
                    this.release(id);
                }
                catch (Exception e) {
                    e0 = e;
                }
                IllegalStateException ise = new IllegalStateException("Still reserved " + this.referencesAsString(), this.createdHere);
                this.references.values().forEach(ise::addSuppressed);
                if (e0 != null) {
                    ise.addSuppressed(e0);
                }
                throw ise;
            }
            this.release(id);
        }
    }

    @Override
    public int refCount() {
        return this.references.size();
    }

    @NotNull
    public String toString() {
        return this.uniqueId + " - " + this.referencesAsString();
    }

    @NotNull
    private StackTrace stackTrace(String oper, ReferenceOwner ro) {
        return new StackTrace(this.toString() + " " + Thread.currentThread().getName() + " " + oper + " " + TracingReferenceCounted.asString(ro));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void throwExceptionIfNotReleased() throws IllegalStateException {
        Map<ReferenceOwner, StackTrace> map = this.references;
        synchronized (map) {
            if (this.references.isEmpty()) {
                return;
            }
            IllegalStateException ise = new IllegalStateException("Retained reference closed");
            for (Map.Entry<ReferenceOwner, StackTrace> entry : this.references.entrySet()) {
                ReferenceOwner referenceOwner = entry.getKey();
                StackTrace reservedHere = entry.getValue();
                ise.addSuppressed(new IllegalStateException("Reserved by " + TracingReferenceCounted.asString(referenceOwner), reservedHere));
                if (referenceOwner instanceof AbstractCloseable) {
                    AbstractCloseable ac = (AbstractCloseable)referenceOwner;
                    try {
                        ac.throwExceptionIfClosed();
                    }
                    catch (IllegalStateException e) {
                        ise.addSuppressed(e);
                    }
                    continue;
                }
                if (!(referenceOwner instanceof QueryCloseable)) continue;
                try {
                    ((QueryCloseable)((Object)referenceOwner)).throwExceptionIfClosed();
                }
                catch (Throwable t) {
                    ise.addSuppressed(new IllegalStateException("Closed " + TracingReferenceCounted.asString(referenceOwner), t));
                }
            }
            if (ise.getSuppressed().length > 0) {
                throw ise;
            }
        }
    }

    @Override
    public void throwExceptionIfReleased() throws IllegalStateException {
        if (this.refCount() <= 0) {
            throw new IllegalStateException("Released", this.releasedHere);
        }
    }

    @Override
    public void warnAndReleaseIfNotReleased() {
        if (this.refCount() > 0) {
            Slf4jExceptionHandler.WARN.on(this.getClass(), "Discarded without being released", this.createdHere);
            this.onRelease.run();
        }
    }
}

