/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.bytes.ref.LongReference;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.ReferenceOwner;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class UncheckedLongReference
extends AbstractCloseable
implements LongReference,
ReferenceOwner {
    private long address;
    private Unsafe unsafe;
    private BytesStore bytes;

    @NotNull
    public static LongReference create(BytesStore bytesStore, long offset, int size) {
        @NotNull AbstractCloseable ref = Jvm.isDebug() ? new BinaryLongReference() : new UncheckedLongReference();
        ref.bytesStore(bytesStore, offset, size);
        return ref;
    }

    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) {
        this.throwExceptionIfClosedInSetter();
        if (length != this.maxSize()) {
            throw new IllegalArgumentException();
        }
        this.address = bytes.addressForRead(offset);
        if (this.bytes != bytes) {
            if (this.bytes != null) {
                this.bytes.release(this);
            }
            this.bytes = bytes;
            bytes.reserve(this);
        }
        this.unsafe = UnsafeMemory.UNSAFE;
    }

    @NotNull
    public BytesStore bytesStore() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long offset() {
        return this.address;
    }

    @Override
    public long maxSize() {
        return 8L;
    }

    @NotNull
    public String toString() {
        return this.address == 0L ? "addressForRead is 0" : "value: " + this.getValue();
    }

    @Override
    public long getValue() {
        try {
            return this.unsafe.getLong(this.address);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    @Override
    public void setValue(long value) {
        try {
            this.unsafe.putLong(this.address, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    @Override
    public long getVolatileValue() {
        try {
            return this.unsafe.getLongVolatile(null, this.address);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    @Override
    public long getVolatileValue(long closedValue) {
        if (this.isClosed()) {
            return closedValue;
        }
        try {
            return this.getVolatileValue();
        }
        catch (Exception e) {
            return closedValue;
        }
    }

    @Override
    public void setVolatileValue(long value) {
        try {
            this.unsafe.putLongVolatile(null, this.address, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    @Override
    public void setOrderedValue(long value) {
        try {
            this.unsafe.putOrderedLong(null, this.address, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    @Override
    public long addValue(long delta) {
        try {
            return this.unsafe.getAndAddLong(null, this.address, delta) + delta;
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    @Override
    public long addAtomicValue(long delta) {
        try {
            return this.addValue(delta);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    @Override
    public boolean compareAndSwapValue(long expected, long value) {
        try {
            return this.unsafe.compareAndSwapLong(null, this.address, expected, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    @Override
    protected void performClose() {
        this.unsafe = null;
        if (this.bytes != null) {
            this.bytes.release(this);
        }
        this.bytes = null;
    }

    @Override
    protected boolean threadSafetyCheck(boolean isUsed) {
        return true;
    }
}

