/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.TableDirectoryListing;
import net.openhft.chronicle.queue.impl.table.Metadata;
import net.openhft.chronicle.queue.impl.table.SingleTableBuilder;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TableDirectoryListingTest
extends QueueTestCommon {
    private TableDirectoryListing listing;
    private TableStore<Metadata.NoMeta> tablestore;
    private File testDirectory;
    private File tempFile;

    @NotNull
    private static File testDirectory() {
        return DirectoryUtils.tempDir(TableDirectoryListingTest.class.getSimpleName());
    }

    @Before
    public void setUp() throws IOException {
        this.testDirectory = TableDirectoryListingTest.testDirectory();
        this.testDirectory.mkdirs();
        File tableFile = new File(this.testDirectory, "dir-list.cq4t");
        this.tablestore = SingleTableBuilder.binary((File)tableFile, (Metadata)Metadata.NoMeta.INSTANCE).build();
        this.listing = new TableDirectoryListing(this.tablestore, this.testDirectory.toPath(), f -> Integer.parseInt(f.getName().split("\\.")[0]), false);
        this.listing.init();
        this.tempFile = File.createTempFile("foo", "bar");
        this.tempFile.deleteOnExit();
    }

    @After
    public void tearDown() {
        this.tablestore.close();
        this.listing.close();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldBlowUpIfClosed() {
        this.listing.close();
        this.listing.getMaxCreatedCycle();
    }

    @Test
    public void shouldTrackMaxValue() {
        this.listing.refresh();
        this.listing.onFileCreated(this.tempFile, 7);
        Assert.assertEquals((long)7L, (long)this.listing.getMaxCreatedCycle());
        Assert.assertEquals((long)7L, (long)this.listing.getMinCreatedCycle());
        this.listing.onFileCreated(this.tempFile, 8);
        Assert.assertEquals((long)8L, (long)this.listing.getMaxCreatedCycle());
        Assert.assertEquals((long)7L, (long)this.listing.getMinCreatedCycle());
    }

    @Test
    public void shouldInitialiseFromFilesystem() throws IOException {
        new File(this.testDirectory, "1.cq4").createNewFile();
        new File(this.testDirectory, "2.cq4").createNewFile();
        new File(this.testDirectory, "3.cq4").createNewFile();
        this.listing.refresh();
        Assert.assertEquals((long)3L, (long)this.listing.getMaxCreatedCycle());
        Assert.assertEquals((long)1L, (long)this.listing.getMinCreatedCycle());
    }

    @Test
    public void lockShouldTimeOut() {
        this.listing.onFileCreated(this.tempFile, 8);
        this.listing.onFileCreated(this.tempFile, 9);
        Assert.assertEquals((long)9L, (long)this.listing.getMaxCreatedCycle());
    }
}

