/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Test;

public final class DuplicateMessageReadTest
extends QueueTestCommon {
    private static final RollCycles QUEUE_CYCLE = RollCycles.DAILY;

    private static void write(ExcerptAppender appender, Data data) throws IOException {
        try (DocumentContext dc = appender.writingDocument();){
            ObjectOutput out = dc.wire().objectOutput();
            out.writeInt(data.id);
        }
    }

    private static Data read(ExcerptTailer tailer) throws IOException {
        try (DocumentContext dc = tailer.readingDocument();){
            if (!dc.isPresent()) {
                Data data = null;
                return data;
            }
            ObjectInput in = dc.wire().objectInput();
            Data data = new Data(in.readInt());
            return data;
        }
    }

    @Test
    public void shouldNotReceiveDuplicateMessages() throws IOException {
        File location = DirectoryUtils.tempDir(DuplicateMessageReadTest.class.getSimpleName());
        try (SingleChronicleQueue chronicleQueue = SingleChronicleQueueBuilder.binary((File)location).rollCycle((RollCycle)QUEUE_CYCLE).build();){
            Data data2;
            ExcerptAppender appender = chronicleQueue.acquireAppender();
            appender.pretouch();
            ArrayList<Data> expected = new ArrayList<Data>();
            for (int i = 50; i < 60; ++i) {
                expected.add(new Data(i));
            }
            ExcerptTailer tailer = chronicleQueue.createTailer();
            tailer.toEnd();
            for (Data data2 : expected) {
                DuplicateMessageReadTest.write(appender, data2);
            }
            ArrayList<Data> actual = new ArrayList<Data>();
            while ((data2 = DuplicateMessageReadTest.read(tailer)) != null) {
                actual.add(data2);
            }
            Assert.assertEquals(expected, actual);
        }
    }

    private static final class Data {
        private final int id;

        private Data(int id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Data data = (Data)o;
            return this.id == data.id;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            return "" + this.id;
        }
    }
}

