/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class TailerDirectionTest
extends ChronicleQueueTestBase {
    private static final String TEST_MESSAGE_PREFIX = "Test entry: ";

    private String testMessage(int id) {
        return TEST_MESSAGE_PREFIX + id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long appendEntry(@NotNull ExcerptAppender appender, String msg) {
        try (DocumentContext dc = appender.writingDocument();){
            dc.wire().write().text(msg);
            long l = dc.index();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readNextEntry(@NotNull ExcerptTailer tailer) {
        try (DocumentContext dc = tailer.readingDocument();){
            if (dc.isPresent()) {
                Object parent = dc.wire().parent();
                assert (parent == tailer);
                String string = dc.wire().read().text();
                return string;
            }
            String string = null;
            return string;
        }
    }

    @Test
    public void testTailerForwardBackwardRead() {
        String basePath = OS.TARGET + "/tailerForwardBackward-" + System.nanoTime();
        SingleChronicleQueue queue = ChronicleQueue.singleBuilder((String)basePath).testBlockSize().rollCycle((RollCycle)RollCycles.HOURLY).build();
        ExcerptAppender appender = queue.acquireAppender();
        ExcerptTailer tailer = queue.createTailer();
        HashMap<String, Long> msgIndexes = new HashMap<String, Long>();
        for (int i = 0; i < 4; ++i) {
            String msg = this.testMessage(i);
            long idx = this.appendEntry(appender, msg);
            msgIndexes.put(msg, idx);
        }
        Assert.assertEquals((String)"[Forward 1] Wrong message 0", (Object)this.testMessage(0), (Object)this.readNextEntry(tailer));
        Assert.assertEquals((String)"[Forward 1] Wrong Tailer index after reading msg 0", (long)((Long)msgIndexes.get(this.testMessage(1))), (long)tailer.index());
        Assert.assertEquals((String)"[Forward 1] Wrong message 1", (Object)this.testMessage(1), (Object)this.readNextEntry(tailer));
        Assert.assertEquals((String)"[Forward 1] Wrong Tailer index after reading msg 1", (long)((Long)msgIndexes.get(this.testMessage(2))), (long)tailer.index());
        tailer.direction(TailerDirection.BACKWARD);
        Assert.assertEquals((String)"[Backward] Wrong message 2", (Object)this.testMessage(2), (Object)this.readNextEntry(tailer));
        Assert.assertEquals((String)"[Backward] Wrong Tailer index after reading msg 2", (long)((Long)msgIndexes.get(this.testMessage(1))), (long)tailer.index());
        Assert.assertEquals((String)"[Backward] Wrong message 1", (Object)this.testMessage(1), (Object)this.readNextEntry(tailer));
        Assert.assertEquals((String)"[Backward] Wrong Tailer index after reading msg 1", (long)((Long)msgIndexes.get(this.testMessage(0))), (long)tailer.index());
        Assert.assertEquals((String)"[Backward] Wrong message 0", (Object)this.testMessage(0), (Object)this.readNextEntry(tailer));
        String res = this.readNextEntry(tailer);
        Assert.assertNull((String)("Backward: res is" + res), (Object)res);
        tailer.direction(TailerDirection.FORWARD);
        res = this.readNextEntry(tailer);
        Assert.assertNull((String)("Forward: res is" + res), (Object)res);
        Assert.assertEquals((String)"[Forward 2] Wrong message 0", (Object)this.testMessage(0), (Object)this.readNextEntry(tailer));
        Assert.assertEquals((String)"[Forward 2] Wrong Tailer index after reading msg 0", (long)((Long)msgIndexes.get(this.testMessage(1))), (long)tailer.index());
        Assert.assertEquals((String)"[Forward 2] Wrong message 1", (Object)this.testMessage(1), (Object)this.readNextEntry(tailer));
        Assert.assertEquals((String)"[Forward 2] Wrong Tailer index after reading msg 1", (long)((Long)msgIndexes.get(this.testMessage(2))), (long)tailer.index());
        queue.close();
    }

    @Test
    public void uninitialisedTailerCreatedBeforeFirstAppendWithDirectionNoneShouldNotFindDocument() {
        AtomicLong clock = new AtomicLong(System.currentTimeMillis());
        String path = OS.TARGET + "/" + this.getClass().getSimpleName() + "-" + System.nanoTime();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((String)path).timeProvider(clock::get).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_SECONDLY).build();){
            ExcerptTailer tailer = queue.createTailer();
            tailer.direction(TailerDirection.NONE);
            ExcerptAppender excerptAppender = queue.acquireAppender();
            for (int i = 0; i < 10; ++i) {
                excerptAppender.writeDocument((Object)i, (out, value) -> out.int32(value.intValue()));
            }
            DocumentContext document = tailer.readingDocument();
            Assert.assertFalse((boolean)document.isPresent());
        }
    }

    @Test
    public void testTailerBackwardsReadBeyondCycle() {
        int i;
        File basePath = DirectoryUtils.tempDir("tailerForwardBackwardBeyondCycle");
        SetTimeProvider timeProvider = new SetTimeProvider();
        SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)basePath).testBlockSize().timeProvider((TimeProvider)timeProvider).build();
        ExcerptAppender appender = queue.acquireAppender();
        ArrayList<Long> indexes = new ArrayList<Long>();
        ArrayList<String> messages = new ArrayList<String>();
        for (int d = -7; d <= 0; ++d) {
            if (d == -5 || d == -4) continue;
            timeProvider.currentTimeMillis(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(d));
            for (i = 0; i < 3; ++i) {
                String msg = this.testMessage(indexes.size());
                long idx = this.appendEntry(appender, msg);
                messages.add(msg);
                indexes.add(idx);
            }
        }
        ExcerptTailer tailer = queue.createTailer().direction(TailerDirection.BACKWARD).toEnd();
        for (i = indexes.size() - 1; i >= 0; --i) {
            long index = (Long)indexes.get(i);
            String msg = (String)messages.get(i);
            Assert.assertEquals((String)("[Backward] Wrong index " + i), (long)index, (long)tailer.index());
            Assert.assertEquals((String)("[Backward] Wrong message " + i), (Object)msg, (Object)this.readNextEntry(tailer));
        }
        queue.close();
    }
}

