/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.onoes.ExceptionKey;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import net.openhft.chronicle.core.threads.ThreadDump;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class QueueTestCommon {
    protected ThreadDump threadDump;
    protected Map<ExceptionKey, Integer> exceptions;
    private Map<Predicate<ExceptionKey>, String> expectedExceptions = new LinkedHashMap<Predicate<ExceptionKey>, String>();

    @Before
    public void enableReferenceTracing() {
        AbstractReferenceCounted.enableReferenceTracing();
    }

    public void assertReferencesReleased() {
        AbstractReferenceCounted.assertReferencesReleased();
    }

    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
    }

    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @Before
    public void recordExceptions() {
        this.exceptions = Jvm.recordExceptions();
    }

    public void expectException(String message) {
        this.expectException(k -> k.message.contains(message), message);
    }

    public void expectException(Predicate<ExceptionKey> predicate, String description) {
        this.expectedExceptions.put(predicate, description);
    }

    public void checkExceptions() {
        System.gc();
        Jvm.pause((long)10L);
        for (Map.Entry<Predicate<ExceptionKey>, String> expectedException : this.expectedExceptions.entrySet()) {
            if (this.exceptions.keySet().removeIf(expectedException.getKey())) continue;
            Slf4jExceptionHandler.WARN.on(this.getClass(), "No error for " + expectedException.getValue());
        }
        if (Jvm.hasException(this.exceptions)) {
            Jvm.dumpException(this.exceptions);
            Jvm.resetExceptionHandlers();
            Assert.fail();
        }
    }

    @After
    public void afterChecks() {
        this.assertReferencesReleased();
        this.checkThreadDump();
        this.checkExceptions();
    }
}

