/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.sql.DriverManager;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.CountingJDBCResult;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.JDBCResult;
import net.openhft.chronicle.queue.JDBCService;
import net.openhft.chronicle.queue.JDBCStatement;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.junit.Ignore;
import org.junit.Test;

public class JDBCServiceTest
extends QueueTestCommon {
    @Test
    public void testCreateTable() {
        this.threadDump.ignore("HSQLDB Timer ");
        this.doCreateTable(4, 5000);
    }

    @Test
    @Ignore(value="Long running")
    public void perfCreateTable() {
        this.doCreateTable(5, 200000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCreateTable(int repeats, int noUpdates) {
        for (int t = 0; t < repeats; ++t) {
            long start = System.nanoTime();
            File path1 = DirectoryUtils.tempDir("createTable1");
            File path2 = DirectoryUtils.tempDir("createTable2");
            File file = new File(OS.TARGET, "hsqldb-" + System.nanoTime());
            file.deleteOnExit();
            try (SingleChronicleQueue in = SingleChronicleQueueBuilder.binary((File)path1).testBlockSize().build();
                 SingleChronicleQueue out = SingleChronicleQueueBuilder.binary((File)path2).testBlockSize().build();){
                JDBCService service = new JDBCService((ChronicleQueue)in, (ChronicleQueue)out, () -> DriverManager.getConnection("jdbc:hsqldb:file:" + file.getAbsolutePath(), "SA", ""));
                JDBCStatement writer = service.createWriter();
                writer.executeUpdate("CREATE TABLE tableName (\nname VARCHAR(64) NOT NULL,\nnum INT\n)\n", new Object[0]);
                int i = 1;
                while ((long)i < (long)noUpdates) {
                    writer.executeUpdate("INSERT INTO tableName (name, num)\nVALUES (?, ?)", new Object[]{"name", i});
                    ++i;
                }
                long written = System.nanoTime() - start;
                AtomicLong queries = new AtomicLong();
                AtomicLong updates = new AtomicLong();
                CountingJDBCResult countingJDBCResult = new CountingJDBCResult(queries, updates);
                MethodReader methodReader = service.createReader((JDBCResult)countingJDBCResult);
                while (updates.get() < (long)noUpdates) {
                    if (methodReader.readOne()) continue;
                    Thread.yield();
                }
                Closeable.closeQuietly((Object)service);
                long time = System.nanoTime() - start;
                System.out.printf("Average time to write each update %.1f us, average time to perform each update %.1f us%n", (double)(written / (long)noUpdates) / 1000.0, (double)(time / (long)noUpdates) / 1000.0);
                continue;
            }
            finally {
                try {
                    IOTools.deleteDirWithFiles((File)path1, (int)2);
                    IOTools.deleteDirWithFiles((File)path2, (int)2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void afterChecks() {
        try {
            super.afterChecks();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

