/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.UUID;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.QueueTestCommon;
import org.jetbrains.annotations.NotNull;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.ErrorCollector;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChronicleQueueTestBase
extends QueueTestCommon {
    protected static final Logger LOGGER;
    private static final boolean TRACE_TEST_EXECUTION;
    @Rule
    public final TestName testName = new TestName();
    @Rule
    public final TemporaryFolder folder = new TemporaryFolder(new File(System.getProperty("java.io.tmpdir")));
    @Rule
    public final ErrorCollector errorCollector = new ErrorCollector();
    @Rule
    @NotNull
    public TestRule watcher = new TestWatcher(){

        protected void starting(@NotNull Description description) {
            if (TRACE_TEST_EXECUTION) {
                LOGGER.info("Starting test: {}.{}", (Object)description.getClassName(), (Object)description.getMethodName());
            }
        }
    };

    static void deleteDir(String ... dirs) {
        for (String dir : dirs) {
            try {
                ChronicleQueueTestBase.deleteDir(new File(dir));
            }
            catch (Exception e) {
                Jvm.warn().on(ChronicleQueueTestBase.class, (Throwable)e);
            }
        }
    }

    public static void deleteDir(@NotNull File dir) {
        File[] files;
        if (dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    ChronicleQueueTestBase.deleteDir(file);
                    continue;
                }
                file.delete();
            }
        }
        dir.delete();
    }

    @NotNull
    protected File getTmpDir() {
        String methodName = this.testName.getMethodName();
        return DirectoryUtils.tempDir(methodName != null ? methodName.replaceAll("[\\[\\]\\s]+", "_").replace(':', '_') : "NULL-" + UUID.randomUUID());
    }

    @BeforeClass
    public static void synchronousFileTruncating() {
        System.setProperty("chronicle.queue.synchronousFileShrinking", "true");
    }

    static {
        System.setProperty("queue.check.index", "true");
        LOGGER = LoggerFactory.getLogger(ChronicleQueueTestBase.class);
        TRACE_TEST_EXECUTION = Jvm.getBoolean((String)"queue.traceTestExecution");
    }
}

