/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.algo.BytesStoreHash;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;

public abstract class AbstractBytesStore<B extends BytesStore<B, Underlying>, Underlying>
extends AbstractReferenceCounted
implements BytesStore<B, Underlying> {
    protected AbstractBytesStore() {
    }

    protected AbstractBytesStore(boolean monitored) {
        super(monitored);
    }

    @Override
    public int peekUnsignedByte(long offset) throws BufferUnderflowException {
        return offset >= this.readLimit() ? -1 : this.readUnsignedByte(offset);
    }

    public int hashCode() {
        return BytesStoreHash.hash32(this);
    }

    @Override
    public long readPosition() {
        return 0L;
    }

    @Override
    public long readRemaining() {
        return this.capacity();
    }

    @Override
    public long start() {
        return 0L;
    }

    @Override
    protected boolean performReleaseInBackground() {
        return this.isDirectMemory();
    }
}

