/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MethodWriterInterceptorReturns;
import net.openhft.chronicle.bytes.MethodWriterInvocationHandler;
import net.openhft.chronicle.core.util.AbstractInvocationHandler;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.ParameterHolderSequenceWriter;
import net.openhft.chronicle.wire.RawText;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMethodWriterInvocationHandler
extends AbstractInvocationHandler
implements MethodWriterInvocationHandler {
    private final Map<Method, ParameterHolderSequenceWriter> parameterMap = new ConcurrentHashMap<Method, ParameterHolderSequenceWriter>();
    private final ThreadLocal<Object> proxy = new ThreadLocal();
    private final BiFunction<Method, Object[], Object> onMethod = (m, a) -> {
        this.handleInvoke.accept((Method)m, (Object[])a);
        return m.getReturnType().isInterface() ? this.proxy.get() : null;
    };
    protected boolean recordHistory;
    protected String genericEvent = "";
    private MethodWriterInterceptorReturns methodWriterInterceptorReturns;
    private BiConsumer<Method, Object[]> handleInvoke = this::handleInvoke;
    private boolean useMethodIds;

    public AbstractMethodWriterInvocationHandler() {
        super(HashMap::new);
    }

    @Override
    protected Object doInvoke(Object proxy, Method method, Object[] args) {
        if (this.methodWriterInterceptorReturns != null) {
            this.proxy.set(proxy);
            this.methodWriterInterceptorReturns.intercept(method, args, this.onMethod);
        } else {
            this.handleInvoke(method, args);
        }
        return method.getReturnType().isInterface() ? proxy : null;
    }

    @Override
    public void genericEvent(String genericEvent) {
        this.genericEvent = genericEvent;
    }

    protected abstract void handleInvoke(Method var1, Object[] var2);

    protected void handleInvoke(@NotNull Method method, Object[] args, Wire wire) {
        String methodName;
        if (this.recordHistory) {
            wire.writeEventName("history").marshallable(MessageHistory.get());
        }
        if ((methodName = method.getName()).equals(this.genericEvent)) {
            this.writeGenericEvent(wire, method, args);
            return;
        }
        this.writeEvent(wire, method, methodName, args);
    }

    private void writeEvent(Wire wire, @NotNull Method method, String methodName, Object[] args) {
        this.writeEvent0(wire, method, args, methodName, 0);
    }

    private void writeGenericEvent(Wire wire, @NotNull Method method, Object[] args) {
        String methodName = args[0].toString();
        this.writeEvent0(wire, method, args, methodName, 1);
    }

    private void writeEvent0(Wire wire, @NotNull Method method, Object[] args, String methodName, int oneParam) {
        ParameterHolderSequenceWriter phsw = this.parameterMap.computeIfAbsent(method, ParameterHolderSequenceWriter::new);
        Bytes<?> bytes = wire.bytes();
        if (bytes.retainsComments()) {
            bytes.comment(methodName);
        }
        boolean useMethodId = this.useMethodIds && phsw.methodId >= 0L && wire.getValueOut().isBinary();
        ValueOut valueOut = useMethodId ? wire.writeEventId((int)phsw.methodId) : wire.writeEventName(methodName);
        switch (args.length - oneParam) {
            case 0: {
                valueOut.text("");
                break;
            }
            case 1: {
                Object arg = args[oneParam];
                if (bytes.retainsComments()) {
                    this.addComment(bytes, arg);
                }
                if (arg != null && arg.getClass() == RawText.class) {
                    valueOut.rawText(((RawText)arg).text);
                    break;
                }
                valueOut.object(phsw.parameterTypes[oneParam], arg);
                break;
            }
            default: {
                valueOut.sequence(args, oneParam == 0 ? phsw.from0 : phsw.from1);
            }
        }
    }

    private void addComment(Bytes<?> bytes, Object arg) {
        if (arg instanceof Marshallable) {
            bytes.comment(arg.getClass().getSimpleName());
        } else {
            bytes.comment(String.valueOf(arg));
        }
    }

    @Override
    public void recordHistory(boolean recordHistory) {
        this.recordHistory = recordHistory;
    }

    @Override
    public void methodWriterInterceptorReturns(MethodWriterInterceptorReturns methodWriterInterceptorReturns) {
        this.methodWriterInterceptorReturns = methodWriterInterceptorReturns;
    }

    @Override
    public void useMethodIds(boolean useMethodIds) {
        this.useMethodIds = useMethodIds;
    }
}

