/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.HotMethod;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.threads.CoreEventLoop;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.Threads;
import net.openhft.chronicle.threads.internal.EventLoopUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaEventLoop
extends AbstractCloseable
implements CoreEventLoop,
Runnable,
Closeable {
    public static final Set<HandlerPriority> ALLOWED_PRIORITIES = Collections.unmodifiableSet(EnumSet.of(HandlerPriority.HIGH, HandlerPriority.MEDIUM, HandlerPriority.TIMER, HandlerPriority.DAEMON));
    public static final int NO_CPU = -1;
    static final boolean CHECK_INTERRUPTS = !Jvm.getBoolean("chronicle.eventLoop.ignoreInterrupts");
    static final EventHandler[] NO_EVENT_HANDLERS = new EventHandler[0];
    static final long FINISHED = 0x7FFFFFFFFFFFFFFEL;
    private static final Logger LOG = LoggerFactory.getLogger(VanillaEventLoop.class);
    private final EventLoop parent;
    @NotNull
    private final ExecutorService service;
    private final List<EventHandler> mediumHandlers = new CopyOnWriteArrayList<EventHandler>();
    private final List<EventHandler> timerHandlers = new CopyOnWriteArrayList<EventHandler>();
    private final List<EventHandler> daemonHandlers = new CopyOnWriteArrayList<EventHandler>();
    private final AtomicReference<EventHandler> newHandler = new AtomicReference();
    @NotNull
    private final AtomicBoolean running = new AtomicBoolean();
    private final Pauser pauser;
    private final long timerIntervalMS;
    private final boolean daemon;
    private final String name;
    private final String binding;
    private final Set<HandlerPriority> priorities;
    @NotNull
    private EventHandler[] mediumHandlersArray = NO_EVENT_HANDLERS;
    private volatile long loopStartMS;
    @Nullable
    private volatile Thread thread = null;

    public VanillaEventLoop(EventLoop parent, String name, Pauser pauser, long timerIntervalMS, boolean daemon, String binding, Set<HandlerPriority> priorities) {
        this.parent = parent;
        this.name = name;
        this.pauser = pauser;
        this.timerIntervalMS = timerIntervalMS;
        this.daemon = daemon;
        this.binding = binding;
        this.priorities = EnumSet.copyOf(priorities);
        this.loopStartMS = Long.MAX_VALUE;
        this.service = Executors.newSingleThreadExecutor(new NamedThreadFactory(name, daemon));
    }

    @Deprecated
    public VanillaEventLoop(EventLoop parent, String name, Pauser pauser, long timerIntervalMS, boolean daemon, boolean binding, int bindingCpu) {
        this(parent, name, pauser, timerIntervalMS, daemon, bindingCpu != -1 ? Integer.toString(bindingCpu) : (binding ? "any" : "none"), ALLOWED_PRIORITIES);
    }

    @Deprecated
    public VanillaEventLoop(EventLoop parent, String name, Pauser pauser, long timerIntervalMS, boolean daemon, boolean binding) {
        this(parent, name, pauser, timerIntervalMS, daemon, binding ? "any" : "none", ALLOWED_PRIORITIES);
    }

    public static void closeAll(@NotNull List<EventHandler> handlers) {
        Closeable.closeQuietly(handlers);
    }

    @Override
    @Nullable
    public Thread thread() {
        return this.thread;
    }

    @Override
    public void awaitTermination() {
        try {
            this.service.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @NotNull
    public String toString() {
        return "VanillaEventLoop{name='" + this.name + '\'' + ", parent=" + this.parent + ", service=" + this.service + ", mediumHandlers=" + this.mediumHandlers + ", timerHandlers=" + this.timerHandlers + ", daemonHandlers=" + this.daemonHandlers + ", newHandler=" + this.newHandler + ", pauser=" + this.pauser + '}';
    }

    @Override
    public void start() {
        block4: {
            this.throwExceptionIfClosed();
            if (this.running.getAndSet(true)) {
                return;
            }
            try {
                this.service.submit(this);
            }
            catch (IllegalStateException ise) {
                Slf4jExceptionHandler.WARN.on(this.getClass(), "Not started as already closed", ise);
            }
            catch (RejectedExecutionException e) {
                if (this.isClosed()) break block4;
                this.closeAll();
                throw e;
            }
        }
    }

    @Override
    public void unpause() {
        this.pauser.unpause();
    }

    @Override
    public void stop() {
        this.running.set(false);
    }

    @Override
    public void addHandler(@NotNull EventHandler handler) {
        this.throwExceptionIfClosed();
        this.checkInterrupted();
        HandlerPriority priority = handler.priority();
        if (DEBUG_ADDING_HANDLERS) {
            System.out.println("Adding " + (Object)((Object)priority) + " " + handler + " to " + this.name);
        }
        if (!this.priorities.contains((Object)priority)) {
            throw new IllegalStateException(this.name() + ": Unexpected priority " + (Object)((Object)priority) + " for " + handler + " allows " + this.priorities);
        }
        if (this.thread == null || this.thread == Thread.currentThread()) {
            this.addNewHandler(handler);
            return;
        }
        do {
            this.pauser.unpause();
            this.throwExceptionIfClosed();
            this.checkInterrupted();
        } while (!this.newHandler.compareAndSet(null, handler));
    }

    void checkInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            throw new IllegalStateException(this.hasBeen("interrupted"));
        }
    }

    @Override
    public long loopStartMS() {
        return this.loopStartMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @HotMethod
    public void run() {
        try {
            try (AffinityLock lock2 = AffinityLock.acquireLock(this.binding);){
                this.thread = Thread.currentThread();
                if (this.thread == null) {
                    throw new NullPointerException();
                }
                this.runLoop();
            }
            catch (InvalidEventHandlerException lock2) {
            }
            finally {
                this.loopFinishedAllHandlers();
                this.loopStartMS = 0x7FFFFFFFFFFFFFFEL;
            }
        }
        catch (Throwable e) {
            Jvm.warn().on(this.getClass(), this.hasBeen("terminated due to exception"), e);
        }
    }

    private void loopFinishedAllHandlers() {
        this.mediumHandlers.forEach(Threads::loopFinishedQuietly);
        this.timerHandlers.forEach(Threads::loopFinishedQuietly);
        this.daemonHandlers.forEach(Threads::loopFinishedQuietly);
    }

    private void runLoop() throws InvalidEventHandlerException {
        long lastTimerMS = 0L;
        int acceptHandlerModCount = EventLoopUtil.ACCEPT_HANDLER_MOD_COUNT;
        while (this.running.get() && this.isNotInterrupted()) {
            if (this.isClosed()) {
                throw new InvalidEventHandlerException();
            }
            boolean busy = this.runMediumLoopOnly();
            if (lastTimerMS + this.timerIntervalMS < this.loopStartMS) {
                lastTimerMS = this.loopStartMS;
                this.runTimerHandlers();
            }
            if (busy) {
                this.pauser.reset();
                if (!EventLoopUtil.IS_ACCEPT_HANDLER_MOD_COUNT || --acceptHandlerModCount > 0) continue;
                this.acceptNewHandlers();
                acceptHandlerModCount = EventLoopUtil.ACCEPT_HANDLER_MOD_COUNT;
                continue;
            }
            if (this.acceptNewHandlers()) continue;
            this.runDaemonHandlers();
            this.loopStartMS = Long.MAX_VALUE;
            this.pauser.pause();
        }
    }

    private boolean isNotInterrupted() {
        return !CHECK_INTERRUPTS || !Thread.currentThread().isInterrupted();
    }

    private boolean runMediumLoopOnly() {
        this.loopStartMS = Time.currentTimeMillis();
        return this.runAllMediumHandler();
    }

    private void closeAll() {
        this.closeAllHandlers();
        LOG.trace("Remaining handlers");
        this.dumpRunningHandlers();
    }

    @HotMethod
    private boolean runOneQuarterMediumHandler(int i) {
        boolean busy = false;
        EventHandler[] mediumHandlersArray = this.mediumHandlersArray;
        for (int j = i; j < mediumHandlersArray.length; j += 4) {
            EventHandler handler = mediumHandlersArray[j];
            try {
                busy |= handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                this.removeMediumHandler(handler);
                continue;
            }
            catch (Throwable e) {
                Jvm.warn().on(this.getClass(), e);
            }
        }
        return busy;
    }

    @HotMethod
    private boolean runAllMediumHandler() {
        boolean busy = false;
        EventHandler[] handlers = this.mediumHandlersArray;
        try {
            switch (handlers.length) {
                case 4: {
                    try {
                        busy |= handlers[3].action();
                    }
                    catch (InvalidEventHandlerException e) {
                        this.removeMediumHandler(handlers[3]);
                    }
                }
                case 3: {
                    try {
                        busy |= handlers[2].action();
                    }
                    catch (InvalidEventHandlerException e) {
                        this.removeMediumHandler(handlers[2]);
                    }
                }
                case 2: {
                    try {
                        busy |= handlers[1].action();
                    }
                    catch (InvalidEventHandlerException e) {
                        this.removeMediumHandler(handlers[1]);
                    }
                }
                case 1: {
                    try {
                        busy |= handlers[0].action();
                        break;
                    }
                    catch (InvalidEventHandlerException e) {
                        this.removeMediumHandler(handlers[0]);
                    }
                }
                case 0: {
                    break;
                }
                default: {
                    for (EventHandler handler : handlers) {
                        try {
                            busy |= handler.action();
                        }
                        catch (InvalidEventHandlerException e) {
                            this.removeMediumHandler(handler);
                        }
                    }
                    break;
                }
            }
        }
        catch (Throwable e) {
            Jvm.warn().on(this.getClass(), e);
        }
        return busy;
    }

    private void removeMediumHandler(EventHandler handler) {
        this.removeHandler(handler, this.mediumHandlers);
        this.mediumHandlersArray = this.mediumHandlers.toArray(NO_EVENT_HANDLERS);
    }

    @HotMethod
    private void runTimerHandlers() {
        for (int i = 0; i < this.timerHandlers.size(); ++i) {
            EventHandler handler = null;
            try {
                handler = this.timerHandlers.get(i);
                handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                this.removeHandler(handler, this.timerHandlers);
                continue;
            }
            catch (Throwable e) {
                Jvm.warn().on(this.getClass(), e);
            }
        }
    }

    @HotMethod
    private void runDaemonHandlers() {
        for (int i = 0; i < this.daemonHandlers.size(); ++i) {
            EventHandler handler = null;
            try {
                handler = this.daemonHandlers.get(i);
                handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                this.removeHandler(handler, this.daemonHandlers);
                continue;
            }
            catch (Throwable e) {
                Jvm.warn().on(this.getClass(), e);
            }
        }
    }

    private void removeHandler(EventHandler handler, @NotNull List<EventHandler> handlers) {
        block2: {
            try {
                handlers.remove(handler);
                Threads.loopFinishedQuietly(handler);
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                if (handlers.isEmpty()) break block2;
                throw e2;
            }
        }
        Closeable.closeQuietly((Object)handler);
    }

    @HotMethod
    private boolean acceptNewHandlers() {
        EventHandler handler = this.newHandler.getAndSet(null);
        if (handler != null) {
            this.addNewHandler(handler);
            return true;
        }
        return false;
    }

    private void addNewHandler(@NotNull EventHandler handler) {
        if (handler instanceof AbstractCloseable) {
            ((AbstractCloseable)((Object)handler)).resetUsedByThread();
        }
        HandlerPriority t1 = handler.priority();
        switch (t1.alias()) {
            case HIGH: 
            case MEDIUM: {
                if (this.mediumHandlers.contains(handler)) break;
                this.mediumHandlers.add(handler);
                this.mediumHandlers.sort(Comparator.comparing(EventHandler::priority));
                this.mediumHandlersArray = this.mediumHandlers.toArray(NO_EVENT_HANDLERS);
                break;
            }
            case TIMER: {
                if (this.timerHandlers.contains(handler)) break;
                this.timerHandlers.add(handler);
                break;
            }
            case DAEMON: {
                if (this.daemonHandlers.contains(handler)) break;
                this.daemonHandlers.add(handler);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot add a " + (Object)((Object)handler.priority()) + " task to a busy waiting thread");
            }
        }
        handler.eventLoop(this.parent);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void dumpRunningState(@NotNull String message, @NotNull BooleanSupplier finalCheck) {
        Thread thread = this.thread;
        if (thread == null) {
            return;
        }
        StringBuilder out = new StringBuilder(message);
        Jvm.trimStackTrace(out, thread.getStackTrace());
        if (finalCheck.getAsBoolean() && LOG.isInfoEnabled()) {
            LOG.info(out.toString());
        }
    }

    public int nonDaemonHandlerCount() {
        return this.mediumHandlers.size();
    }

    public int handlerCount() {
        return this.mediumHandlers.size() + this.daemonHandlers.size() + this.timerHandlers.size();
    }

    @Override
    protected void performClose() {
        block7: {
            try {
                this.stop();
                this.pauser.reset();
                this.pauser.unpause();
                LockSupport.unpark(this.thread);
                Threads.shutdown(this.service, this.daemon);
                if (this.thread == null) {
                    this.loopFinishedAllHandlers();
                    return;
                }
                if (this.thread == Thread.currentThread()) break block7;
                this.thread.interrupt();
                for (int i = 1; i <= 30; ++i) {
                    if (this.loopStartMS == 0x7FFFFFFFFFFFFFFEL) {
                        break;
                    }
                    Jvm.pause(i);
                    if (i % 10 != 0) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.name).append(": Shutting down thread is executing ").append(this.thread).append(", handlerCount=").append(this.nonDaemonHandlerCount());
                    Jvm.trimStackTrace(sb, this.thread.getStackTrace());
                    Jvm.warn().on(this.getClass(), sb.toString());
                    this.dumpRunningHandlers();
                }
            }
            finally {
                this.closeAllHandlers();
                this.mediumHandlers.clear();
                this.mediumHandlersArray = NO_EVENT_HANDLERS;
                this.daemonHandlers.clear();
                this.timerHandlers.clear();
                this.newHandler.set(null);
            }
        }
    }

    void closeAllHandlers() {
        VanillaEventLoop.closeAll(this.mediumHandlers);
        VanillaEventLoop.closeAll(this.daemonHandlers);
        VanillaEventLoop.closeAll(this.timerHandlers);
        Optional.ofNullable(this.newHandler.get()).ifPresent(eventHandler -> {
            Jvm.warn().on(this.getClass(), "Handler in newHandler was not accepted before close " + eventHandler);
            Closeable.closeQuietly(eventHandler);
        });
    }

    public void dumpRunningHandlers() {
        int handlerCount = this.handlerCount();
        if (handlerCount <= 0) {
            return;
        }
        List<EventHandler> collect = Stream.of(this.mediumHandlers, this.daemonHandlers, this.timerHandlers).flatMap(Collection::stream).filter(e -> e instanceof Closeable).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return;
        }
        LOG.info("Handlers still running after being closed, handlerCount=" + handlerCount);
        collect.forEach(h -> LOG.info("\t" + h));
    }

    @Override
    public boolean isAlive() {
        Thread thread = this.thread;
        return thread != null && thread.isAlive();
    }

    private String hasBeen(String offendingProperty) {
        return String.format("%s has been %s.", VanillaEventLoop.class.getSimpleName(), offendingProperty);
    }

    @Override
    protected boolean threadSafetyCheck() {
        return true;
    }
}

