/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.table;

import java.io.File;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.threads.TimingPauser;

public abstract class AbstractTSQueueLock
extends AbstractCloseable
implements Closeable {
    protected static final long UNLOCKED = Long.MIN_VALUE;
    protected final LongValue lock;
    protected final TimingPauser pauser;
    protected final File path;
    protected final TableStore tableStore;

    public AbstractTSQueueLock(String lockKey, TableStore<?> tableStore, Supplier<TimingPauser> pauser) {
        this.tableStore = tableStore;
        this.lock = tableStore.doWithExclusiveLock(ts -> ts.acquireValueFor(lockKey));
        this.pauser = pauser.get();
        this.path = tableStore.file();
    }

    @Override
    protected void performClose() {
        Closeable.closeQuietly((Object)this.lock);
    }

    @Override
    public void throwExceptionIfClosed() {
        super.throwExceptionIfClosed();
        this.tableStore.throwExceptionIfClosed();
    }

    protected void forceUnlock() {
        Jvm.warn().on(this.getClass(), "Forced unlock for the lock file:" + this.path, new StackTrace("Forced unlock"));
        this.lock.setValue(Long.MIN_VALUE);
    }

    @Override
    protected boolean threadSafetyCheck() {
        return true;
    }
}

