/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.harness.WeeklyRollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class QueueReadForwardSkippingACycleBiggerThanADayTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File dataDir;
    private SetTimeProvider timeProvider;

    @Before
    public void setup() throws IOException {
        this.dataDir = this.temporaryFolder.newFolder();
        this.timeProvider = new SetTimeProvider();
    }

    @Test
    public void testReadForwards() {
        WeeklyRollCycle rollingCycle = WeeklyRollCycle.INSTANCE;
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)this.dataDir).timeProvider((TimeProvider)this.timeProvider).rollCycle((RollCycle)rollingCycle).build();){
            queue.acquireAppender().writeText((CharSequence)"0");
        }
        this.timeProvider.advanceMillis(TimeUnit.DAYS.toMillis(18L));
        queue = ChronicleQueue.singleBuilder((File)this.dataDir).timeProvider((TimeProvider)this.timeProvider).rollCycle((RollCycle)rollingCycle).build();
        var3_3 = null;
        try {
            queue.acquireAppender().writeText((CharSequence)"42");
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (queue != null) {
                if (var3_3 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    queue.close();
                }
            }
        }
        queue = ChronicleQueue.singleBuilder((File)this.dataDir).timeProvider((TimeProvider)this.timeProvider).rollCycle((RollCycle)rollingCycle).build();
        var3_3 = null;
        try {
            ExcerptTailer tailer = queue.createTailer().toStart().direction(TailerDirection.FORWARD);
            TestCase.assertEquals((String)"0", (String)tailer.readText());
            TestCase.assertEquals((String)"42", (String)tailer.readText());
            Assert.assertNull((Object)tailer.readText());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (queue != null) {
                if (var3_3 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }
}

