/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.junit.Assert;
import org.junit.Test;

public class PeekDocumentTest {
    private static final String EXPECTED_MESSAGE = "hello world";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWrite() {
        File tempDir = DirectoryUtils.tempDir("to-be-deleted");
        try {
            Bytes bytes = Bytes.fromString((String)EXPECTED_MESSAGE);
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tempDir).build();){
                ExcerptAppender appender = queue.acquireAppender();
                appender.writeText((CharSequence)"hello");
                ExcerptTailer tailer = queue.createTailer();
                Assert.assertTrue((boolean)tailer.peekDocument());
            }
        }
        finally {
            tempDir.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test2() {
        File tempDir = DirectoryUtils.tempDir("to-be-deleted");
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tempDir).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeText((CharSequence)"hello1");
            appender.writeText((CharSequence)"hello2");
            ExcerptTailer tailer = queue.createTailer();
            long address1a = (Long)Jvm.getValue((Object)tailer, (String)"address");
            Assert.assertTrue((boolean)tailer.moveToIndex(tailer.index() + 1L));
            long address1b = (Long)Jvm.getValue((Object)tailer, (String)"address");
            Assert.assertNotEquals((long)address1a, (long)address1b);
            Assert.assertFalse((boolean)tailer.moveToIndex(tailer.index() + 1L));
            long address1c = (Long)Jvm.getValue((Object)tailer, (String)"address");
            Assert.assertEquals((long)address1c, (long)NoBytesStore.NO_PAGE);
        }
        finally {
            tempDir.deleteOnExit();
        }
    }
}

