/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import org.junit.Assert;
import org.junit.Test;

public class AcquireReleaseTest
extends ChronicleQueueTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccquireAndRelease() throws Exception {
        File dir = DirectoryUtils.tempDir("AcquireReleaseTest");
        try {
            final AtomicInteger acount = new AtomicInteger();
            final AtomicInteger qcount = new AtomicInteger();
            StoreFileListener sfl = new StoreFileListener(){

                public void onAcquired(int cycle, File file) {
                    System.out.println("onAcquired(): " + file);
                    acount.incrementAndGet();
                }

                public void onReleased(int cycle, File file) {
                    System.out.println("onReleased(): " + file);
                    qcount.incrementAndGet();
                }
            };
            AtomicLong time = new AtomicLong(1000L);
            TimeProvider tp = () -> time.getAndAccumulate(1000L, (x, y) -> x + y);
            SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)dir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_SECONDLY).storeFileListener(sfl).timeProvider(tp).build();
            for (int i = 0; i < 10; ++i) {
                queue.acquireAppender().writeDocument(w -> w.write((CharSequence)"a").marshallable(m -> m.write((CharSequence)"b").text("c")));
            }
            Assert.assertEquals((long)10L, (long)acount.get());
            Assert.assertEquals((long)9L, (long)qcount.get());
            queue.close();
        }
        finally {
            try {
                IOTools.deleteDirWithFiles((File)dir, (int)2);
            }
            catch (IORuntimeException iORuntimeException) {}
        }
    }
}

