/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.TreeMap;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.micros.Order;
import net.openhft.chronicle.queue.micros.Side;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class SingleCQFormat2Test
extends ChronicleQueueTestBase {
    private int appendMode;
    private ThreadDump threadDump;

    private static void assertHexEquals(long a, long b) {
        if (a != b) {
            Assert.assertEquals((String)(Long.toHexString(a) + " != " + Long.toHexString(b)), (long)a, (long)b);
        }
    }

    @Test
    public void testMyData() {
        File dir = this.getTmpDir();
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{MyData.class});
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)RollCycles.TEST_DAILY).blockSize(65536).build();){
            ExcerptAppender appender = queue.acquireAppender();
            try (DocumentContext dc = appender.writingDocument();){
                MyData name = new MyData("name", 12345L, 1.2, 111);
                System.out.println((Object)name);
                name.writeMarshallable((WireOut)dc.wire());
                MyData name2 = new MyData("name2", 12346L, 1.3, 112);
                System.out.println((Object)name2);
                name2.writeMarshallable((WireOut)dc.wire());
            }
            String dump = queue.dump();
            Assert.assertTrue((String)dump, (boolean)dump.contains("--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  384,\n  0, 0, 0, 0, 0, 0, 0\n]"));
        }
    }

    @Test
    public void testWritingThreeMessages() throws FileNotFoundException {
        int m = 0;
        while (m <= 2) {
            this.appendMode = m++;
            File dir = this.getTmpDir();
            dir.mkdir();
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(65536).indexCount(8).indexSpacing(1).build();){
                long start = RollCycles.DAILY.toIndex(queue.cycle(), 0L);
                this.appendMessage((ChronicleQueue)queue, start, "Hello World");
                String expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    384,\n    1649267441664\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 184,\n    lastIndex: 1\n  }\n}\n# position: 184, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  288,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 288, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  384,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 384, header: 0\n--- !!data #binary\nmsg: Hello World\n...\n# 130664 bytes remaining\n";
                this.checkFileContents(this.getFirstQueueFile(dir), expectedEager);
                this.appendMessage((ChronicleQueue)queue, start + 1L, "Another Hello World");
                String expectedEager2 = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    404,\n    1735166787585\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 184,\n    lastIndex: 2\n  }\n}\n# position: 184, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  288,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 288, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  384,\n  404,\n  0, 0, 0, 0, 0, 0\n]\n# position: 384, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 404, header: 1\n--- !!data #binary\nmsg: Another Hello World\n...\n# 130636 bytes remaining\n";
                this.checkFileContents(this.getFirstQueueFile(dir), expectedEager2);
                this.appendMessage((ChronicleQueue)queue, start + 2L, "Bye for now");
                String expectedEager3 = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    432,\n    1855425871874\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 184,\n    lastIndex: 3\n  }\n}\n# position: 184, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  288,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 288, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 3\n  384,\n  404,\n  432,\n  0, 0, 0, 0, 0\n]\n# position: 384, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 404, header: 1\n--- !!data #binary\nmsg: Another Hello World\n# position: 432, header: 2\n--- !!data #binary\nmsg: Bye for now\n...\n# 130616 bytes remaining\n";
                this.checkFileContents(this.getFirstQueueFile(dir), expectedEager3);
            }
        }
    }

    private File getFirstQueueFile(File file) {
        return file.listFiles((d, n) -> n.endsWith(".cq4"))[0];
    }

    public void checkFileContents(@NotNull File file, String expected) throws FileNotFoundException {
        MappedBytes bytes = MappedBytes.mappedBytes((File)file, (long)65536L);
        bytes.readLimit(bytes.realCapacity());
        Assert.assertEquals((Object)expected, (Object)Wires.fromSizePrefixedBlobs((Bytes)bytes));
        bytes.release();
    }

    @Test
    public void testWritingTwentyMessagesTinyIndex() throws FileNotFoundException {
        Assume.assumeFalse((boolean)Jvm.isArm());
        for (int spacing : new int[]{1, 2, 4}) {
            File dir = this.getTmpDir();
            dir.mkdir();
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(65536).indexCount(8).indexSpacing(spacing).build();){
                long start = RollCycles.DAILY.toIndex(queue.cycle(), 0L);
                ExcerptTailer tailer = queue.createTailer();
                Assert.assertFalse((boolean)tailer.moveToIndex(start));
                this.appendMessage((ChronicleQueue)queue, start, "Hello World");
                String expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    384,\n    1649267441664\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 184,\n    lastIndex: 1\n  }\n}\n# position: 184, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  288,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 288, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  384,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 384, header: 0\n--- !!data #binary\nmsg: Hello World\n...\n# 130664 bytes remaining\n";
                this.checkFileContents(this.getFirstQueueFile(dir), expectedEager.replace("indexSpacing: 1", "indexSpacing: " + spacing).replace("lastIndex: 1", "lastIndex: " + spacing));
                Assert.assertTrue((boolean)tailer.moveToIndex(start));
                for (int i = 1; i < 19; ++i) {
                    Assert.assertFalse((boolean)tailer.moveToIndex(start + (long)i));
                    this.appendMessage((ChronicleQueue)queue, start + (long)i, "Another Hello World " + (i + 1));
                    Assert.assertTrue((boolean)tailer.moveToIndex(start + (long)i));
                }
                Assert.assertFalse((boolean)tailer.moveToIndex(start + 19L));
                this.appendMessage((ChronicleQueue)queue, start + 19L, "Bye for now");
                Assert.assertTrue((boolean)tailer.moveToIndex(start + 19L));
                Assert.assertFalse((boolean)tailer.moveToIndex(start + 20L));
                String expected1 = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    1152,\n    4947802325011\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 184,\n    lastIndex: 20\n  }\n}\n# position: 184, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 3\n  288,\n  644,\n  991,\n  0, 0, 0, 0, 0\n]\n# position: 288, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 8\n  384,\n  404,\n  434,\n  464,\n  494,\n  524,\n  554,\n  584\n]\n# position: 384, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 404, header: 1\n--- !!data #binary\nmsg: Another Hello World 2\n# position: 434, header: 2\n--- !!data #binary\nmsg: Another Hello World 3\n# position: 464, header: 3\n--- !!data #binary\nmsg: Another Hello World 4\n# position: 494, header: 4\n--- !!data #binary\nmsg: Another Hello World 5\n# position: 524, header: 5\n--- !!data #binary\nmsg: Another Hello World 6\n# position: 554, header: 6\n--- !!data #binary\nmsg: Another Hello World 7\n# position: 584, header: 7\n--- !!data #binary\nmsg: Another Hello World 8\n# position: 614, header: 8\n--- !!data #binary\nmsg: Another Hello World 9\n# position: 644, header: 8\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 8\n  614,\n  736,\n  768,\n  799,\n  832,\n  863,\n  896,\n  927\n]\n# position: 736, header: 9\n--- !!data #binary\nmsg: Another Hello World 10\n# position: 768, header: 10\n--- !!data #binary\nmsg: Another Hello World 11\n# position: 799, header: 11\n--- !!data #binary\nmsg: Another Hello World 12\n# position: 832, header: 12\n--- !!data #binary\nmsg: Another Hello World 13\n# position: 863, header: 13\n--- !!data #binary\nmsg: Another Hello World 14\n# position: 896, header: 14\n--- !!data #binary\nmsg: Another Hello World 15\n# position: 927, header: 15\n--- !!data #binary\nmsg: Another Hello World 16\n# position: 960, header: 16\n--- !!data #binary\nmsg: Another Hello World 17\n# position: 991, header: 16\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 4\n  960,\n  1088,\n  1119,\n  1152,\n  0, 0, 0, 0\n]\n# position: 1088, header: 17\n--- !!data #binary\nmsg: Another Hello World 18\n# position: 1119, header: 18\n--- !!data #binary\nmsg: Another Hello World 19\n# position: 1152, header: 19\n--- !!data #binary\nmsg: Bye for now\n...\n# 129896 bytes remaining\n";
                String expected2 = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    1055,\n    4531190497299\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 2,\n    index2Index: 184,\n    lastIndex: 20\n  }\n}\n# position: 184, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 2\n  288,\n  896,\n  0, 0, 0, 0, 0, 0\n]\n# position: 288, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 8\n  384,\n  434,\n  494,\n  554,\n  614,\n  675,\n  737,\n  799\n]\n# position: 384, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 404, header: 1\n--- !!data #binary\nmsg: Another Hello World 2\n# position: 434, header: 2\n--- !!data #binary\nmsg: Another Hello World 3\n# position: 464, header: 3\n--- !!data #binary\nmsg: Another Hello World 4\n# position: 494, header: 4\n--- !!data #binary\nmsg: Another Hello World 5\n# position: 524, header: 5\n--- !!data #binary\nmsg: Another Hello World 6\n# position: 554, header: 6\n--- !!data #binary\nmsg: Another Hello World 7\n# position: 584, header: 7\n--- !!data #binary\nmsg: Another Hello World 8\n# position: 614, header: 8\n--- !!data #binary\nmsg: Another Hello World 9\n# position: 644, header: 9\n--- !!data #binary\nmsg: Another Hello World 10\n# position: 675, header: 10\n--- !!data #binary\nmsg: Another Hello World 11\n# position: 706, header: 11\n--- !!data #binary\nmsg: Another Hello World 12\n# position: 737, header: 12\n--- !!data #binary\nmsg: Another Hello World 13\n# position: 768, header: 13\n--- !!data #binary\nmsg: Another Hello World 14\n# position: 799, header: 14\n--- !!data #binary\nmsg: Another Hello World 15\n# position: 832, header: 15\n--- !!data #binary\nmsg: Another Hello World 16\n# position: 863, header: 16\n--- !!data #binary\nmsg: Another Hello World 17\n# position: 896, header: 16\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  863,\n  1024,\n  0, 0, 0, 0, 0, 0\n]\n# position: 992, header: 17\n--- !!data #binary\nmsg: Another Hello World 18\n# position: 1024, header: 18\n--- !!data #binary\nmsg: Another Hello World 19\n# position: 1055, header: 19\n--- !!data #binary\nmsg: Bye for now\n...\n# 129993 bytes remaining\n";
                String expected3 = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    960,\n    4123168604179\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 4,\n    index2Index: 184,\n    lastIndex: 20\n  }\n}\n# position: 184, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  288,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 288, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 5\n  384,\n  494,\n  614,\n  737,\n  863,\n  0, 0, 0\n]\n# position: 384, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 404, header: 1\n--- !!data #binary\nmsg: Another Hello World 2\n# position: 434, header: 2\n--- !!data #binary\nmsg: Another Hello World 3\n# position: 464, header: 3\n--- !!data #binary\nmsg: Another Hello World 4\n# position: 494, header: 4\n--- !!data #binary\nmsg: Another Hello World 5\n# position: 524, header: 5\n--- !!data #binary\nmsg: Another Hello World 6\n# position: 554, header: 6\n--- !!data #binary\nmsg: Another Hello World 7\n# position: 584, header: 7\n--- !!data #binary\nmsg: Another Hello World 8\n# position: 614, header: 8\n--- !!data #binary\nmsg: Another Hello World 9\n# position: 644, header: 9\n--- !!data #binary\nmsg: Another Hello World 10\n# position: 675, header: 10\n--- !!data #binary\nmsg: Another Hello World 11\n# position: 706, header: 11\n--- !!data #binary\nmsg: Another Hello World 12\n# position: 737, header: 12\n--- !!data #binary\nmsg: Another Hello World 13\n# position: 768, header: 13\n--- !!data #binary\nmsg: Another Hello World 14\n# position: 799, header: 14\n--- !!data #binary\nmsg: Another Hello World 15\n# position: 832, header: 15\n--- !!data #binary\nmsg: Another Hello World 16\n# position: 863, header: 16\n--- !!data #binary\nmsg: Another Hello World 17\n# position: 896, header: 17\n--- !!data #binary\nmsg: Another Hello World 18\n# position: 927, header: 18\n--- !!data #binary\nmsg: Another Hello World 19\n# position: 960, header: 19\n--- !!data #binary\nmsg: Bye for now\n...\n# 130088 bytes remaining\n";
                String expected = spacing == 1 ? expected1 : (spacing == 2 ? expected2 : expected3);
                this.checkFileContents(this.getFirstQueueFile(dir), expected);
            }
        }
    }

    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
        this.threadDump.ignore("queue-thread-local-cleaner-daemon");
        this.threadDump.ignore("disk-space-checker");
    }

    @After
    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @Before
    public void resetAppendMode() {
        this.appendMode = 0;
    }

    /*
     * Unable to fully structure code
     */
    public void appendMessage(@NotNull ChronicleQueue queue, long expectedIndex, String msg) {
        appender = queue.acquireAppender();
        switch (this.appendMode) {
            case 1: {
                appender.writeDocument((WriteMarshallable)LambdaMetafactory.metafactory(null, null, null, (Lnet/openhft/chronicle/wire/WireOut;)V, lambda$appendMessage$2(java.lang.String net.openhft.chronicle.wire.WireOut ), (Lnet/openhft/chronicle/wire/WireOut;)V)((String)msg));
                break;
            }
            case 2: {
                bytes = Bytes.elasticByteBuffer();
                new BinaryWire(bytes).write((WireKey)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/CharSequence;, lambda$appendMessage$3(), ()Ljava/lang/CharSequence;)()).text(msg);
                appender.writeBytes(bytes);
                bytes.release();
                break;
            }
            default: {
                dc = appender.writingDocument();
                var8_8 = null;
                wire = dc.wire();
                wire.write((WireKey)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/CharSequence;, lambda$appendMessage$4(), ()Ljava/lang/CharSequence;)()).text(msg);
                if (dc == null) break;
                if (var8_8 == null) ** GOTO lbl28
                try {
                    dc.close();
                }
                catch (Throwable var9_10) {
                    var8_8.addSuppressed(var9_10);
                }
                break;
lbl28:
                // 1 sources

                dc.close();
                break;
                catch (Throwable var9_11) {
                    try {
                        var8_8 = var9_11;
                        throw var9_11;
                    }
                    catch (Throwable var10_12) {
                        if (dc != null) {
                            if (var8_8 != null) {
                                try {
                                    dc.close();
                                }
                                catch (Throwable var11_13) {
                                    var8_8.addSuppressed(var11_13);
                                }
                            } else {
                                dc.close();
                            }
                        }
                        throw var10_12;
                    }
                }
            }
        }
        index = appender.lastIndexAppended();
        SingleCQFormat2Test.assertHexEquals(expectedIndex, index);
    }

    @Test
    public void writeMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put("abc", "def");
        map.put("hello", "world");
        map.put("number", 1L);
        map.put("double", 1.28);
        File dir = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(65536).rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeMap(map);
            map.put("abc", "aye-bee-see");
            appender.writeMap(map);
            String expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    444,\n    1906965479425\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 184,\n    lastIndex: 2\n  }\n}\n# position: 184, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  288,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 288, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  384,\n  444,\n  0, 0, 0, 0, 0, 0\n]\n# position: 384, header: 0\n--- !!data #binary\nabc: def\ndouble: 1.28\nhello: world\nnumber: 1\n# position: 444, header: 1\n--- !!data #binary\nabc: aye-bee-see\ndouble: 1.28\nhello: world\nnumber: 1\n...\n# 130556 bytes remaining\n";
            Assert.assertEquals((Object)expectedEager, (Object)queue.dump());
            ExcerptTailer tailer = queue.createTailer();
            Map map2 = tailer.readMap();
            Map map3 = tailer.readMap();
            Assert.assertEquals((Object)"{abc=def, double=1.28, hello=world, number=1}", (Object)map2.toString());
            Assert.assertEquals((Object)"{abc=aye-bee-see, double=1.28, hello=world, number=1}", (Object)map3.toString());
            Assert.assertNull((Object)tailer.readMap());
        }
    }

    @Test
    public void writeMarshallable() {
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{Order.class});
        File dir = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)RollCycles.TEST_DAILY).blockSize(65536).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeDocument((WriteMarshallable)new Order("Symbol", Side.Buy, 1.2345, 1000000.0));
            appender.writeDocument(w -> w.write((CharSequence)"newOrder").object((Object)new Order("Symbol2", Side.Sell, 2.999, 1.0E7)));
            String expectedEager = appender.padToCacheAlignMode() == MarshallableOut.Padding.WORD ? "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    440,\n    1889785610241\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 184,\n    lastIndex: 2\n  }\n}\n# position: 184, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  288,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 288, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  384,\n  440,\n  0, 0, 0, 0, 0, 0\n]\n# position: 384, header: 0\n--- !!data #binary\nsymbol: Symbol\nside: Buy\nlimitPrice: 1.2345\nquantity: 1E6\n# position: 440, header: 1\n--- !!data #binary\nnewOrder: !Order {\n  symbol: Symbol2,\n  side: Sell,\n  limitPrice: 2.999,\n  quantity: 10E6\n}\n...\n# 130548 bytes remaining\n" : "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    439,\n    1885490642945\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 184,\n    lastIndex: 2\n  }\n}\n# position: 184, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  288,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 288, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  384,\n  439,\n  0, 0, 0, 0, 0, 0\n]\n# position: 384, header: 0\n--- !!data #binary\nsymbol: Symbol\nside: Buy\nlimitPrice: 1.2345\nquantity: 1E6\n# position: 439, header: 1\n--- !!data #binary\nnewOrder: !Order {\n  symbol: Symbol2,\n  side: Sell,\n  limitPrice: 2.999,\n  quantity: 10E6\n}\n...\n# 130550 bytes remaining\n";
            Assert.assertEquals((Object)expectedEager, (Object)queue.dump());
        }
    }

    @Test
    public void testWritingIndex() {
        Assume.assumeFalse((boolean)Jvm.isArm());
        File dir = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((File)dir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).blockSize(65536).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeText((CharSequence)"msg-1");
            String expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    384,\n    1649267441664\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 184,\n    lastIndex: 1\n  }\n}\n# position: 184, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  288,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 288, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  384,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 384, header: 0\n--- !!data #binary\nmsg-1\n...\n" + (Jvm.isArm() ? "# 130672 bytes remaining\n" : "# 130674 bytes remaining\n");
            Assert.assertEquals((Object)expectedEager, (Object)queue.dump());
            for (int i = 1; i <= 16; ++i) {
                appender.writeText((CharSequence)("msg-" + i));
            }
            String expectedEager2 = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    644,\n    2765958938640\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 184,\n    lastIndex: 17\n  }\n}\n# position: 184, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 3\n  288,\n  474,\n  655,\n  0, 0, 0, 0, 0\n]\n# position: 288, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 8\n  384,\n  394,\n  404,\n  414,\n  424,\n  434,\n  444,\n  454\n]\n# position: 384, header: 0\n--- !!data #binary\nmsg-1\n# position: 394, header: 1\n--- !!data #binary\nmsg-1\n# position: 404, header: 2\n--- !!data #binary\nmsg-2\n# position: 414, header: 3\n--- !!data #binary\nmsg-3\n# position: 424, header: 4\n--- !!data #binary\nmsg-4\n# position: 434, header: 5\n--- !!data #binary\nmsg-5\n# position: 444, header: 6\n--- !!data #binary\nmsg-6\n# position: 454, header: 7\n--- !!data #binary\nmsg-7\n# position: 464, header: 8\n--- !!data #binary\nmsg-8\n# position: 474, header: 8\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 8\n  464,\n  568,\n  578,\n  589,\n  600,\n  611,\n  622,\n  633\n]\n# position: 568, header: 9\n--- !!data #binary\nmsg-9\n# position: 578, header: 10\n--- !!data #binary\nmsg-10\n# position: 589, header: 11\n--- !!data #binary\nmsg-11\n# position: 600, header: 12\n--- !!data #binary\nmsg-12\n# position: 611, header: 13\n--- !!data #binary\nmsg-13\n# position: 622, header: 14\n--- !!data #binary\nmsg-14\n# position: 633, header: 15\n--- !!data #binary\nmsg-15\n# position: 644, header: 16\n--- !!data #binary\nmsg-16\n# position: 655, header: 16\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  644,\n  0, 0, 0, 0, 0, 0, 0\n]\n...\n# 130316 bytes remaining\n";
            Assert.assertEquals((Object)expectedEager2, (Object)queue.dump());
        }
    }

    @After
    public void checkMappedFiles() {
        MappedFile.checkMappedFiles();
    }

    private static /* synthetic */ CharSequence lambda$appendMessage$4() {
        return "msg";
    }

    private static /* synthetic */ CharSequence lambda$appendMessage$3() {
        return "msg";
    }

    private static /* synthetic */ void lambda$appendMessage$2(String msg, WireOut w) {
        w.write(() -> "msg").text(msg);
    }

    static {
        SingleChronicleQueueBuilder.addAliases();
    }

    private static class MyData
    extends SelfDescribingMarshallable {
        final String name;
        final long num;
        final double d;
        final int counter;

        MyData(String name, long num, double d, int counter) {
            this.name = name;
            this.num = num;
            this.d = d;
            this.counter = counter;
        }
    }
}

