/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ValueIn;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public final class EofMarkerOnEmptyQueueTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    public void shouldRecoverFromEmptyQueueOnRoll() throws Exception {
        AtomicLong clock = new AtomicLong(System.currentTimeMillis());
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)this.tmpFolder.newFolder()).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).timeProvider(clock::get).timeoutMS(1000L).testBlockSize().build();){
            ExcerptAppender appender = queue.acquireAppender();
            DocumentContext context = appender.writingDocument();
            long expectedEofMarkerPosition = context.wire().bytes().writePosition() - 4L;
            context.wire().writeEventName((CharSequence)"foo").int32(1);
            int startCycle = queue.cycle();
            clock.addAndGet(TimeUnit.SECONDS.toMillis(1L));
            int nextCycle = queue.cycle();
            Assert.assertThat((Object)startCycle, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)nextCycle)));
            Executors.newSingleThreadExecutor().submit(() -> EofMarkerOnEmptyQueueTest.lambda$shouldRecoverFromEmptyQueueOnRoll$0((RollingChronicleQueue)queue)).get(Jvm.isDebug() ? 3000L : 3L, TimeUnit.SECONDS);
            WireStore firstCycleStore = queue.storeForCycle(startCycle, 0L, false);
            Assert.assertNull((Object)firstCycleStore);
            ExcerptTailer tailer = queue.createTailer();
            int recordCount = 0;
            int lastItem = -1;
            while (true) {
                DocumentContext readCtx = tailer.readingDocument();
                Throwable throwable = null;
                try {
                    if (!readCtx.isPresent()) break;
                    StringBuilder name = new StringBuilder();
                    ValueIn field = readCtx.wire().readEventName(name);
                    ++recordCount;
                    lastItem = field.int32();
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (readCtx == null) continue;
                    if (throwable != null) {
                        try {
                            readCtx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    readCtx.close();
                    continue;
                }
                break;
            }
            Assert.assertThat((Object)recordCount, (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)lastItem, (Matcher)CoreMatchers.is((Object)7));
        }
    }

    private static /* synthetic */ void lambda$shouldRecoverFromEmptyQueueOnRoll$0(RollingChronicleQueue queue) {
        try (DocumentContext nextCtx = queue.acquireAppender().writingDocument();){
            nextCtx.wire().writeEventName((CharSequence)"bar").int32(7);
        }
    }
}

