/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.service;

import java.util.List;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.service.ServiceWrapper;
import net.openhft.chronicle.queue.service.ServiceWrapperBuilder;
import net.openhft.chronicle.wire.VanillaMethodWriterBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLoopServiceWrapper<O>
implements ServiceWrapper,
EventHandler {
    @NotNull
    protected final MethodReader[] serviceIn;
    private final HandlerPriority priority;
    @NotNull
    private final ChronicleQueue[] inputQueues;
    @NotNull
    private final ChronicleQueue outputQueue;
    @NotNull
    private final O serviceOut;
    private final boolean createdEventLoop;
    private final Object[] serviceImpl;
    private volatile boolean closed = false;
    @Nullable
    private EventLoop eventLoop;

    public EventLoopServiceWrapper(@NotNull ServiceWrapperBuilder<O> builder) {
        this.priority = builder.priority();
        this.outputQueue = ChronicleQueue.singleBuilder(builder.outputPath()).sourceId(builder.outputSourceId()).checkInterrupts(false).build();
        this.serviceOut = ((VanillaMethodWriterBuilder)this.outputQueue.acquireAppender().methodWriterBuilder((Class)builder.outClass())).recordHistory(builder.outputSourceId() != 0).get();
        this.serviceImpl = builder.getServiceFunctions().stream().map(f -> f.apply(this.serviceOut)).toArray();
        List<String> paths = builder.inputPath();
        this.serviceIn = new MethodReader[paths.size()];
        this.inputQueues = new ChronicleQueue[paths.size()];
        for (int i = 0; i < paths.size(); ++i) {
            this.inputQueues[i] = ChronicleQueue.singleBuilder(paths.get(i)).sourceId(builder.inputSourceId()).build();
            this.serviceIn[i] = this.inputQueues[i].createTailer().afterLastWritten(this.outputQueue).methodReader(this.serviceImpl);
        }
        this.eventLoop = builder.eventLoop();
        this.eventLoop.addHandler(this);
        this.createdEventLoop = builder.createdEventLoop();
        if (this.createdEventLoop) {
            this.eventLoop.start();
        }
    }

    @Override
    @NotNull
    public ChronicleQueue[] inputQueues() {
        return this.inputQueues;
    }

    @Override
    @NotNull
    public ChronicleQueue outputQueue() {
        return this.outputQueue;
    }

    @Override
    public boolean action() throws InvalidEventHandlerException, InterruptedException {
        if (this.isClosed()) {
            Closeable.closeQuietly(this.serviceImpl);
            Closeable.closeQuietly(this.serviceIn);
            Closeable.closeQuietly((Object)this.outputQueue);
            Closeable.closeQuietly(this.inputQueues);
            throw new InvalidEventHandlerException();
        }
        boolean busy = false;
        for (MethodReader reader : this.serviceIn) {
            busy |= reader.readOne();
        }
        return busy;
    }

    @Override
    @NotNull
    public HandlerPriority priority() {
        return this.priority;
    }

    @Override
    public void close() {
        this.closed = true;
        EventLoop eventLoop = this.eventLoop;
        this.eventLoop = null;
        if (this.createdEventLoop && eventLoop != null) {
            eventLoop.close();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

