/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WeakReferenceCleaner
extends WeakReference<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WeakReferenceCleaner.class);
    private static final String THREAD_NAME = "chronicle-weak-reference-cleaner";
    private static final ReferenceQueue<Object> REFERENCE_QUEUE = new ReferenceQueue();
    private static final ConcurrentLinkedQueue<WeakReferenceCleaner> SCHEDULED_CLEAN = new ConcurrentLinkedQueue();
    private static final Set<WeakReferenceCleaner> REFERENCE_SET = Collections.synchronizedSet(new HashSet(128));
    private static final AtomicBoolean REFERENCE_PROCESSOR_STARTED = new AtomicBoolean(false);
    private static final AtomicIntegerFieldUpdater<WeakReferenceCleaner> CLEANED_FLAG = AtomicIntegerFieldUpdater.newUpdater(WeakReferenceCleaner.class, "cleaned");
    static final AtomicBoolean THREAD_SHUTTING_DOWN = new AtomicBoolean();
    private final Runnable thunk;
    private volatile int cleaned = 0;

    private WeakReferenceCleaner(Object referent, Runnable thunk) {
        super(referent, REFERENCE_QUEUE);
        this.thunk = thunk;
    }

    public static WeakReferenceCleaner newCleaner(Object referent, Runnable thunk) {
        WeakReferenceCleaner.startCleanerThreadIfNotStarted();
        WeakReferenceCleaner cleaner = new WeakReferenceCleaner(referent, thunk);
        REFERENCE_SET.add(cleaner);
        return cleaner;
    }

    static void startCleanerThreadIfNotStarted() {
        if (REFERENCE_PROCESSOR_STARTED.compareAndSet(false, true)) {
            Thread thread = new Thread((Runnable)new ReferenceProcessor(), THREAD_NAME);
            thread.setDaemon(true);
            thread.start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> THREAD_SHUTTING_DOWN.set(true), "chronicle-weak-reference-cleaner-shutdown-hook"));
        }
    }

    public void clean() {
        if (CLEANED_FLAG.compareAndSet(this, 0, 1)) {
            this.thunk.run();
        }
    }

    public void scheduleForClean() {
        SCHEDULED_CLEAN.add(this);
        REFERENCE_SET.remove(this);
    }

    private static final class ReferenceProcessor
    implements Runnable {
        public static final long TIMEOUT_MS = 50L;

        private ReferenceProcessor() {
        }

        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            while (!THREAD_SHUTTING_DOWN.get() && !thread.isInterrupted()) {
                try {
                    Reference reference;
                    WeakReferenceCleaner wrc;
                    while ((wrc = (WeakReferenceCleaner)SCHEDULED_CLEAN.poll()) != null) {
                        wrc.clean();
                    }
                    while ((reference = REFERENCE_QUEUE.remove(50L)) != null) {
                        WeakReferenceCleaner cleaner = (WeakReferenceCleaner)reference;
                        REFERENCE_SET.remove(cleaner);
                        cleaner.clean();
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.debug("Interrupted while trying to retrieve reference, exiting.", e);
                    thread.interrupt();
                    return;
                }
                catch (Throwable e) {
                    LOGGER.warn("Exception while trying to process reference.", e);
                }
            }
            LOGGER.debug("Shut down, exiting.");
        }
    }
}

