/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import org.jetbrains.annotations.NotNull;

public class ThreadDump {
    @NotNull
    final Set<Thread> threads;
    final Set<String> ignored = new HashSet<String>();

    public ThreadDump() {
        this.threads = new HashSet<Thread>(Thread.getAllStackTraces().keySet());
        this.ignored.add("Time-limited test");
        this.ignored.add("Attach Listener");
        this.ignored.add("process reaper");
        this.ignored.add("chronicle-weak-reference-cleaner");
        int max = Runtime.getRuntime().availableProcessors();
        for (int i = 0; i < max; ++i) {
            this.ignored.add("ForkJoinPool.commonPool-worker-" + i);
        }
    }

    public void ignore(String threadName) {
        this.ignored.add(threadName);
    }

    public void assertNoNewThreads() {
        this.assertNoNewThreads(0, TimeUnit.NANOSECONDS);
    }

    public void assertNoNewThreads(int delay, @NotNull TimeUnit delayUnit) {
        long start = System.nanoTime();
        long delayNanos = delayUnit.toNanos(delay);
        Map<Thread, StackTraceElement[]> allStackTraces = null;
        int i = 1;
        while (i < 5) {
            Jvm.pause(i * i * 50);
            allStackTraces = Thread.getAllStackTraces();
            allStackTraces.keySet().removeAll(this.threads);
            if (allStackTraces.isEmpty()) {
                return;
            }
            allStackTraces.keySet().removeIf(next -> this.ignored.stream().anyMatch(item -> next.getName().contains((CharSequence)item)));
            if (allStackTraces.isEmpty()) {
                return;
            }
            if (i == 1 && System.nanoTime() - start < delayNanos) continue;
            ++i;
            for (Map.Entry<Thread, StackTraceElement[]> threadEntry : allStackTraces.entrySet()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Thread still running ").append(threadEntry.getKey());
                Jvm.trimStackTrace(sb, threadEntry.getValue());
                System.err.println(sb);
            }
        }
        throw new AssertionError((Object)("Threads still running " + allStackTraces.keySet()));
    }
}

