/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.lang.ref.WeakReference;
import java.util.List;
import net.openhft.chronicle.core.io.Closeable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

public interface ReferenceCounted {
    public void reserve();

    public boolean tryReserve();

    public void release();

    public long refCount();

    public static void releaseAll(@NotNull List<WeakReference<? extends ReferenceCounted>> refCounts) {
        for (WeakReference<? extends ReferenceCounted> refCountRef : refCounts) {
            ReferenceCounted refCounted;
            if (refCountRef == null || (refCounted = (ReferenceCounted)refCountRef.get()) == null) continue;
            try {
                refCounted.release();
            }
            catch (IllegalStateException e) {
                LoggerFactory.getLogger(Closeable.class).debug("", e);
            }
        }
    }

    public static void release(Object o) {
        if (o instanceof ReferenceCounted) {
            ReferenceCounted rc = (ReferenceCounted)o;
            try {
                rc.release();
            }
            catch (IllegalStateException e) {
                LoggerFactory.getLogger(Closeable.class).debug("", e);
            }
        }
    }
}

