/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.bytes.ref.TwoLongReference;
import org.jetbrains.annotations.NotNull;

public class BinaryTwoLongReference
extends BinaryLongReference
implements TwoLongReference {
    @Override
    public long maxSize() {
        return 16L;
    }

    @Override
    @NotNull
    public String toString() {
        return this.bytes == null ? "bytes is null" : "value: " + this.getValue() + ", value2: " + this.getValue2();
    }

    @Override
    public long getValue2() {
        return this.bytes.readLong(this.offset + 8L);
    }

    @Override
    public void setValue2(long value) {
        this.bytes.writeLong(this.offset + 8L, value);
    }

    @Override
    public long getVolatileValue2() {
        return this.bytes.readVolatileLong(this.offset + 8L);
    }

    @Override
    public void setVolatileValue2(long value) {
        this.bytes.writeVolatileLong(this.offset + 8L, value);
    }

    @Override
    public void setOrderedValue2(long value) {
        this.bytes.writeOrderedLong(this.offset + 8L, value);
    }

    @Override
    public long addValue2(long delta) {
        return this.bytes.addAndGetLong(this.offset + 8L, delta);
    }

    @Override
    public long addAtomicValue2(long delta) {
        return this.addValue2(delta);
    }

    @Override
    public boolean compareAndSwapValue2(long expected, long value) {
        return this.bytes.compareAndSwapLong(this.offset + 8L, expected, value);
    }
}

