/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import net.openhft.chronicle.bytes.NewChunkListener;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.Pretoucher;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.WireType;
import org.junit.Assert;
import org.junit.Test;

public class PretoucherTest {
    private final AtomicLong clock = new AtomicLong(System.currentTimeMillis());
    private final List<Integer> capturedCycles = new ArrayList<Integer>();
    private final CapturingChunkListener chunkListener = new CapturingChunkListener();

    static SingleChronicleQueue createQueue(File path, TimeProvider timeProvider) {
        return SingleChronicleQueueBuilder.binary((File)path).timeProvider(timeProvider).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).testBlockSize().wireType(WireType.BINARY).build();
    }

    @Test
    public void shouldHandleCycleRoll() {
        File dir = DirectoryUtils.tempDir("shouldHandleCycleRoll");
        try (SingleChronicleQueue queue = PretoucherTest.createQueue(dir, this.clock::get);
             Pretoucher pretoucher = new Pretoucher(PretoucherTest.createQueue(dir, this.clock::get), (NewChunkListener)this.chunkListener, this.capturedCycles::add);){
            IntStream.range(0, 10).forEach(i -> {
                try (DocumentContext ctx = queue.acquireAppender().writingDocument();){
                    Assert.assertEquals((long)i, (long)this.capturedCycles.size());
                    ctx.wire().write().int32(i);
                    ctx.wire().write().bytes(new byte[1024]);
                }
                try {
                    pretoucher.execute();
                }
                catch (InvalidEventHandlerException e) {
                    throw Jvm.rethrow((Throwable)e);
                }
                Assert.assertEquals((long)(i + 1), (long)this.capturedCycles.size());
                try {
                    pretoucher.execute();
                }
                catch (InvalidEventHandlerException e) {
                    throw Jvm.rethrow((Throwable)e);
                }
                Assert.assertEquals((long)(i + 1), (long)this.capturedCycles.size());
                this.clock.addAndGet(TimeUnit.SECONDS.toMillis(5L));
            });
            Assert.assertEquals((long)10L, (long)this.capturedCycles.size());
        }
    }

    @Test
    public void shouldHandleCycleRollByPretoucher() {
        this.cycleRollByPretoucher(0);
    }

    private void cycleRollByPretoucher(int earlyMillis) {
        File dir = DirectoryUtils.tempDir("shouldHandleEarlyCycleRoll");
        this.clock.set(100L);
        try (SingleChronicleQueue queue = PretoucherTest.createQueue(dir, this.clock::get);
             Pretoucher pretoucher = new Pretoucher(PretoucherTest.createQueue(dir, this.clock::get), (NewChunkListener)this.chunkListener, this.capturedCycles::add);){
            IntStream.range(0, 10).forEach(i -> {
                try (DocumentContext ctx = queue.acquireAppender().writingDocument();){
                    Assert.assertEquals((long)(i == 0 ? 0L : (long)(i + 1)), (long)this.capturedCycles.size());
                    ctx.wire().write().int32(i);
                    ctx.wire().write().bytes(new byte[1024]);
                }
                try {
                    pretoucher.execute();
                }
                catch (InvalidEventHandlerException e) {
                    throw Jvm.rethrow((Throwable)e);
                }
                Assert.assertEquals((long)(i + 1), (long)this.capturedCycles.size());
                this.clock.addAndGet(950 - earlyMillis);
                try {
                    pretoucher.execute();
                }
                catch (InvalidEventHandlerException e) {
                    throw Jvm.rethrow((Throwable)e);
                }
                this.clock.addAndGet(50 + earlyMillis);
                Assert.assertEquals((long)(i + 2), (long)this.capturedCycles.size());
            });
            Assert.assertEquals((long)11L, (long)this.capturedCycles.size());
            Assert.assertFalse((boolean)this.chunkListener.chunkMap.isEmpty());
        }
    }

    static final class CapturingChunkListener
    implements NewChunkListener {
        final TreeMap<String, List<Integer>> chunkMap = new TreeMap();

        CapturingChunkListener() {
        }

        public void onNewChunk(String filename, int chunk, long delayMicros) {
            this.chunkMap.computeIfAbsent(filename, f -> new ArrayList()).add(chunk);
        }
    }
}

