/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.LinkedHashMap;
import net.openhft.affinity.Affinity;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.StackSampler;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChronicleQueueLatencyDistribution
extends ChronicleQueueTestBase {
    static final boolean SAMPLING = Boolean.getBoolean("sampling");
    static final int ITERATIONS = Integer.getInteger("iterations", 20000000);
    static final int WARMUP = 500000;
    @Nullable
    final StackSampler sampler = SAMPLING ? new StackSampler() : null;

    public static void main(String[] args) throws InterruptedException {
        assert (false) : "test runs slower with assertions on";
        new ChronicleQueueLatencyDistribution().run(args);
    }

    public void run(String[] args) throws InterruptedException {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.fieldlessBinary((File)this.getTmpDir()).blockSize(0x8000000).build();){
            this.runTest((ChronicleQueue)queue, args.length > 0 ? Integer.parseInt(args[0]) : 1200000);
        }
    }

    protected void runTest(@NotNull ChronicleQueue queue, int throughput) throws InterruptedException {
        Histogram histogramCo = new Histogram();
        Histogram histogramIn = new Histogram();
        Histogram histogramWr = new Histogram();
        Thread pretoucher = new Thread(() -> {
            ExcerptAppender appender = queue.acquireAppender();
            while (!Thread.currentThread().isInterrupted()) {
                appender.pretouch();
                Jvm.pause((long)500L);
            }
        });
        pretoucher.setDaemon(true);
        pretoucher.start();
        ExcerptAppender appender = queue.acquireAppender();
        ExcerptTailer tailer = queue.createTailer();
        String name = this.getClass().getName();
        Thread tailerThread = new Thread(() -> {
            AffinityLock lock = null;
            try {
                if (Boolean.getBoolean("enableTailerAffinity") || Boolean.getBoolean("enableAffinity")) {
                    lock = Affinity.acquireLock();
                }
                int counter = 0;
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        DocumentContext dc = tailer.readingDocument();
                        Throwable throwable = null;
                        try {
                            int count;
                            boolean found = dc.isPresent();
                            if (!found) continue;
                            if ((count = counter++) == 500000) {
                                histogramCo.reset();
                                histogramIn.reset();
                                histogramWr.reset();
                            }
                            Bytes bytes = dc.wire().bytes();
                            long startCo = bytes.readLong();
                            long startIn = bytes.readLong();
                            long now = System.nanoTime();
                            histogramCo.sample((double)(now - startCo));
                            histogramIn.sample((double)(now - startIn));
                            if (count % 1000000 != 0) continue;
                            System.out.println("read  " + count);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (dc == null) continue;
                            if (throwable != null) {
                                try {
                                    dc.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            dc.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                        break;
                    }
                }
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
            }
        });
        Thread appenderThread = new Thread(() -> {
            AffinityLock lock = null;
            try {
                if (Boolean.getBoolean("enableAppenderAffinity") || Boolean.getBoolean("enableAffinity")) {
                    lock = Affinity.acquireLock();
                }
                long next = System.nanoTime();
                long interval = 1000000000 / throughput;
                LinkedHashMap<String, Integer> stackCount = new LinkedHashMap<String, Integer>();
                NativeBytesStore bytes24 = NativeBytesStore.from((byte[])new byte[24]);
                for (int i = -500000; i < ITERATIONS; ++i) {
                    StackTraceElement[] stack;
                    long s0 = System.nanoTime();
                    if (s0 < next) {
                        while (System.nanoTime() < next) {
                        }
                        next = System.nanoTime();
                    }
                    if (SAMPLING) {
                        this.sampler.thread(Thread.currentThread());
                    }
                    long start = System.nanoTime();
                    try (@NotNull DocumentContext dc = appender.writingDocument(false);){
                        Bytes bytes2 = dc.wire().bytes();
                        bytes2.writeLong(next);
                        bytes2.writeLong(start);
                        bytes2.write((BytesStore)bytes24);
                    }
                    long time = System.nanoTime() - start;
                    histogramWr.sample((double)(start - next));
                    if (SAMPLING && (double)time > 1000.0 && i > 0 && (stack = this.sampler.getAndReset()) != null && !stack[0].getClassName().equals(name) && !stack[0].getClassName().equals("java.lang.Thread")) {
                        StringBuilder sb = new StringBuilder();
                        Jvm.trimStackTrace((StringBuilder)sb, (StackTraceElement[])stack);
                        stackCount.compute(sb.toString(), (k, v) -> v == null ? 1 : v + 1);
                    }
                    next += interval;
                    if (i % 1000000 != 0) continue;
                    System.out.println("wrote " + i);
                }
                stackCount.entrySet().stream().filter(e -> (Integer)e.getValue() > 1).forEach(System.out::println);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
            }
        });
        tailerThread.start();
        appenderThread.start();
        appenderThread.join();
        Jvm.pause((long)500L);
        tailerThread.interrupt();
        tailerThread.join();
        System.out.println("wr: " + histogramWr.toMicrosFormat());
        System.out.println("in: " + histogramIn.toMicrosFormat());
        System.out.println("co: " + histogramCo.toMicrosFormat());
    }
}

