/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import net.openhft.chronicle.bytes.NewChunkListener;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.Pretoucher;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.WireType;
import org.junit.Assert;
import org.junit.Test;

public class PretoucherTest {
    private final AtomicLong clock = new AtomicLong(System.currentTimeMillis());
    private final List<Integer> capturedCycles = new ArrayList<Integer>();
    private final CapturingChunkListener chunkListener = new CapturingChunkListener();

    private static SingleChronicleQueue createQueue(File path, TimeProvider timeProvider) {
        return SingleChronicleQueueBuilder.binary((File)path).timeProvider(timeProvider).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).testBlockSize().wireType(WireType.BINARY).build();
    }

    @Test
    public void shouldHandleCycleRoll() {
        File dir = DirectoryUtils.tempDir("shouldHandleCycleRoll");
        try (SingleChronicleQueue queue = PretoucherTest.createQueue(dir, this.clock::get);
             Pretoucher pretoucher = new Pretoucher(PretoucherTest.createQueue(dir, this.clock::get), (NewChunkListener)this.chunkListener, this.capturedCycles::add);){
            IntStream.range(0, 10).forEach(i -> {
                try (DocumentContext ctx = queue.acquireAppender().writingDocument();){
                    Assert.assertEquals((long)i, (long)this.capturedCycles.size());
                    ctx.wire().write().int32(i);
                    ctx.wire().write().bytes(new byte[1024]);
                }
                try {
                    pretoucher.execute();
                }
                catch (InvalidEventHandlerException e) {
                    throw Jvm.rethrow((Throwable)e);
                }
                Assert.assertEquals((long)(i + 1), (long)this.capturedCycles.size());
                try {
                    pretoucher.execute();
                }
                catch (InvalidEventHandlerException e) {
                    throw Jvm.rethrow((Throwable)e);
                }
                Assert.assertEquals((long)(i + 1), (long)this.capturedCycles.size());
                this.clock.addAndGet(TimeUnit.SECONDS.toMillis(5L));
            });
            Assert.assertEquals((long)10L, (long)this.capturedCycles.size());
        }
    }

    @Test
    public void shouldHandleCycleRollByPretoucher() {
        this.cycleRollByPretoucher(0);
    }

    @Test
    public void shouldHandleEarlyCycleRollByPretoucher() throws IllegalAccessException {
        this.hackStaticFinal(Pretoucher.class, "EARLY_ACQUIRE_NEXT_CYCLE", true);
        this.hackStaticFinal(Pretoucher.class, "PRETOUCHER_PREROLL_TIME_MS", 100);
        try {
            this.cycleRollByPretoucher(100);
        }
        finally {
            this.hackStaticFinal(Pretoucher.class, "EARLY_ACQUIRE_NEXT_CYCLE", false);
            this.hackStaticFinal(Pretoucher.class, "PRETOUCHER_PREROLL_TIME_MS", 2000L);
        }
    }

    private void cycleRollByPretoucher(int earlyMillis) {
        File dir = DirectoryUtils.tempDir("shouldHandleEarlyCycleRoll");
        this.clock.set(100L);
        try (SingleChronicleQueue queue = PretoucherTest.createQueue(dir, this.clock::get);
             Pretoucher pretoucher = new Pretoucher(PretoucherTest.createQueue(dir, this.clock::get), (NewChunkListener)this.chunkListener, this.capturedCycles::add);){
            IntStream.range(0, 10).forEach(i -> {
                try (DocumentContext ctx = queue.acquireAppender().writingDocument();){
                    Assert.assertEquals((long)(i == 0 ? 0L : (long)(i + 1)), (long)this.capturedCycles.size());
                    ctx.wire().write().int32(i);
                    ctx.wire().write().bytes(new byte[1024]);
                }
                try {
                    pretoucher.execute();
                }
                catch (InvalidEventHandlerException e) {
                    throw Jvm.rethrow((Throwable)e);
                }
                Assert.assertEquals((long)(i + 1), (long)this.capturedCycles.size());
                this.clock.addAndGet(950 - earlyMillis);
                try {
                    pretoucher.execute();
                }
                catch (InvalidEventHandlerException e) {
                    throw Jvm.rethrow((Throwable)e);
                }
                this.clock.addAndGet(50 + earlyMillis);
                Assert.assertEquals((long)(i + 2), (long)this.capturedCycles.size());
            });
            Assert.assertEquals((long)11L, (long)this.capturedCycles.size());
            Assert.assertFalse((boolean)this.chunkListener.chunkMap.isEmpty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dontWrite() throws IllegalAccessException {
        this.hackStaticFinal(Pretoucher.class, "CAN_WRITE", false);
        File dir = DirectoryUtils.tempDir("shouldNotRoll");
        try (SingleChronicleQueue queue = PretoucherTest.createQueue(dir, this.clock::get);
             Pretoucher pretoucher = new Pretoucher(PretoucherTest.createQueue(dir, this.clock::get), (NewChunkListener)this.chunkListener, this.capturedCycles::add);){
            IntStream.range(0, 10).forEach(i -> {
                try (DocumentContext ctx = queue.acquireAppender().writingDocument();){
                    Assert.assertEquals((long)i, (long)this.capturedCycles.size());
                    ctx.wire().write().int32(i);
                    ctx.wire().write().bytes(new byte[1024]);
                }
                try {
                    pretoucher.execute();
                }
                catch (InvalidEventHandlerException e) {
                    throw Jvm.rethrow((Throwable)e);
                }
                Assert.assertEquals((long)(i + 1), (long)this.capturedCycles.size());
                this.clock.addAndGet(TimeUnit.SECONDS.toMillis(5L));
                try {
                    pretoucher.execute();
                }
                catch (InvalidEventHandlerException e) {
                    throw Jvm.rethrow((Throwable)e);
                }
                Assert.assertEquals((long)(i + 1), (long)this.capturedCycles.size());
            });
            Assert.assertEquals((long)10L, (long)this.capturedCycles.size());
        }
        finally {
            this.hackStaticFinal(Pretoucher.class, "CAN_WRITE", true);
        }
    }

    private void hackStaticFinal(Class<Pretoucher> pretoucherClass, String name, Object newValue) throws IllegalAccessException {
        Field f = Jvm.getField(pretoucherClass, (String)name);
        this.removeFinalModifier(f);
        f.set(null, newValue);
    }

    private void removeFinalModifier(Field f) throws IllegalAccessException {
        Field modifiersField = Jvm.getField(Field.class, (String)"modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(f, f.getModifiers() & 0xFFFFFFEF);
    }

    private static final class CapturingChunkListener
    implements NewChunkListener {
        private final TreeMap<String, List<Integer>> chunkMap = new TreeMap();

        private CapturingChunkListener() {
        }

        public void onNewChunk(String filename, int chunk, long delayMicros) {
            this.chunkMap.computeIfAbsent(filename, f -> new ArrayList()).add(chunk);
        }
    }
}

