/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;

public enum MappedUniqueMicroTimeProvider implements TimeProvider
{
    INSTANCE;

    private static final int LAST_TIME = 128;
    private final MappedFile file;
    private final Bytes bytes;
    private TimeProvider provider = SystemTimeProvider.INSTANCE;

    private MappedUniqueMicroTimeProvider() {
        try {
            String user = System.getProperty("user.name");
            if (user == null) {
                user = "unknown";
            }
            this.file = MappedFile.mappedFile(OS.TMP + "/.time-stamp." + user + ".dat", (long)OS.pageSize(), 0L);
            this.bytes = this.file.acquireBytesForWrite(0L);
            this.bytes.append8bit("&TSF\nTime stamp file uses for sharing a unique id\n");
            BytesUtil.unregister(this.bytes);
        }
        catch (IOException ioe) {
            throw new IORuntimeException(ioe);
        }
    }

    public MappedUniqueMicroTimeProvider provider(TimeProvider provider) {
        this.provider = provider;
        return this;
    }

    @Override
    public long currentTimeMillis() {
        return this.provider.currentTimeMillis();
    }

    @Override
    public long currentTimeMicros() {
        long time0;
        long time = this.provider.currentTimeMicros();
        do {
            if ((time0 = this.bytes.readVolatileLong(128L)) < time) continue;
            time = time0 + 1L;
        } while (!this.bytes.compareAndSwapLong(128L, time0, time));
        return time;
    }

    @Override
    public long currentTimeNanos() {
        long time0;
        long time = this.provider.currentTimeNanos();
        long time2 = time / 1000L;
        do {
            if ((time0 = this.bytes.readVolatileLong(128L)) < time2) continue;
            time = time2 + 1L;
            time2 = time * 1000L;
        } while (!this.bytes.compareAndSwapLong(128L, time0, time));
        return time;
    }
}

