/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.GcControls;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public final class TailerPollingEmptyQueueTest {
    @Test
    public void shouldNotGenerateExcessGarbage() {
        try (SingleChronicleQueue queue = this.createQueue();){
            queue.path.mkdirs();
            Assert.assertThat((Object)queue.path.list((d, n) -> n.endsWith(".cq4")).length, (Matcher)CoreMatchers.is((Object)0));
            ExcerptTailer tailer = queue.createTailer();
            for (int i = 0; i < 50; ++i) {
                Assert.assertFalse((boolean)tailer.readingDocument().isPresent());
            }
            long startCollectionCount = GcControls.getGcCount();
            for (int i = 0; i < 1000000; ++i) {
                Assert.assertFalse((boolean)tailer.readingDocument().isPresent());
            }
            Assert.assertThat((Object)(GcControls.getGcCount() - startCollectionCount), (Matcher)CoreMatchers.is((Object)0L));
        }
    }

    private SingleChronicleQueue createQueue() {
        return ChronicleQueue.singleBuilder((File)DirectoryUtils.tempDir(TailerPollingEmptyQueueTest.class.getName())).testBlockSize().build();
    }
}

