/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueExcerpts;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ChronicleQueueIndexTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void checkTheEOFisWrittenToPreQueueFile() {
        SetTimeProvider tp = new SetTimeProvider(System.nanoTime());
        File firstCQFile = null;
        File file1 = DirectoryUtils.tempDir("indexQueueTest2");
        try {
            SingleChronicleQueueExcerpts.InternalAppender appender2;
            Throwable throwable;
            SingleChronicleQueue queue;
            try {
                queue = SingleChronicleQueueBuilder.builder().path(file1).rollCycle((RollCycle)RollCycles.DAILY).timeProvider((TimeProvider)tp).build();
                throwable = null;
                try {
                    appender2 = (SingleChronicleQueueExcerpts.InternalAppender)queue.acquireAppender();
                    appender2.writeBytes(RollCycles.DAILY.toIndex(1, 0L), (BytesStore)Bytes.fromString((String)"Hello World 1"));
                    firstCQFile = queue.file();
                    firstCQFile = Objects.requireNonNull(firstCQFile.listFiles((dir, name) -> name.endsWith(".cq4")))[0];
                    Assert.assertFalse((boolean)this.hasEOFAtEndOfFile(firstCQFile));
                }
                catch (Throwable appender2) {
                    throwable = appender2;
                    throw appender2;
                }
                finally {
                    if (queue != null) {
                        if (throwable != null) {
                            try {
                                queue.close();
                            }
                            catch (Throwable appender2) {
                                throwable.addSuppressed(appender2);
                            }
                        } else {
                            queue.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail();
            }
            tp.advanceMillis(TimeUnit.DAYS.toMillis(2L));
            try {
                queue = SingleChronicleQueueBuilder.builder().path(file1).rollCycle((RollCycle)RollCycles.DAILY).timeProvider((TimeProvider)tp).build();
                throwable = null;
                try {
                    appender2 = (SingleChronicleQueueExcerpts.InternalAppender)queue.acquireAppender();
                    appender2.writeBytes(RollCycles.DAILY.toIndex(3, 0L), (BytesStore)Bytes.fromString((String)"Hello World 2"));
                    Assert.assertTrue((boolean)this.hasEOFAtEndOfFile(firstCQFile));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (queue != null) {
                        if (throwable != null) {
                            try {
                                queue.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            queue.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail();
            }
        }
        finally {
            file1.deleteOnExit();
        }
    }

    private boolean hasEOFAtEndOfFile(File file) throws IOException {
        Bytes bytes = BytesUtil.readFile((String)file.getAbsolutePath());
        String lastFewBytes = bytes.toHexString(131328L, 128L);
        return lastFewBytes.contains("00 00 00 c0");
    }

    private void eofAsHex() {
        Bytes eof = Bytes.elasticByteBuffer((int)4);
        eof.writeInt(-1073741824);
        System.out.println(eof.toHexString());
        System.out.println(eof);
    }

    @Test
    public void testIndexQueue() {
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder().path("test-chronicle").rollCycle((RollCycle)RollCycles.DAILY).build();
        SingleChronicleQueueExcerpts.InternalAppender appender = (SingleChronicleQueueExcerpts.InternalAppender)queue.acquireAppender();
        Bytes hello_world = Bytes.fromString((String)"Hello World 1");
        appender.writeBytes(RollCycles.DAILY.toIndex(18264, 0L), (BytesStore)hello_world);
        hello_world = Bytes.fromString((String)"Hello World 2");
        appender.writeBytes(RollCycles.DAILY.toIndex(18264, 1L), (BytesStore)hello_world);
        queue.close();
        queue = SingleChronicleQueueBuilder.builder().path("test-chronicle").rollCycle((RollCycle)RollCycles.DAILY).build();
        appender = (SingleChronicleQueueExcerpts.InternalAppender)queue.acquireAppender();
        hello_world = Bytes.fromString((String)"Hello World 3");
        appender.writeBytes(RollCycles.DAILY.toIndex(18265, 0L), (BytesStore)hello_world);
        ExcerptTailer tailer = queue.createTailer();
        Bytes forRead = Bytes.elasticByteBuffer();
        ArrayList<String> results = new ArrayList<String>();
        while (tailer.readBytes(forRead)) {
            results.add(forRead.toString());
            forRead.clear();
        }
        Assert.assertTrue((boolean)results.contains("Hello World 1"));
        Assert.assertTrue((boolean)results.contains("Hello World 2"));
        Assert.assertTrue((boolean)results.contains("Hello World 3"));
        forRead.release();
    }

    @After
    public void checkRegisteredBytes() {
        BytesUtil.checkRegisteredBytes();
    }
}

