/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.ThrowingCallable;
import net.openhft.chronicle.threads.ExecutorFactory;
import net.openhft.chronicle.threads.VanillaExecutorFactory;
import org.jetbrains.annotations.NotNull;

public enum Threads {

    static final Field GROUP = Jvm.getField(Thread.class, "group");
    static final long SHUTDOWN_WAIT_MILLIS = Long.getLong("SHUTDOWN_WAIT_MS", 500L);
    static ExecutorFactory executorFactory;

    public static ExecutorService acquireExecutorService(String name, int threads, boolean daemon) {
        return executorFactory.acquireExecutorService(name, threads, daemon);
    }

    public static ScheduledExecutorService acquireScheduledExecutorService(String name, boolean daemon) {
        return executorFactory.acquireScheduledExecutorService(name, daemon);
    }

    public static void executorFactory(ExecutorFactory executorFactory) {
        Threads.executorFactory = executorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    public static <R, T extends Throwable> R withThreadGroup(ThreadGroup tg, @NotNull ThrowingCallable<R, T> callable) throws T {
        Thread thread = Thread.currentThread();
        ThreadGroup tg0 = thread.getThreadGroup();
        Threads.setThreadGroup(thread, tg);
        try {
            R r = callable.call();
            return r;
        }
        finally {
            Threads.setThreadGroup(thread, tg0);
        }
    }

    @ForceInline
    public static void setThreadGroup(Thread thread, ThreadGroup tg) {
        try {
            GROUP.set(thread, tg);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public static String threadGroupPrefix() {
        String threadGroupName = Thread.currentThread().getThreadGroup().getName();
        if (!threadGroupName.endsWith("/")) {
            threadGroupName = threadGroupName + "/";
        }
        return threadGroupName;
    }

    public static void shutdownDaemon(@NotNull ExecutorService service) {
        service.shutdownNow();
        try {
            boolean terminated = service.awaitTermination(10L, TimeUnit.MILLISECONDS);
            if (!terminated && !(terminated = service.awaitTermination(1L, TimeUnit.SECONDS))) {
                if (service instanceof ThreadPoolExecutor) {
                    Threads.warnRunningThreads(service);
                } else {
                    Jvm.warn().on(Threads.class, "*** FAILED TO TERMINATE " + service.toString());
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void shutdown(@NotNull ExecutorService service, boolean daemon) {
        if (daemon) {
            Threads.shutdownDaemon(service);
        } else {
            Threads.shutdown(service);
        }
    }

    public static void shutdown(@NotNull ExecutorService service) {
        service.shutdown();
        Threads.unpark(service);
        Threads.interrupt(service);
        try {
            if (!service.awaitTermination(SHUTDOWN_WAIT_MILLIS, TimeUnit.MILLISECONDS)) {
                service.shutdownNow();
                if (service instanceof ThreadPoolExecutor) {
                    Threads.warnRunningThreads(service);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static void warnRunningThreads(@NotNull ExecutorService service) {
        Jvm.pause(100L);
        Threads.forEachThread(service, t -> {
            StringBuilder b = new StringBuilder("**** THE " + t.getName() + " THREAD DID NOT SHUTDOWN ***\n");
            for (StackTraceElement s : t.getStackTrace()) {
                b.append("  ").append(s).append("\n");
            }
            Jvm.warn().on(Threads.class, b.toString());
        });
    }

    public static void unpark(ExecutorService service) {
        Threads.forEachThread(service, LockSupport::unpark);
    }

    public static void interrupt(ExecutorService service) {
        Threads.forEachThread(service, Thread::interrupt);
    }

    static void forEachThread(ExecutorService service, Consumer<Thread> consumer) {
        try {
            Set workers;
            Object s = service;
            try {
                Field e = service.getClass().getDeclaredField("e");
                e.setAccessible(true);
                s = e.get(s);
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
            try {
                Field w = service.getClass().getDeclaredField("workers");
                w.setAccessible(true);
                workers = (Set)w.get(s);
            }
            catch (NoSuchFieldException e) {
                Jvm.warn().on(Threads.class, "Couldn't find workers for " + service.getClass());
                return;
            }
            ArrayList objects = new ArrayList(workers);
            for (Object o : objects) {
                Field thread = o.getClass().getDeclaredField("thread");
                thread.setAccessible(true);
                Thread t = (Thread)thread.get(o);
                if (t.getState() == Thread.State.TERMINATED) continue;
                consumer.accept(t);
            }
        }
        catch (Exception e) {
            Jvm.debug().on(Threads.class, e);
        }
    }

    static {
        ExecutorFactory instance = VanillaExecutorFactory.INSTANCE;
        try {
            String property = System.getProperty("threads.executor.factory");
            if (property != null) {
                instance = (ExecutorFactory)ObjectUtils.newInstance(Class.forName(property));
            }
        }
        catch (Exception e) {
            Jvm.warn().on(Threads.class, e);
        }
        executorFactory = instance;
    }
}

