/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.annotation.HotMethod;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.Threads;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediumEventLoop
implements EventLoop,
Runnable,
Closeable {
    private static final boolean CHECK_INTERRUPTS = !Boolean.getBoolean("chronicle.eventLoop.ignoreInterrupts");
    private static final Logger LOG = LoggerFactory.getLogger(MediumEventLoop.class);
    private static final EventHandler[] NO_EVENT_HANDLERS = new EventHandler[0];
    private static final long FINISHED = 0x7FFFFFFFFFFFFFFEL;
    private final EventLoop parent;
    @NotNull
    private final ExecutorService service;
    private final List<EventHandler> mediumHandlers = new CopyOnWriteArrayList<EventHandler>();
    private final AtomicReference<EventHandler> newHandler = new AtomicReference();
    private final Pauser pauser;
    private final boolean daemon;
    private final String name;
    private final String binding;
    @NotNull
    private EventHandler[] mediumHandlersArray = NO_EVENT_HANDLERS;
    private volatile long loopStartMS;
    @NotNull
    private volatile AtomicBoolean running = new AtomicBoolean();
    @Nullable
    private volatile Thread thread = null;
    @Nullable
    private volatile Throwable closedHere = null;
    private volatile boolean closed;

    public MediumEventLoop(EventLoop parent, String name, Pauser pauser, boolean daemon, String binding) {
        this.parent = parent;
        this.name = name;
        this.pauser = pauser;
        this.daemon = daemon;
        this.binding = binding;
        this.loopStartMS = Long.MAX_VALUE;
        this.service = Executors.newSingleThreadExecutor(new NamedThreadFactory(name, daemon));
    }

    public static void closeAll(@NotNull List<EventHandler> handlers) {
        handlers.forEach(h -> Closeable.closeQuietly(h));
    }

    @Nullable
    public Thread thread() {
        return this.thread;
    }

    @Override
    public void awaitTermination() {
        try {
            this.service.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @NotNull
    public String toString() {
        return "MediumEventLoop{name='" + this.name + '\'' + ", parent=" + this.parent + ", service=" + this.service + ", mediumHandlers=" + this.mediumHandlers + ", newHandler=" + this.newHandler + ", pauser=" + this.pauser + ", closedHere=" + this.closedHere + '}';
    }

    @Override
    public void start() {
        block3: {
            this.checkClosed();
            if (!this.running.getAndSet(true)) {
                try {
                    this.service.submit(this);
                }
                catch (RejectedExecutionException e) {
                    if (this.isClosed()) break block3;
                    this.closeAll();
                    throw e;
                }
            }
        }
    }

    @Override
    public void unpause() {
        this.pauser.unpause();
    }

    @Override
    public void stop() {
        this.running.set(false);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void addHandler(@NotNull EventHandler handler) {
        HandlerPriority priority = handler.priority();
        if (DEBUG_ADDING_HANDLERS) {
            System.out.println("Adding " + (Object)((Object)priority) + " " + handler + " to " + this.name);
        }
        if (priority.alias() != HandlerPriority.MEDIUM) {
            throw new IllegalStateException(this.name() + ": Unexpected priority " + (Object)((Object)priority) + " for " + handler);
        }
        this.checkClosed();
        if (this.thread == null || this.thread == Thread.currentThread()) {
            this.addNewHandler(handler);
            return;
        }
        do {
            this.pauser.unpause();
            this.checkClosed();
        } while (!this.newHandler.compareAndSet(null, handler));
    }

    void checkClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Event Group has been closed", this.closedHere);
        }
    }

    public long loopStartMS() {
        return this.loopStartMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @HotMethod
    public void run() {
        try (AffinityLock lock2 = AffinityLock.acquireLock(this.binding);){
            this.thread = Thread.currentThread();
            this.runLoop();
        }
        catch (InvalidEventHandlerException lock2) {
        }
        catch (Throwable e) {
            Jvm.warn().on(this.getClass(), "Loop terminated due to exception", e);
        }
        finally {
            this.loopFinishedAllHandlers();
            this.loopStartMS = 0x7FFFFFFFFFFFFFFEL;
        }
    }

    private void loopFinishedAllHandlers() {
        this.mediumHandlers.forEach(EventHandler::loopFinished);
    }

    private void runLoop() throws InvalidEventHandlerException {
        while (this.running.get() && this.isNotInterrupted()) {
            if (this.isClosed()) {
                throw new InvalidEventHandlerException();
            }
            boolean busy = this.runMediumLoopOnly();
            if (busy) {
                this.pauser.reset();
                continue;
            }
            if (this.acceptNewHandlers()) continue;
            this.loopStartMS = Long.MAX_VALUE;
            this.pauser.pause();
        }
    }

    private boolean isNotInterrupted() {
        return !CHECK_INTERRUPTS || !Thread.currentThread().isInterrupted();
    }

    private boolean runMediumLoopOnly() {
        this.loopStartMS = Time.currentTimeMillis();
        return this.runAllMediumHandler();
    }

    private void closeAll() {
        this.closeAllHandlers();
        LOG.trace("Remaining handlers");
        this.dumpRunningHandlers();
    }

    @HotMethod
    private boolean runAllMediumHandler() {
        EventHandler[] mediumHandlersArray;
        boolean busy = false;
        for (EventHandler handler : mediumHandlersArray = this.mediumHandlersArray) {
            try {
                busy |= handler.action();
            }
            catch (InvalidEventHandlerException e) {
                this.removeHandler(handler);
            }
            catch (Exception e) {
                Jvm.warn().on(this.getClass(), e);
            }
        }
        return busy;
    }

    private void removeHandler(EventHandler handler) {
        this.removeHandler(handler, this.mediumHandlers);
        this.mediumHandlersArray = this.mediumHandlers.toArray(NO_EVENT_HANDLERS);
    }

    private void removeHandler(EventHandler handler, @NotNull List<EventHandler> handlers) {
        block2: {
            try {
                handlers.remove(handler);
                handler.loopFinished();
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                if (handlers.isEmpty()) break block2;
                throw e2;
            }
        }
        Closeable.closeQuietly((Object)handler);
    }

    @HotMethod
    private boolean acceptNewHandlers() {
        boolean busy = false;
        EventHandler handler = this.newHandler.getAndSet(null);
        if (handler != null) {
            this.addNewHandler(handler);
            busy = true;
        }
        return busy;
    }

    private void addNewHandler(@NotNull EventHandler handler) {
        HandlerPriority t1 = handler.priority();
        switch (t1 == null ? HandlerPriority.MEDIUM : t1.alias()) {
            case REPLICATION: 
            case CONCURRENT: 
            case MEDIUM: {
                if (this.mediumHandlers.contains(handler)) break;
                this.mediumHandlers.add(handler);
                this.mediumHandlersArray = this.mediumHandlers.toArray(NO_EVENT_HANDLERS);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot add a " + (Object)((Object)handler.priority()) + " task to a busy waiting thread");
            }
        }
        handler.eventLoop(this.parent);
    }

    @Override
    public String name() {
        return this.name;
    }

    public void dumpRunningState(@NotNull String message, @NotNull BooleanSupplier finalCheck) {
        Thread thread = this.thread;
        if (thread == null) {
            return;
        }
        StringBuilder out = new StringBuilder(message);
        Jvm.trimStackTrace(out, thread.getStackTrace());
        if (finalCheck.getAsBoolean() && LOG.isInfoEnabled()) {
            LOG.info(out.toString());
        }
    }

    public int nonDaemonHandlerCount() {
        return this.mediumHandlers.size();
    }

    public int handlerCount() {
        return this.mediumHandlers.size();
    }

    @Override
    public void close() {
        try {
            this.closed = true;
            this.closedHere = Jvm.isDebug() ? new StackTrace("Closed here") : null;
            this.stop();
            this.pauser.reset();
            this.pauser.unpause();
            LockSupport.unpark(this.thread);
            Threads.shutdown(this.service, this.daemon);
            if (this.thread == null) {
                this.loopFinishedAllHandlers();
                return;
            }
            this.thread.interrupt();
            for (int i = 1; i <= 30; ++i) {
                if (this.loopStartMS == 0x7FFFFFFFFFFFFFFEL) {
                    break;
                }
                Jvm.pause(i);
                if (i % 10 != 0) continue;
                StringBuilder sb = new StringBuilder();
                sb.append(this.name + ": Shutting down thread is executing ").append(this.thread).append(", handlerCount=").append(this.nonDaemonHandlerCount());
                Jvm.trimStackTrace(sb, this.thread.getStackTrace());
                Jvm.warn().on(this.getClass(), sb.toString());
                this.dumpRunningHandlers();
            }
        }
        finally {
            this.closeAllHandlers();
            this.mediumHandlers.clear();
            this.mediumHandlersArray = NO_EVENT_HANDLERS;
            this.newHandler.set(null);
        }
    }

    public void closeAllHandlers() {
        MediumEventLoop.closeAll(this.mediumHandlers);
        Optional.ofNullable(this.newHandler.get()).ifPresent(eventHandler -> {
            Jvm.warn().on(this.getClass(), "Handler in newHandler was not accepted before close " + eventHandler);
            Closeable.closeQuietly(eventHandler);
        });
    }

    public void dumpRunningHandlers() {
        int handlerCount = this.handlerCount();
        if (handlerCount <= 0) {
            return;
        }
        List<EventHandler> collect = Stream.of(this.mediumHandlers).flatMap(Collection::stream).filter(e -> e instanceof Closeable).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return;
        }
        LOG.info("Handlers still running after being closed, handlerCount=" + handlerCount);
        collect.forEach(h -> LOG.info("\t" + h));
    }

    @Override
    public boolean isAlive() {
        Thread thread = this.thread;
        return thread != null && thread.isAlive();
    }
}

