/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.cleaner.impl.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.cleaner.spi.ByteBufferCleanerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.nio.ch.DirectBuffer;

public final class ReflectionBasedByteBufferCleanerService
implements ByteBufferCleanerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionBasedByteBufferCleanerService.class);
    private static final String JDK8_CLEANER_CLASS_NAME = "sun.misc.Cleaner";
    private static final String JDK9_CLEANER_CLASS_NAME = "jdk.internal.ref.Cleaner";

    @Override
    public void clean(ByteBuffer buffer) {
        try {
            Method cleanerMethod = DirectBuffer.class.getDeclaredMethod("cleaner", new Class[0]);
            Jvm.setAccessible(cleanerMethod);
            Object cleaner = cleanerMethod.invoke((Object)buffer, new Object[0]);
            String cleanerClassname = Jvm.isJava9Plus() ? JDK9_CLEANER_CLASS_NAME : JDK8_CLEANER_CLASS_NAME;
            Method cleanMethod = Jvm.getMethod(Class.forName(cleanerClassname), "clean", new Class[0]);
            cleanMethod.invoke(cleaner, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.warn("Failed to clean buffer", e);
        }
    }

    @Override
    public int impact() {
        return 1;
    }
}

