/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Date;
import javax.naming.TimeLimitExceededException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IOTools;

public interface LicenceCheck {
    public static final String CHRONICLE_LICENSE = "chronicle.license";

    public static void check(String product, Class caller) {
        Jvm.debug();
        String key = System.getProperty(CHRONICLE_LICENSE);
        if (key == null || !key.contains(product + '.')) {
            String expiryDateFile = product + ".expiry-date";
            try {
                String message;
                String source = new String(IOTools.readFile(expiryDateFile));
                Date expriyDate = new SimpleDateFormat("yyyy-MM-dd").parse(source);
                long days = (expriyDate.getTime() - System.currentTimeMillis()) / 86400000L;
                if (days < 0L) {
                    Jvm.rethrow(new TimeLimitExceededException("Failed to read '" + expiryDateFile));
                }
                String string = message = days <= 1L ? "The license expires in 1 day" : "The license expires in " + days + " days";
                if (days > 500L) {
                    message = "The license expires about " + days / 365L + " years";
                }
                Jvm.warn().on(LicenceCheck.class, message + ". At which point, this produce will stop working, if you wish to renew this licence please contact sales@chronicle.software");
            }
            catch (Throwable t) {
                Jvm.rethrow(new TimeLimitExceededException("Failed to read expiry date, from '" + expiryDateFile + "'"));
            }
        } else {
            int start = key.indexOf("expires=") + 8;
            int end = key.indexOf(",", start);
            LocalDate date = LocalDate.parse(key.substring(start, end));
            int start2 = key.indexOf("owner=") + 6;
            int end2 = key.indexOf(",", start2);
            String owner = key.substring(start2, end2);
            long days = date.toEpochDay() - System.currentTimeMillis() / 86400000L;
            Jvm.warn().on(LicenceCheck.class, "License for " + owner + " expires in " + days + " days");
            if (days < 0L) {
                Jvm.rethrow(new TimeLimitExceededException());
            }
        }
    }

    public void licenceCheck();

    public boolean isAvailable();
}

