/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single.preroucher;

import java.util.function.LongConsumer;
import java.util.function.Supplier;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.threads.TimedEventHandler;

public final class PeriodicUpdateEventHandler
extends TimedEventHandler {
    private final Supplier<LongConsumer> methodSupplier;
    private final long periodInMicroseconds;
    private final long startTimeMillis;
    private LongConsumer periodicUpdateHandler;

    PeriodicUpdateEventHandler(Supplier<LongConsumer> methodSupplier, long startTimeMillis, long periodInMicroseconds) {
        this.methodSupplier = methodSupplier;
        this.startTimeMillis = startTimeMillis;
        this.periodInMicroseconds = periodInMicroseconds;
    }

    protected long timedAction() throws InvalidEventHandlerException {
        long now = System.currentTimeMillis();
        if (now < this.startTimeMillis) {
            return now - this.startTimeMillis;
        }
        this.periodicUpdateHandler.accept(now);
        if (this.periodInMicroseconds == 0L) {
            throw new InvalidEventHandlerException("just runs once");
        }
        return this.periodInMicroseconds;
    }

    public void eventLoop(EventLoop eventLoop) {
        this.periodicUpdateHandler = this.methodSupplier.get();
    }
}

