/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.io.File;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.RollingResourcesCache;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class RollingResourcesCacheTest {
    private static final long SEED = 2983472039423847L;
    private static final long AM_EPOCH = 1523498933145L;
    private static final int AM_DAILY_CYCLE_NUMBER = 1;
    private static final int AM_HOURLY_CYCLE_NUMBER = 24;
    private static final int AM_MINUTELY_CYCLE_NUMBER = 1440;
    private static final String AM_DAILY_FILE_NAME = "20180413";
    private static final String AM_HOURLY_FILE_NAME_0 = "20180413-00";
    private static final String AM_HOURLY_FILE_NAME_15 = "20180413-15";
    private static final String AM_MINUTELY_FILE_NAME_0 = "20180413-0000";
    private static final String AM_MINUTELY_FILE_NAME_10 = "20180413-0010";
    private static final long PM_EPOCH = 1284739200000L;
    private static final int PM_DAILY_CYCLE_NUMBER = 2484;
    private static final int PM_HOURLY_CYCLE_NUMBER = 59616;
    private static final int PM_MINUTELY_CYCLE_NUMBER = 3576960;
    private static final String PM_DAILY_FILE_NAME = "20170706";
    private static final String PM_HOURLY_FILE_NAME_0 = "20170706-00";
    private static final String PM_HOURLY_FILE_NAME_15 = "20170706-15";
    private static final String PM_MINUTELY_FILE_NAME_0 = "20170706-0000";
    private static final String PM_MINUTELY_FILE_NAME_10 = "20170706-0010";
    private static final long POSITIVE_RELATIVE_EPOCH = 18000000L;
    private static final int POSITIVE_RELATIVE_DAILY_CYCLE_NUMBER = 2484;
    private static final int POSITIVE_RELATIVE_HOURLY_CYCLE_NUMBER = 59616;
    private static final int POSITIVE_RELATIVE_MINUTELY_CYCLE_NUMBER = 3576960;
    private static final String POSITIVE_RELATIVE_DAILY_FILE_NAME = "19761020";
    private static final String POSITIVE_RELATIVE_HOURLY_FILE_NAME_0 = "19761020-00";
    private static final String POSITIVE_RELATIVE_HOURLY_FILE_NAME_15 = "19761020-15";
    private static final String POSITIVE_RELATIVE_MINUTELY_FILE_NAME_0 = "19761020-0000";
    private static final String POSITIVE_RELATIVE_MINUTELY_FILE_NAME_10 = "19761020-0010";
    private static final long BIG_POSITIVE_RELATIVE_EPOCH = 54000000L;
    private static final int BIG_POSITIVE_RELATIVE_DAILY_CYCLE_NUMBER = 2484;
    private static final int BIG_POSITIVE_RELATIVE_HOURLY_CYCLE_NUMBER = 59616;
    private static final int BIG_POSITIVE_RELATIVE_MINUTELY_CYCLE_NUMBER = 3576960;
    private static final String BIG_POSITIVE_RELATIVE_DAILY_FILE_NAME = "19761020";
    private static final String BIG_POSITIVE_RELATIVE_HOURLY_FILE_NAME_0 = "19761020-00";
    private static final String BIG_POSITIVE_RELATIVE_HOURLY_FILE_NAME_15 = "19761020-15";
    private static final String BIG_POSITIVE_RELATIVE_MINUTELY_FILE_NAME_0 = "19761020-0000";
    private static final String BIG_POSITIVE_RELATIVE_MINUTELY_FILE_NAME_10 = "19761020-0010";
    private static final long NEGATIVE_RELATIVE_EPOCH = -10800000L;
    private static final int NEGATIVE_RELATIVE_DAILY_CYCLE_NUMBER = 2484;
    private static final int NEGATIVE_RELATIVE_HOURLY_CYCLE_NUMBER = 59616;
    private static final int NEGATIVE_RELATIVE_MINUTELY_CYCLE_NUMBER = 3576960;
    private static final String NEGATIVE_RELATIVE_DAILY_FILE_NAME = "19761019";
    private static final String NEGATIVE_RELATIVE_HOURLY_FILE_NAME_0 = "19761019-00";
    private static final String NEGATIVE_RELATIVE_HOURLY_FILE_NAME_15 = "19761019-15";
    private static final String NEGATIVE_RELATIVE_MINUTELY_FILE_NAME_0 = "19761019-0000";
    private static final String NEGATIVE_RELATIVE_MINUTELY_FILE_NAME_10 = "19761019-0010";
    private static final long BIG_NEGATIVE_RELATIVE_EPOCH = -10800000L;
    private static final int BIG_NEGATIVE_RELATIVE_DAILY_CYCLE_NUMBER = 2484;
    private static final int BIG_NEGATIVE_RELATIVE_HOURLY_CYCLE_NUMBER = 59616;
    private static final int BIG_NEGATIVE_RELATIVE_MINUTELY_CYCLE_NUMBER = 3576960;
    private static final String BIG_NEGATIVE_RELATIVE_DAILY_FILE_NAME = "19761019";
    private static final String BIG_NEGATIVE_RELATIVE_HOURLY_FILE_NAME_0 = "19761019-00";
    private static final String BIG_NEGATIVE_RELATIVE_HOURLY_FILE_NAME_15 = "19761019-15";
    private static final String BIG_NEGATIVE_RELATIVE_MINUTELY_FILE_NAME_0 = "19761019-0000";
    private static final String BIG_NEGATIVE_RELATIVE_MINUTELY_FILE_NAME_10 = "19761019-0010";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final long ONE_DAY_IN_MILLIS = TimeUnit.DAYS.toMillis(1L);
    private static final boolean LOG_TEST_DEBUG = Boolean.valueOf(RollingResourcesCacheTest.class.getSimpleName() + ".debug");

    private static void assertCorrectConversion(RollingResourcesCache cache, int cycle, Instant instant, DateTimeFormatter formatter) {
        String expectedFileName = formatter.format(instant);
        Assert.assertThat((Object)cache.resourceFor((long)((long)cycle)).text, (Matcher)CoreMatchers.is((Object)expectedFileName));
        Assert.assertThat((Object)cache.parseCount(expectedFileName), (Matcher)CoreMatchers.is((Object)cycle));
    }

    @Test
    public void shouldConvertCyclesToResourceNamesWithNoEpoch() throws Exception {
        boolean epoch = false;
        RollingResourcesCache cache = new RollingResourcesCache((RollCycle)RollCycles.DAILY, 0L, File::new, File::getName);
        int cycle = RollCycles.DAILY.current(System::currentTimeMillis, 0L);
        RollingResourcesCacheTest.assertCorrectConversion(cache, cycle, Instant.now(), DateTimeFormatter.ofPattern("yyyyMMdd").withZone(ZoneId.of("GMT")));
    }

    private void doTestCycleAndResourceNames(long epoch, RollCycle rollCycle, int cycleNumber, String filename) {
        RollingResourcesCache cache = new RollingResourcesCache(rollCycle, epoch, File::new, File::getName);
        Assert.assertThat((Object)cache.resourceFor((long)((long)cycleNumber)).text, (Matcher)CoreMatchers.is((Object)filename));
        Assert.assertThat((Object)cache.parseCount(filename), (Matcher)CoreMatchers.is((Object)cycleNumber));
    }

    @Test
    public void shouldCorrectlyConvertCyclesToResourceNamesWithEpoch() throws Exception {
        this.doTestCycleAndResourceNames(1523498933145L, (RollCycle)RollCycles.DAILY, 1, AM_DAILY_FILE_NAME);
        this.doTestCycleAndResourceNames(1523498933145L, (RollCycle)RollCycles.HOURLY, 24, AM_HOURLY_FILE_NAME_0);
        this.doTestCycleAndResourceNames(1523498933145L, (RollCycle)RollCycles.HOURLY, 39, AM_HOURLY_FILE_NAME_15);
        this.doTestCycleAndResourceNames(1523498933145L, (RollCycle)RollCycles.MINUTELY, 1440, AM_MINUTELY_FILE_NAME_0);
        this.doTestCycleAndResourceNames(1523498933145L, (RollCycle)RollCycles.MINUTELY, 1450, AM_MINUTELY_FILE_NAME_10);
        this.doTestCycleAndResourceNames(1284739200000L, (RollCycle)RollCycles.DAILY, 2484, PM_DAILY_FILE_NAME);
        this.doTestCycleAndResourceNames(1284739200000L, (RollCycle)RollCycles.HOURLY, 59616, PM_HOURLY_FILE_NAME_0);
        this.doTestCycleAndResourceNames(1284739200000L, (RollCycle)RollCycles.HOURLY, 59631, PM_HOURLY_FILE_NAME_15);
        this.doTestCycleAndResourceNames(1284739200000L, (RollCycle)RollCycles.MINUTELY, 3576960, PM_MINUTELY_FILE_NAME_0);
        this.doTestCycleAndResourceNames(1284739200000L, (RollCycle)RollCycles.MINUTELY, 3576970, PM_MINUTELY_FILE_NAME_10);
        this.doTestCycleAndResourceNames(18000000L, (RollCycle)RollCycles.DAILY, 2484, "19761020");
        this.doTestCycleAndResourceNames(18000000L, (RollCycle)RollCycles.HOURLY, 59616, "19761020-00");
        this.doTestCycleAndResourceNames(18000000L, (RollCycle)RollCycles.HOURLY, 59631, "19761020-15");
        this.doTestCycleAndResourceNames(18000000L, (RollCycle)RollCycles.MINUTELY, 3576960, "19761020-0000");
        this.doTestCycleAndResourceNames(18000000L, (RollCycle)RollCycles.MINUTELY, 3576970, "19761020-0010");
        this.doTestCycleAndResourceNames(54000000L, (RollCycle)RollCycles.DAILY, 2484, "19761020");
        this.doTestCycleAndResourceNames(54000000L, (RollCycle)RollCycles.HOURLY, 59616, "19761020-00");
        this.doTestCycleAndResourceNames(54000000L, (RollCycle)RollCycles.HOURLY, 59631, "19761020-15");
        this.doTestCycleAndResourceNames(54000000L, (RollCycle)RollCycles.MINUTELY, 3576960, "19761020-0000");
        this.doTestCycleAndResourceNames(54000000L, (RollCycle)RollCycles.MINUTELY, 3576970, "19761020-0010");
        this.doTestCycleAndResourceNames(-10800000L, (RollCycle)RollCycles.DAILY, 2484, "19761019");
        this.doTestCycleAndResourceNames(-10800000L, (RollCycle)RollCycles.HOURLY, 59616, "19761019-00");
        this.doTestCycleAndResourceNames(-10800000L, (RollCycle)RollCycles.HOURLY, 59631, "19761019-15");
        this.doTestCycleAndResourceNames(-10800000L, (RollCycle)RollCycles.MINUTELY, 3576960, "19761019-0000");
        this.doTestCycleAndResourceNames(-10800000L, (RollCycle)RollCycles.MINUTELY, 3576970, "19761019-0010");
        this.doTestCycleAndResourceNames(-10800000L, (RollCycle)RollCycles.DAILY, 2484, "19761019");
        this.doTestCycleAndResourceNames(-10800000L, (RollCycle)RollCycles.HOURLY, 59616, "19761019-00");
        this.doTestCycleAndResourceNames(-10800000L, (RollCycle)RollCycles.HOURLY, 59631, "19761019-15");
        this.doTestCycleAndResourceNames(-10800000L, (RollCycle)RollCycles.MINUTELY, 3576960, "19761019-0000");
        this.doTestCycleAndResourceNames(-10800000L, (RollCycle)RollCycles.MINUTELY, 3576970, "19761019-0010");
    }

    @Test(expected=RuntimeException.class)
    public void parseIncorrectlyFormattedName() throws Exception {
        RollingResourcesCache cache = new RollingResourcesCache((RollCycle)RollCycles.HOURLY, 1284739200000L, File::new, File::getName);
        cache.parseCount("foobar-qux");
    }

    @Test
    public void fuzzyConversionTest() throws Exception {
        int maxAddition = (int)ChronoUnit.DECADES.getDuration().toMillis();
        Random random = new Random(2983472039423847L);
        for (int i = 0; i < 1000; ++i) {
            long epoch = random.nextInt(maxAddition);
            RollingResourcesCache cache = new RollingResourcesCache((RollCycle)RollCycles.DAILY, epoch, File::new, File::getName);
            for (int j = 0; j < 200; ++j) {
                long offsetMillisFromEpoch = TimeUnit.DAYS.toMillis(random.nextInt(500)) + TimeUnit.HOURS.toMillis(random.nextInt(50)) + TimeUnit.MINUTES.toMillis(random.nextInt(50));
                long instantAfterEpoch = epoch + offsetMillisFromEpoch;
                ZoneId zoneId = ZoneId.of("UTC");
                int cycle = RollCycles.DAILY.current(() -> instantAfterEpoch, epoch);
                long daysBetweenEpochAndInstant = (instantAfterEpoch - epoch) / ONE_DAY_IN_MILLIS;
                Assert.assertThat((Object)cycle, (Matcher)CoreMatchers.is((Object)daysBetweenEpochAndInstant));
                Assert.assertThat((Object)((long)cycle * ONE_DAY_IN_MILLIS), (Matcher)CoreMatchers.is((Object)((long)cycle * (long)RollCycles.DAILY.length())));
                if (LOG_TEST_DEBUG) {
                    System.out.printf("Epoch: %d%n", epoch);
                    System.out.printf("Epoch millis: %d(UTC+%dd), current millis: %d(UTC+%dd)%n", epoch, epoch / ONE_DAY_IN_MILLIS, instantAfterEpoch, instantAfterEpoch / ONE_DAY_IN_MILLIS);
                    System.out.printf("Delta days: %d, Delta millis: %d, Delta days in millis: %d%n", daysBetweenEpochAndInstant, instantAfterEpoch - epoch, daysBetweenEpochAndInstant * ONE_DAY_IN_MILLIS);
                    System.out.printf("MillisSinceEpoch: %d%n", offsetMillisFromEpoch);
                    System.out.printf("Resource calc of millisSinceEpoch: %d%n", daysBetweenEpochAndInstant * ONE_DAY_IN_MILLIS);
                }
                long effectiveCycleStartTime = instantAfterEpoch - epoch - (instantAfterEpoch - epoch) % ONE_DAY_IN_MILLIS;
                RollingResourcesCacheTest.assertCorrectConversion(cache, cycle, Instant.ofEpochMilli(effectiveCycleStartTime + epoch), DateTimeFormatter.ofPattern("yyyyMMdd").withZone(zoneId));
            }
        }
    }

    @Test
    public void testToLong() {
        this.doTestToLong((RollCycle)RollCycles.DAILY, 1523498933145L, 0L, Long.valueOf("17633"));
        this.doTestToLong((RollCycle)RollCycles.HOURLY, 1523498933145L, 0L, Long.valueOf("423192"));
        this.doTestToLong((RollCycle)RollCycles.MINUTELY, 1523498933145L, 0L, Long.valueOf("25391520"));
        this.doTestToLong((RollCycle)RollCycles.DAILY, 1523498933145L, 100L, Long.valueOf("17733"));
        this.doTestToLong((RollCycle)RollCycles.HOURLY, 1523498933145L, 100L, Long.valueOf("423292"));
        this.doTestToLong((RollCycle)RollCycles.MINUTELY, 1523498933145L, 100L, Long.valueOf("25391620"));
        this.doTestToLong((RollCycle)RollCycles.DAILY, 1284739200000L, 0L, Long.valueOf("14869"));
        this.doTestToLong((RollCycle)RollCycles.HOURLY, 1284739200000L, 0L, Long.valueOf("356856"));
        this.doTestToLong((RollCycle)RollCycles.MINUTELY, 1284739200000L, 0L, Long.valueOf("21411360"));
        this.doTestToLong((RollCycle)RollCycles.DAILY, 1284739200000L, 100L, Long.valueOf("14969"));
        this.doTestToLong((RollCycle)RollCycles.HOURLY, 1284739200000L, 100L, Long.valueOf("356956"));
        this.doTestToLong((RollCycle)RollCycles.MINUTELY, 1284739200000L, 100L, Long.valueOf("21411460"));
        this.doTestToLong((RollCycle)RollCycles.DAILY, 18000000L, 0L, Long.valueOf("0"));
        this.doTestToLong((RollCycle)RollCycles.HOURLY, 18000000L, 0L, Long.valueOf("0"));
        this.doTestToLong((RollCycle)RollCycles.MINUTELY, 18000000L, 0L, Long.valueOf("0"));
        this.doTestToLong((RollCycle)RollCycles.DAILY, 18000000L, 100L, Long.valueOf("100"));
        this.doTestToLong((RollCycle)RollCycles.HOURLY, 18000000L, 100L, Long.valueOf("100"));
        this.doTestToLong((RollCycle)RollCycles.MINUTELY, 18000000L, 100L, Long.valueOf("100"));
        this.doTestToLong((RollCycle)RollCycles.DAILY, -10800000L, 0L, Long.valueOf("-1"));
        this.doTestToLong((RollCycle)RollCycles.HOURLY, -10800000L, 0L, Long.valueOf("-24"));
        this.doTestToLong((RollCycle)RollCycles.MINUTELY, -10800000L, 0L, Long.valueOf("-1440"));
        this.doTestToLong((RollCycle)RollCycles.DAILY, -10800000L, 100L, Long.valueOf("99"));
        this.doTestToLong((RollCycle)RollCycles.HOURLY, -10800000L, 100L, Long.valueOf("76"));
        this.doTestToLong((RollCycle)RollCycles.MINUTELY, -10800000L, 100L, Long.valueOf("-1340"));
    }

    public void doTestToLong(RollCycle rollCycle, long epoch, long cycle, Long expectedLong) {
        RollingResourcesCache cache = new RollingResourcesCache(rollCycle, epoch, File::new, File::getName);
        RollingResourcesCache.Resource resource = cache.resourceFor(cycle);
        Assert.assertEquals((Object)expectedLong, (Object)cache.toLong(resource.path));
    }
}

