/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.junit.Test;

public class ChronicleRollingIssueTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() {
        int threads = Runtime.getRuntime().availableProcessors() - 1;
        int messages = 20;
        String path = OS.TARGET + "/" + this.getClass().getSimpleName() + "-" + System.nanoTime();
        AtomicInteger count = new AtomicInteger();
        Runnable appendRunnable = () -> {
            ChronicleQueue.singleBuilder();
            try (SingleChronicleQueue writeQueue = SingleChronicleQueueBuilder.single((String)path).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_SECONDLY).build();){
                for (int i = 0; i < messages; ++i) {
                    long millis = System.currentTimeMillis() % 1000L;
                    if (millis > 1L && millis < 999L) {
                        Jvm.pause((long)(999L - millis));
                    }
                    ExcerptAppender appender = writeQueue.acquireAppender();
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("key", Thread.currentThread().getName() + " - " + i);
                    appender.writeMap(map);
                    count.incrementAndGet();
                }
            }
        };
        for (int i = 0; i < threads; ++i) {
            new Thread(appendRunnable, "appender-" + i).start();
        }
        long start = System.currentTimeMillis();
        long lastIndex = 0L;
        try {
            ChronicleQueue.singleBuilder();
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((String)path).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_SECONDLY).build();){
                ExcerptTailer tailer = queue.createTailer();
                int count2 = 0;
                while (count2 < threads * messages) {
                    Map map = tailer.readMap();
                    long index = tailer.index();
                    if (map != null) {
                        ++count2;
                    } else if (index >= 0L && RollCycles.TEST_SECONDLY.toCycle(lastIndex) != RollCycles.TEST_SECONDLY.toCycle(index)) {
                        System.out.println("Wrote: " + count + " read: " + count2 + " index: " + Long.toHexString(index));
                        lastIndex = index;
                    }
                    int i = count.get();
                    if (System.currentTimeMillis() > start + 60000L) {
                        throw new AssertionError((Object)("Wrote: " + count + " read: " + count2 + " index: " + Long.toHexString(index)));
                    }
                }
            }
        }
        finally {
            try {
                IOTools.deleteDirWithFiles((String)path, (int)2);
            }
            catch (IORuntimeException iORuntimeException) {}
        }
    }
}

