/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import junit.framework.TestCase;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.DumpQueueMain;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestMethodWriterWithThreads {
    private static final int AMEND = 1;
    private static final int CREATE = 2;
    @Rule
    public final TestName testName = new TestName();
    private ThreadLocal<Amend> amendTL = ThreadLocal.withInitial(Amend::new);
    private ThreadLocal<Create> createTL = ThreadLocal.withInitial(Create::new);
    private I methodWriter;
    private AtomicBoolean fail = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws FileNotFoundException {
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue q = this.builder(tmpDir, WireType.BINARY).rollCycle((RollCycle)RollCycles.HOURLY).build();){
            this.methodWriter = (I)q.methodWriter(I.class, new Class[0]);
            ExcerptTailer tailer = q.createTailer();
            MethodReader methodReader = tailer.methodReader(new Object[]{this.newReader()});
            IntStream.range(0, 1000).parallel().forEach(i -> {
                this.creates();
                this.amends();
                MethodReader methodReader2 = methodReader;
                synchronized (methodReader2) {
                    int j = 0;
                    while (j < 2 && !this.fail.get()) {
                        if (!methodReader.readOne()) continue;
                        ++j;
                    }
                }
                if (this.fail.get()) {
                    TestCase.fail();
                }
            });
        }
        finally {
            if (this.fail.get()) {
                DumpQueueMain.dump((String)tmpDir.getAbsolutePath());
            }
        }
    }

    @NotNull
    private I newReader() {
        return new I(){

            @Override
            public void amend(Amend amend) {
                if (amend.type != 1) {
                    TestMethodWriterWithThreads.this.fail.set(true);
                    TestCase.fail((String)("amend type=" + amend.type));
                }
            }

            @Override
            public void create(Create create) {
                if (create.type != 2) {
                    TestMethodWriterWithThreads.this.fail.set(true);
                    TestCase.fail((String)("create type=" + create.type));
                }
            }
        };
    }

    private void amends() {
        this.methodWriter.amend(this.amendTL.get().type(1));
    }

    private void creates() {
        this.methodWriter.create(this.createTL.get().type(2));
    }

    @NotNull
    protected File getTmpDir() {
        String methodName = this.testName.getMethodName();
        return DirectoryUtils.tempDir(methodName != null ? methodName.replaceAll("[\\[\\]\\s]+", "_").replace(':', '_') : "NULL-" + UUID.randomUUID());
    }

    @NotNull
    protected SingleChronicleQueueBuilder builder(@NotNull File file, @NotNull WireType wireType) {
        return SingleChronicleQueueBuilder.builder((File)file, (WireType)wireType).rollCycle((RollCycle)RollCycles.TEST4_DAILY).testBlockSize();
    }

    public static class Create
    extends SelfDescribingMarshallable {
        int type;

        public Create type(int type) {
            this.type = type;
            return this;
        }
    }

    public static class Amend
    extends SelfDescribingMarshallable {
        int type;

        public Amend type(int type) {
            this.type = type;
            return this;
        }
    }

    public static interface I {
        public void amend(Amend var1);

        public void create(Create var1);
    }
}

