/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;

public enum RunLargeQueueMain {

    private static final int FILE_SIZE = Integer.getInteger("file.size", 1024);
    private static final int MSG_SIZE = Integer.getInteger("msg.size", 512);
    private static final double BLOCK_SIZE = Double.parseDouble(System.getProperty("block.size", "64"));
    private static final boolean PRETOUCH = Boolean.getBoolean("pretouch");

    public static void main(String[] args) {
        System.out.println("file.size: " + FILE_SIZE + " # GB");
        System.out.println("msg.size: " + MSG_SIZE + " # B");
        System.out.println("block.size: " + BLOCK_SIZE + " # MB");
        System.out.println("pretouch: " + PRETOUCH);
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((String)args[0]).blockSize((int)(BLOCK_SIZE * 1048576.0)).build();){
            ExcerptAppender appender = queue.acquireAppender();
            ExcerptTailer tailer = queue.createTailer();
            NativeBytesStore bytes = NativeBytesStore.nativeStore((long)MSG_SIZE);
            VanillaBytes bytes2 = Bytes.allocateDirect((long)MSG_SIZE);
            for (int t = 1; t <= FILE_SIZE; ++t) {
                long start = System.currentTimeMillis();
                for (int i = 0; i < 0x40000000; i += MSG_SIZE) {
                    appender.writeBytes((BytesStore)bytes);
                }
                long mid = System.currentTimeMillis();
                for (int i = 0; i < 0x40000000; i += MSG_SIZE) {
                    bytes2.clear();
                    tailer.readBytes((Bytes)bytes2);
                }
                long end = System.currentTimeMillis();
                System.out.printf("%d: Took %.3f seconds to write and %.3f seconds to read 1 GB%n", t, (double)(mid - start) / 1000.0, (double)(end - mid) / 1000.0);
                if (PRETOUCH) {
                    appender.pretouch();
                }
                Jvm.pause((long)8000L);
            }
        }
    }
}

