/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single.preroucher;

import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.queue.impl.single.preroucher.PeriodicUpdateEventHandler;
import net.openhft.chronicle.threads.MonitorEventLoop;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.PauserMonitor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Monitor {
    static final EventLoop loop = new MonitorEventLoop(null, (Pauser)Pauser.millis((int)10));
    private static final Logger LOG = LoggerFactory.getLogger(Monitor.class);

    public static void addTimingMonitor(String description, long timeLimit, LongSupplier timeSupplier, Supplier<Thread> threadSupplier) {
        loop.addHandler((EventHandler)new ThreadMonitorEventHandler(description, timeLimit, timeSupplier, threadSupplier));
    }

    public static void addPauser(String desc, Pauser pauser) {
        loop.addHandler((EventHandler)new PauserMonitor(pauser, desc, 3));
    }

    public static void addHeartbeatSource(long heartbeatMS, @NotNull Supplier<LongConsumer> heartbeatReceiverMethodSupplier) {
        long heartbeatUS = heartbeatMS * 1000L;
        loop.addHandler((EventHandler)new PeriodicUpdateEventHandler(heartbeatReceiverMethodSupplier, 0L, heartbeatUS));
    }

    public static void addPeriodicUpdateSource(long periodicUpdateMS, @NotNull Supplier<LongConsumer> updateReceiverMethodSupplier) {
        long periodicUpdateUS = periodicUpdateMS * 1000L;
        loop.addHandler((EventHandler)new PeriodicUpdateEventHandler(updateReceiverMethodSupplier, 0L, periodicUpdateUS));
    }

    public static void addPeriodicUpdateSource(long startTimeMillis, long periodicUpdateMS, @NotNull Supplier<LongConsumer> updateReceiverMethodSupplier) {
        long periodicUpdateUS = periodicUpdateMS * 1000L;
        loop.addHandler((EventHandler)new PeriodicUpdateEventHandler(updateReceiverMethodSupplier, startTimeMillis, periodicUpdateUS));
    }

    public static void close() {
        Closeable.closeQuietly((Object)loop);
    }

    static {
        loop.start();
    }

    static class ThreadMonitorEventHandler
    implements EventHandler {
        private final String description;
        private final long timeLimit;
        private final LongSupplier timeSupplier;
        private final Supplier<Thread> threadSupplier;
        private long lastTime = 0L;

        ThreadMonitorEventHandler(String description, long timeLimit, LongSupplier timeSupplier, Supplier<Thread> threadSupplier) {
            this.description = description;
            this.timeLimit = timeLimit;
            this.timeSupplier = timeSupplier;
            this.threadSupplier = threadSupplier;
        }

        public boolean action() {
            Thread thread;
            long time = this.timeSupplier.getAsLong();
            if (time == Long.MIN_VALUE) {
                return false;
            }
            long latency = System.nanoTime() - time;
            if (latency > this.timeLimit && (thread = this.threadSupplier.get()) != null && thread.isAlive() && LOG.isInfoEnabled()) {
                String type = time == this.lastTime ? "re-reporting" : "new report";
                StringBuilder out = new StringBuilder().append("THIS IS NOT AN ERROR, but a profile of the thread, ").append(this.description).append(" thread ").append(thread.getName()).append(" blocked for ").append(latency / 1000000L).append(" ms. ").append(type);
                Jvm.trimStackTrace((StringBuilder)out, (StackTraceElement[])thread.getStackTrace());
                LOG.info(out.toString());
                this.lastTime = time;
            }
            return false;
        }
    }
}

