/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.IOException;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.UncheckedBytes;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.values.Array;
import net.openhft.chronicle.values.MaxUtf8Length;
import net.openhft.chronicle.values.Values;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Test;

public class SingleChroniclePerfMain {
    static final int count = 1000000;
    static final int size = 4096;
    static int s32;
    static long s64;
    static float f32;
    static double f64;
    static String s;

    public static void main(String[] args) throws IOException {
        for (int t = 0; t < 2; ++t) {
            SingleChroniclePerfMain.doPerfTest(bytes -> SingleChroniclePerfMain.writeMany(bytes, 4096), bytes -> SingleChroniclePerfMain.readMany(bytes, 4096), t == 0 ? 100000 : 1000000, t > 0);
        }
    }

    static void doPerfTest(TestWriter<Bytes> writer, TestReader<Bytes> reader, int count, boolean print) throws IOException {
        Histogram writeHdr = new Histogram(30, 7);
        Histogram readHdr = new Histogram(30, 7);
        String file = OS.TARGET + "/deleteme-" + System.nanoTime();
        try (SingleChronicleQueue chronicle = SingleChronicleQueueBuilder.single((String)file).blockSize(0x4000000).build();){
            ExcerptAppender appender = chronicle.createAppender();
            UncheckedBytes bytes = new UncheckedBytes(NoBytesStore.NO_BYTES);
            for (int i = 0; i < count; ++i) {
                long start = System.nanoTime();
                try (DocumentContext dc = appender.writingDocument();){
                    Bytes bytes0 = dc.wire().bytes();
                    bytes0.ensureCapacity(4096L);
                    bytes.setBytes(bytes0);
                    bytes.readPosition(bytes.writePosition());
                    writer.writeTo((Bytes)bytes);
                    bytes0.writePosition(bytes.writePosition());
                }
                long time = System.nanoTime() - start;
                writeHdr.sample((double)time);
            }
            ExcerptTailer tailer = chronicle.createTailer();
            for (int i = 0; i < count; ++i) {
                long start2 = System.nanoTime();
                try (DocumentContext dc = tailer.readingDocument();){
                    Assert.assertTrue((boolean)dc.isPresent());
                    Bytes bytes0 = dc.wire().bytes();
                    long remaining = bytes0.readRemaining();
                    bytes.setBytes(bytes0);
                    reader.readFrom((Bytes)bytes);
                }
                long time2 = System.nanoTime() - start2;
                readHdr.sample((double)time2);
            }
        }
        if (print) {
            System.out.println("Write latencies " + writeHdr.toMicrosFormat());
            System.out.println("Read latencies " + readHdr.toMicrosFormat());
        }
        IOTools.deleteDirWithFiles((String)file, (int)3);
    }

    static void writeMany(Bytes bytes, int size) {
        for (int i = 0; i < size; i += 32) {
            bytes.writeInt(i);
            bytes.writeFloat((float)i);
            bytes.writeLong((long)i);
            bytes.writeDouble((double)i);
            bytes.writeUtf8("Hello!!");
        }
    }

    static void readMany(Bytes bytes, int size) {
        for (int i = 0; i < size; i += 32) {
            s32 = bytes.readInt();
            f32 = bytes.readFloat();
            s64 = bytes.readLong();
            f64 = bytes.readDouble();
            s = bytes.readUtf8();
            Assert.assertEquals((Object)"Hello!!", (Object)s);
        }
    }

    @Test
    public void testFacarde() {
        IFacade f = (IFacade)Values.newNativeReference(IFacade.class);
        Byteable byteable = (Byteable)f;
        long capacity = byteable.maxSize();
        byteable.bytesStore((BytesStore)NativeBytesStore.nativeStore((long)capacity), 0L, capacity);
        System.out.println(f);
    }

    static {
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "INFO");
    }

    static interface IFacade
    extends IFacadeBase {
        @Array(length=3)
        public void setDaughterAt(int var1, IFacadeDaughter var2);

        public IFacadeDaughter getDaughterAt(int var1);

        @Array(length=3)
        public void setSonAt(int var1, IFacadeSon var2);

        public IFacadeSon getSonAt(int var1);
    }

    static interface IFacadeDaughter
    extends IFacadeBase {
        public long getValue33();

        public void setValue33(long var1);

        public String getValue34();

        public void setValue34(@MaxUtf8Length(value=11) String var1);

        public int getValue35();

        public void setValue35(int var1);

        public String getValue36();

        public void setValue36(@MaxUtf8Length(value=11) String var1);

        public int getValue37();

        public void setValue37(int var1);

        public long getValue38();

        public void setValue38(long var1);

        public short getValue39();

        public void setValue39(short var1);

        public long getValue40();

        public void setValue40(long var1);

        public String getValue41();

        public void setValue41(@MaxUtf8Length(value=43) String var1);

        public long getValue42();

        public void setValue42(long var1);

        public long getValue43();

        public void setValue43(long var1);

        public long getValue44();

        public void setValue44(long var1);

        public long getValue45();

        public void setValue45(long var1);

        public long getValue46();

        public void setValue46(long var1);

        public byte getValue47();

        public void setValue47(byte var1);

        public byte getValue48();

        public void setValue48(byte var1);

        public double getValue49();

        public void setValue49(double var1);

        public double getValue50();

        public void setValue50(double var1);

        public double getValue51();

        public void setValue51(double var1);

        public byte getValue52();

        public void setValue52(byte var1);

        public byte getValue53();

        public void setValue53(byte var1);

        public byte getValue54();

        public void setValue54(byte var1);

        public byte getValue55();

        public void setValue55(byte var1);

        public byte getValue56();

        public void setValue56(byte var1);

        public long getValue57();

        public void setValue57(long var1);

        public byte getValue58();

        public void setValue58(byte var1);

        public double getValue59();

        public void setValue59(double var1);

        public double getValue60();

        public void setValue60(double var1);

        public double getValue61();

        public void setValue61(double var1);

        public double getValue62();

        public void setValue62(double var1);

        public double getValue63();

        public void setValue63(double var1);

        public long getValue64();

        public void setValue64(long var1);

        public long getValue65();

        public void setValue65(long var1);

        public double getValue66();

        public void setValue66(double var1);

        public double getValue67();

        public void setValue67(double var1);

        public short getValue68();

        public void setValue68(short var1);

        public String getValue69();

        public void setValue69(@MaxUtf8Length(value=101) String var1);

        public String getValue70();

        public void setValue70(@MaxUtf8Length(value=17) String var1);

        public boolean getValue71();

        public void setValue71(boolean var1);

        public boolean getValue72();

        public void setValue72(boolean var1);

        public String getValue73();

        public void setValue73(@MaxUtf8Length(value=11) String var1);

        public String getValue74();

        public void setValue74(@MaxUtf8Length(value=9) String var1);

        public byte getValue75();

        public void setValue75(byte var1);

        public int getValue76();

        public void setValue76(int var1);

        public int getValue77();

        public void setValue77(int var1);

        public String getValue78();

        public void setValue78(@MaxUtf8Length(value=3) String var1);

        public int getValue79();

        public void setValue79(int var1);

        public double getValue80();

        public void setValue80(double var1);

        public byte getValue81();

        public void setValue81(byte var1);

        public byte getValue82();

        public void setValue82(byte var1);

        public byte getValue83();

        public void setValue83(byte var1);

        public byte getValue84();

        public void setValue84(byte var1);

        public byte getValue85();

        public void setValue85(byte var1);

        public byte getValue86();

        public void setValue86(byte var1);

        public byte getValue87();

        public void setValue87(byte var1);

        public byte getValue88();

        public void setValue88(byte var1);

        public int getValue89();

        public void setValue89(int var1);

        public int getValue90();

        public void setValue90(int var1);

        public int getValue91();

        public void setValue91(int var1);

        public int getValue92();

        public void setValue92(int var1);

        public int getValue93();

        public void setValue93(int var1);

        public int getValue94();

        public void setValue94(int var1);

        public int getValue95();

        public void setValue95(int var1);

        public int getValue96();

        public void setValue96(int var1);

        public int getValue97();

        public void setValue97(int var1);

        public int getValue98();

        public void setValue98(int var1);

        public int getValue99();

        public void setValue99(int var1);

        public int getValue100();

        public void setValue100(int var1);

        public int getValue101();

        public void setValue101(int var1);

        public int getValue102();

        public void setValue102(int var1);

        public int getValue103();

        public void setValue103(int var1);

        public int getValue104();

        public void setValue104(int var1);

        public double getValue105();

        public void setValue105(double var1);

        public double getValue106();

        public void setValue106(double var1);

        public long getValue107();

        public void setValue107(long var1);

        public long getValue108();

        public void setValue108(long var1);

        public long getValue109();

        public void setValue109(long var1);

        public byte getValue110();

        public void setValue110(byte var1);

        public byte getValue111();

        public void setValue111(byte var1);

        public byte getValue112();

        public void setValue112(byte var1);

        public byte getValue113();

        public void setValue113(byte var1);

        public byte getValue114();

        public void setValue114(byte var1);

        public byte getValue115();

        public void setValue115(byte var1);

        public byte getValue116();

        public void setValue116(byte var1);

        public byte getValue117();

        public void setValue117(byte var1);

        public byte getValue118();

        public void setValue118(byte var1);

        public byte getValue119();

        public void setValue119(byte var1);

        public byte getValue120();

        public void setValue120(byte var1);

        public byte getValue121();

        public void setValue121(byte var1);

        public byte getValue122();

        public void setValue122(byte var1);

        public byte getValue123();

        public void setValue123(byte var1);

        public byte getValue124();

        public void setValue124(byte var1);

        public byte getValue125();

        public void setValue125(byte var1);

        public int getValue126();

        public void setValue126(int var1);

        public int getValue127();

        public void setValue127(int var1);

        public int getValue128();

        public void setValue128(int var1);

        public int getValue129();

        public void setValue129(int var1);

        public int getValue130();

        public void setValue130(int var1);

        public int getValue131();

        public void setValue131(int var1);

        public int getValue132();

        public void setValue132(int var1);

        public int getValue133();

        public void setValue133(int var1);

        public int getValue134();

        public void setValue134(int var1);

        public int getValue135();

        public void setValue135(int var1);

        public int getValue136();

        public void setValue136(int var1);

        public int getValue137();

        public void setValue137(int var1);

        public int getValue138();

        public void setValue138(int var1);

        public int getValue139();

        public void setValue139(int var1);

        public int getValue140();

        public void setValue140(int var1);

        public int getValue141();

        public void setValue141(int var1);

        public double getValue142();

        public void setValue142(double var1);

        public double getValue143();

        public void setValue143(double var1);

        public byte getValue144();

        public void setValue144(byte var1);

        public String getValue145();

        public void setValue145(@MaxUtf8Length(value=3) String var1);

        public short getValue146();

        public void setValue146(short var1);

        public byte getValue147();

        public void setValue147(byte var1);

        public byte getValue148();

        public void setValue148(byte var1);

        public int getValue149();

        public void setValue149(int var1);

        public short getValue150();

        public void setValue150(short var1);

        public boolean getValue151();

        public void setValue151(boolean var1);

        public boolean getValue152();

        public void setValue152(boolean var1);

        public short getValue153();

        public void setValue153(short var1);

        public short getValue154();

        public void setValue154(short var1);

        public long getValue155();

        public void setValue155(long var1);

        public long getValue156();

        public void setValue156(long var1);

        public long getValue157();

        public void setValue157(long var1);

        public long getValue158();

        public void setValue158(long var1);

        public long getValue159();

        public void setValue159(long var1);

        public long getValue160();

        public void setValue160(long var1);

        public long getValue161();

        public void setValue161(long var1);

        public short getValue162();

        public void setValue162(short var1);

        public short getValue163();

        public void setValue163(short var1);

        public short getValue164();

        public void setValue164(short var1);
    }

    static interface IFacadeSon
    extends IFacadeBase {
        public long getValue19();

        public void setValue19(long var1);

        public int getValue20();

        public void setValue20(int var1);

        public int getValue21();

        public void setValue21(int var1);

        public double getValue22();

        public void setValue22(double var1);

        public String getValue23();

        public void setValue23(@MaxUtf8Length(value=10) String var1);

        public int getValue24();

        public void setValue24(int var1);

        public double getValue25();

        public void setValue25(double var1);

        public byte getValue26();

        public void setValue26(byte var1);

        public double getValue27();

        public void setValue27(double var1);

        public double getValue28();

        public void setValue28(double var1);

        public double getValue29();

        public void setValue29(double var1);

        public double getValue30();

        public void setValue30(double var1);

        public double getValue31();

        public void setValue31(double var1);

        public double getValue32();

        public void setValue32(double var1);
    }

    static interface IFacadeBase {
        public short getValue0();

        public void setValue0(short var1);

        public byte getValue1();

        public void setValue1(byte var1);

        public byte getValue2();

        public void setValue2(byte var1);

        public int getValue3();

        public void setValue3(int var1);

        public short getValue4();

        public void setValue4(short var1);

        public boolean getValue5();

        public void setValue5(boolean var1);

        public boolean getValue6();

        public void setValue6(boolean var1);

        public short getValue7();

        public void setValue7(short var1);

        public short getValue8();

        public void setValue8(short var1);

        public long getValue9();

        public void setValue9(long var1);

        public long getValue10();

        public void setValue10(long var1);

        public long getValue11();

        public void setValue11(long var1);

        public long getValue12();

        public void setValue12(long var1);

        public long getValue13();

        public void setValue13(long var1);

        public long getValue14();

        public void setValue14(long var1);

        public long getValue15();

        public void setValue15(long var1);

        public short getValue16();

        public void setValue16(short var1);

        public short getValue17();

        public void setValue17(short var1);

        public short getValue18();

        public void setValue18(short var1);
    }

    static interface TestReader<T> {
        public void readFrom(T var1);
    }

    static interface TestWriter<T> {
        public void writeTo(T var1);
    }
}

