/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.time;

import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;

public enum UniqueMicroTimeProvider implements TimeProvider
{
    INSTANCE;

    private final AtomicLong lastTime = new AtomicLong();
    private TimeProvider provider = SystemTimeProvider.INSTANCE;

    public UniqueMicroTimeProvider provider(TimeProvider provider) {
        this.provider = provider;
        this.lastTime.set(provider.currentTimeMicros());
        return this;
    }

    @Override
    public long currentTimeMillis() {
        return this.provider.currentTimeMillis();
    }

    @Override
    public long currentTimeMicros() {
        long time0;
        long time = this.provider.currentTimeMicros();
        do {
            if ((time0 = this.lastTime.get()) < time) continue;
            time = time0 + 1L;
        } while (!this.lastTime.compareAndSet(time0, time));
        return time;
    }
}

