/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.text.ParseException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesRingBufferStats;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.ThreadLocalHelper;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.BufferMode;
import net.openhft.chronicle.queue.CycleCalculator;
import net.openhft.chronicle.queue.DefaultCycleCalculator;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.CommonStore;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.RollingResourcesCache;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.WireStorePool;
import net.openhft.chronicle.queue.impl.WireStoreSupplier;
import net.openhft.chronicle.queue.impl.single.DirectoryListing;
import net.openhft.chronicle.queue.impl.single.FileSystemDirectoryListing;
import net.openhft.chronicle.queue.impl.single.MetaDataKeys;
import net.openhft.chronicle.queue.impl.single.PrecreatedFiles;
import net.openhft.chronicle.queue.impl.single.QueueLock;
import net.openhft.chronicle.queue.impl.single.ReferenceCountedCache;
import net.openhft.chronicle.queue.impl.single.SCQMeta;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueExcerpts;
import net.openhft.chronicle.queue.impl.single.StoreComponentReferenceHandler;
import net.openhft.chronicle.queue.impl.single.TableDirectoryListing;
import net.openhft.chronicle.queue.impl.single.WriteLock;
import net.openhft.chronicle.threads.DiskSpaceMonitor;
import net.openhft.chronicle.threads.TimingPauser;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleChronicleQueue
implements RollingChronicleQueue {
    public static final String SUFFIX = ".cq4";
    public static final String QUEUE_METADATA_FILE = "metadata.cq4t";
    public static final String DISK_SPACE_CHECKER_NAME = "disk-space-checker";
    private static final Logger LOG = LoggerFactory.getLogger(SingleChronicleQueue.class);
    private static final boolean SHOULD_CHECK_CYCLE = Boolean.getBoolean("chronicle.queue.checkrollcycle");
    private static final boolean SHOULD_RELEASE_RESOURCES = Boolean.valueOf(System.getProperty("chronicle.queue.release.weakRef.resources", "true"));
    protected final ThreadLocal<WeakReference<ExcerptAppender>> weakExcerptAppenderThreadLocal = new ThreadLocal();
    protected final ThreadLocal<ExcerptAppender> strongExcerptAppenderThreadLocal = new ThreadLocal();
    @NotNull
    protected final EventLoop eventLoop;
    @NotNull
    protected final TableStore<SCQMeta> metaStore;
    final Supplier<TimingPauser> pauserSupplier;
    final long timeoutMS;
    @NotNull
    final File path;
    final String fileAbsolutePath;
    final AtomicBoolean isClosed = new AtomicBoolean();
    private final StoreSupplier storeSupplier;
    private final ThreadLocal<WeakReference<SingleChronicleQueueExcerpts.StoreTailer>> tlTailer = new ThreadLocal();
    @NotNull
    private final WireStorePool pool;
    private final long epoch;
    private final boolean isBuffered;
    @NotNull
    private final WireType wireType;
    private final long blockSize;
    private final long overlapSize;
    @NotNull
    private final Consumer<BytesRingBufferStats> onRingBufferStats;
    private final long bufferCapacity;
    private final int indexSpacing;
    private final int indexCount;
    @NotNull
    private final TimeProvider time;
    @NotNull
    private final BiFunction<RollingChronicleQueue, Wire, WireStore> storeFactory;
    private final Map<Object, Consumer> closers = new WeakHashMap<Object, Consumer>();
    private final boolean readOnly;
    @NotNull
    private final CycleCalculator cycleCalculator;
    @Nullable
    private final LongValue lastAcknowledgedIndexReplicated;
    @Nullable
    private final LongValue lastIndexReplicated;
    @NotNull
    private final DirectoryListing directoryListing;
    @NotNull
    private final QueueLock queueLock;
    @NotNull
    private final WriteLock writeLock;
    private final boolean strongAppenders;
    private final boolean checkInterrupts;
    @NotNull
    private final RollingResourcesCache dateCache;
    protected int sourceId;
    long firstAndLastCycleTime = 0L;
    int firstCycle = Integer.MAX_VALUE;
    int lastCycle = Integer.MIN_VALUE;
    private StoreFileListener storeFileListener;
    @NotNull
    private RollCycle rollCycle;
    private int deltaCheckpointInterval;

    protected SingleChronicleQueue(@NotNull SingleChronicleQueueBuilder builder) {
        this.rollCycle = builder.rollCycle();
        this.cycleCalculator = this.cycleCalculator(builder.rollTimeZone());
        this.epoch = builder.epoch();
        this.dateCache = new RollingResourcesCache(this.rollCycle, this.epoch, this.textToFile(builder), this.fileToText());
        this.storeFileListener = builder.storeFileListener();
        this.storeSupplier = new StoreSupplier();
        this.pool = WireStorePool.withSupplier(this.storeSupplier, this.storeFileListener);
        this.isBuffered = BufferMode.Asynchronous == builder.writeBufferMode();
        this.path = builder.path();
        if (!builder.readOnly()) {
            this.path.mkdirs();
        }
        this.fileAbsolutePath = this.path.getAbsolutePath();
        this.wireType = builder.wireType();
        this.blockSize = builder.blockSize();
        this.overlapSize = Math.max(65536L, builder.blockSize() / 4L);
        this.eventLoop = builder.eventLoop();
        this.bufferCapacity = builder.bufferCapacity();
        this.onRingBufferStats = builder.onRingBufferStats();
        this.indexCount = builder.indexCount();
        this.indexSpacing = builder.indexSpacing();
        this.time = builder.timeProvider();
        this.pauserSupplier = builder.pauserSupplier();
        this.timeoutMS = (long)((double)builder.timeoutMS() * (1.0 + 0.2 * (double)ThreadLocalRandom.current().nextFloat()));
        this.storeFactory = builder.storeFactory();
        this.strongAppenders = builder.strongAppenders();
        this.checkInterrupts = builder.checkInterrupts();
        this.metaStore = builder.metaStore();
        if (this.metaStore.readOnly() && !builder.readOnly()) {
            LOG.warn("Forcing queue to be readOnly");
            builder.readOnly(this.metaStore.readOnly());
        }
        this.readOnly = builder.readOnly();
        if (this.readOnly) {
            this.directoryListing = new FileSystemDirectoryListing(this.path, this.fileToCycleFunction());
        } else {
            this.directoryListing = new TableDirectoryListing(this.metaStore, this.path.toPath(), this.fileToCycleFunction(), false);
            this.directoryListing.init();
        }
        this.directoryListing.refresh();
        this.queueLock = builder.queueLock();
        this.writeLock = builder.writeLock();
        if (this.readOnly) {
            this.lastIndexReplicated = null;
            this.lastAcknowledgedIndexReplicated = null;
        } else {
            this.lastIndexReplicated = this.metaStore.doWithExclusiveLock(ts -> ts.acquireValueFor("chronicle.lastIndexReplicated", -1L));
            this.lastAcknowledgedIndexReplicated = this.metaStore.doWithExclusiveLock(ts -> ts.acquireValueFor("chronicle.lastAcknowledgedIndexReplicated", -1L));
        }
        this.deltaCheckpointInterval = builder.deltaCheckpointInterval();
        this.sourceId = builder.sourceId();
    }

    protected CycleCalculator cycleCalculator(ZoneId zoneId) {
        return DefaultCycleCalculator.INSTANCE;
    }

    @NotNull
    SingleChronicleQueueExcerpts.StoreTailer acquireTailer() {
        if (SHOULD_RELEASE_RESOURCES) {
            return ThreadLocalHelper.getTL(this.tlTailer, this, SingleChronicleQueueExcerpts.StoreTailer::new, StoreComponentReferenceHandler.tailerQueue(), ref -> StoreComponentReferenceHandler.register(ref, ((SingleChronicleQueueExcerpts.StoreTailer)ref.get()).getCloserJob()));
        }
        return ThreadLocalHelper.getTL(this.tlTailer, this, SingleChronicleQueueExcerpts.StoreTailer::new);
    }

    @NotNull
    private Function<String, File> textToFile(@NotNull SingleChronicleQueueBuilder builder) {
        return name -> new File(builder.path(), name + SUFFIX);
    }

    @NotNull
    private Function<File, String> fileToText() {
        return file -> {
            String name = file.getName();
            return name.substring(0, name.length() - SUFFIX.length());
        };
    }

    @Override
    public int sourceId() {
        return this.sourceId;
    }

    @Override
    public long lastAcknowledgedIndexReplicated() {
        return this.lastAcknowledgedIndexReplicated == null ? -1L : this.lastAcknowledgedIndexReplicated.getVolatileValue();
    }

    @Override
    public void lastAcknowledgedIndexReplicated(long newValue) {
        if (this.lastAcknowledgedIndexReplicated != null) {
            this.lastAcknowledgedIndexReplicated.setMaxValue(newValue);
        }
    }

    @Override
    public void refreshDirectlyListing() {
        this.directoryListing.forceRefresh();
        this.firstCycle = this.directoryListing.getMinCreatedCycle();
        this.lastCycle = this.directoryListing.getMaxCreatedCycle();
    }

    @Override
    public long lastIndexReplicated() {
        return this.lastIndexReplicated == null ? -1L : this.lastIndexReplicated.getVolatileValue();
    }

    @Override
    public void lastIndexReplicated(long indexReplicated) {
        if (this.lastIndexReplicated != null) {
            this.lastIndexReplicated.setMaxValue(indexReplicated);
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    @NotNull
    public File file() {
        return this.path;
    }

    @Override
    @NotNull
    public String fileAbsolutePath() {
        return this.fileAbsolutePath;
    }

    @Override
    public String dumpLastHeader() {
        StringBuilder sb = new StringBuilder(256);
        WireStore wireStore = this.storeForCycle(this.lastCycle(), this.epoch, false);
        if (wireStore != null) {
            try {
                sb.append(wireStore.dumpHeader());
            }
            finally {
                this.release(wireStore);
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String dump() {
        StringBuilder sb = new StringBuilder(1024);
        int max = this.lastCycle();
        for (int i = this.firstCycle(); i <= max; ++i) {
            WireStore commonStore = this.storeForCycle(i, this.epoch, false);
            if (commonStore == null) continue;
            try {
                sb.append(commonStore.dump());
                continue;
            }
            finally {
                this.release(commonStore);
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void dump(@NotNull Writer writer, long fromIndex, long toIndex) {
        try {
            long firstIndex = this.firstIndex();
            writer.append("# firstIndex: ").append(Long.toHexString(firstIndex)).append("\n");
            ExcerptTailer tailer = this.createTailer();
            if (!tailer.moveToIndex(fromIndex)) {
                if (firstIndex <= fromIndex) return;
                tailer.toStart();
            }
            Bytes<?> bytes = Wires.acquireBytes();
            TextWire text = new TextWire(bytes);
            while (true) {
                Throwable throwable;
                DocumentContext dc;
                block40: {
                    block41: {
                        block38: {
                            block39: {
                                dc = tailer.readingDocument();
                                throwable = null;
                                if (dc.isPresent()) break block38;
                                writer.append("# no more messages at ").append(Long.toHexString(dc.index())).append("\n");
                                if (dc == null) return;
                                if (throwable == null) break block39;
                                try {
                                    dc.close();
                                    return;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                    return;
                                }
                            }
                            dc.close();
                            return;
                        }
                        if (dc.index() <= toIndex) break block40;
                        if (dc == null) return;
                        if (throwable == null) break block41;
                        try {
                            dc.close();
                            return;
                        }
                        catch (Throwable e) {
                            throwable.addSuppressed(e);
                            return;
                        }
                    }
                    dc.close();
                    return;
                }
                try {
                    writer.append("# index: ").append(Long.toHexString(dc.index())).append("\n");
                    Wire wire = dc.wire();
                    long start = wire.bytes().readPosition();
                    try {
                        text.clear();
                        wire.copyTo(text);
                        writer.append(bytes.toString());
                    }
                    catch (Exception e) {
                        wire.bytes().readPosition(start);
                        writer.append(wire.bytes()).append("\n");
                    }
                    continue;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    dc.close();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace(new PrintWriter(writer));
            return;
        }
        finally {
            try {
                writer.flush();
            }
            catch (IOException e) {
                LoggerFactory.getLogger(SingleChronicleQueue.class).debug("", e);
            }
        }
    }

    @Override
    public int indexCount() {
        return this.indexCount;
    }

    @Override
    public int indexSpacing() {
        return this.indexSpacing;
    }

    @Override
    public long epoch() {
        return this.epoch;
    }

    @Override
    @NotNull
    public RollCycle rollCycle() {
        return this.rollCycle;
    }

    @Override
    public int deltaCheckpointInterval() {
        return this.deltaCheckpointInterval;
    }

    public boolean buffered() {
        return this.isBuffered;
    }

    @NotNull
    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    @NotNull
    protected ExcerptAppender newAppender() {
        this.queueLock.waitForLock();
        WireStorePool newPool = WireStorePool.withSupplier(this.storeSupplier, this.storeFileListener);
        return new SingleChronicleQueueExcerpts.StoreAppender(this, newPool, this.checkInterrupts);
    }

    protected StoreFileListener storeFileListener() {
        return this.storeFileListener;
    }

    WireStoreSupplier storeSupplier() {
        return this.storeSupplier;
    }

    @Override
    @NotNull
    public ExcerptAppender acquireAppender() {
        ExcerptAppender appender;
        if (this.readOnly) {
            throw new IllegalStateException("Can't append to a read-only chronicle");
        }
        assert (!this.isClosed());
        if (this.strongAppenders && (appender = this.strongExcerptAppenderThreadLocal.get()) != null) {
            return appender;
        }
        return this.createExcerptAppender();
    }

    @NotNull
    private ExcerptAppender createExcerptAppender() {
        if (SHOULD_RELEASE_RESOURCES) {
            return ThreadLocalHelper.getTL(this.weakExcerptAppenderThreadLocal, this, SingleChronicleQueue::newAppender, StoreComponentReferenceHandler.appenderQueue(), ref -> StoreComponentReferenceHandler.register(ref, ((ExcerptAppender)ref.get()).getCloserJob()));
        }
        ExcerptAppender appender = ThreadLocalHelper.getTL(this.weakExcerptAppenderThreadLocal, this, SingleChronicleQueue::newAppender);
        if (this.strongAppenders) {
            this.strongExcerptAppenderThreadLocal.set(appender);
        }
        return appender;
    }

    @Override
    @NotNull
    public QueueLock queueLock() {
        return this.queueLock;
    }

    @NotNull
    WriteLock writeLock() {
        return this.writeLock;
    }

    @Override
    @NotNull
    public ExcerptTailer createTailer(String id) {
        LongValue index = id == null ? null : this.metaStore.doWithExclusiveLock(ts -> ts.acquireValueFor("index." + id, 0L));
        SingleChronicleQueueExcerpts.StoreTailer storeTailer = new SingleChronicleQueueExcerpts.StoreTailer(this, index);
        this.directoryListing.refresh();
        if (SHOULD_RELEASE_RESOURCES) {
            StoreComponentReferenceHandler.register(new WeakReference<SingleChronicleQueueExcerpts.StoreTailer>(storeTailer, StoreComponentReferenceHandler.tailerQueue()), storeTailer.getCloserJob());
        }
        return storeTailer;
    }

    @Override
    @NotNull
    public ExcerptTailer createTailer() {
        return this.createTailer(null);
    }

    @Override
    @Nullable
    public final WireStore storeForCycle(int cycle, long epoch, boolean createIfAbsent) {
        return this.pool.acquire(cycle, epoch, createIfAbsent);
    }

    @Override
    public int nextCycle(int cycle, @NotNull TailerDirection direction) throws ParseException {
        return this.pool.nextCycle(cycle, direction);
    }

    public long exceptsPerCycle(int cycle) {
        SingleChronicleQueueExcerpts.StoreTailer tailer = this.acquireTailer();
        try {
            long index = this.rollCycle.toIndex(cycle, 0L);
            if (tailer.moveToIndex(index)) {
                assert (tailer.store != null && tailer.store.refCount() > 0L);
                long l = tailer.store.lastSequenceNumber(tailer) + 1L;
                return l;
            }
            long l = -1L;
            return l;
        }
        catch (StreamCorruptedException e) {
            throw new IllegalStateException(e);
        }
        finally {
            tailer.release();
        }
    }

    @Override
    public long countExcerpts(long fromIndex, long toIndex) throws IllegalStateException {
        NavigableSet<Long> cycles;
        int upperCycle;
        int lowerCycle;
        if (fromIndex > toIndex) {
            long temp = fromIndex;
            fromIndex = toIndex;
            toIndex = temp;
        }
        if (fromIndex == toIndex) {
            return 0L;
        }
        long result = 0L;
        RollCycle rollCycle = this.rollCycle();
        long sequenceNotSet = rollCycle.toSequenceNumber(-1L);
        if (rollCycle.toSequenceNumber(fromIndex) == sequenceNotSet) {
            ++result;
            ++fromIndex;
        }
        if (rollCycle.toSequenceNumber(toIndex) == sequenceNotSet) {
            --result;
            ++toIndex;
        }
        if ((lowerCycle = rollCycle.toCycle(fromIndex)) == (upperCycle = rollCycle.toCycle(toIndex))) {
            return toIndex - fromIndex;
        }
        long upperSeqNum = rollCycle.toSequenceNumber(toIndex);
        long lowerSeqNum = rollCycle.toSequenceNumber(fromIndex);
        if (lowerCycle + 1 == upperCycle) {
            long l = this.exceptsPerCycle(lowerCycle);
            return result += l - lowerSeqNum + upperSeqNum;
        }
        try {
            cycles = this.listCyclesBetween(lowerCycle, upperCycle);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if ((Long)cycles.first() == (long)lowerCycle) {
            long l = this.exceptsPerCycle(lowerCycle);
            result += l - lowerSeqNum;
        } else {
            throw new IllegalStateException("Cycle not found, lower-cycle=" + Long.toHexString(lowerCycle));
        }
        if ((Long)cycles.last() == (long)upperCycle) {
            result += upperSeqNum;
        } else {
            throw new IllegalStateException("Cycle not found,  upper-cycle=" + Long.toHexString(upperCycle));
        }
        if (cycles.size() == 2) {
            return result;
        }
        long[] array = cycles.stream().mapToLong(i -> i).toArray();
        for (int i2 = 1; i2 < array.length - 1; ++i2) {
            long x = this.exceptsPerCycle(Math.toIntExact(array[i2]));
            result += x;
        }
        return result;
    }

    public NavigableSet<Long> listCyclesBetween(int lowerCycle, int upperCycle) throws ParseException {
        return this.pool.listCyclesBetween(lowerCycle, upperCycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addCloseListener(T key, Consumer<T> closer) {
        Map<Object, Consumer> map = this.closers;
        synchronized (map) {
            this.closers.put(key, closer);
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isClosed.getAndSet(true)) {
            return;
        }
        Closeable.closeQuietly(this.directoryListing, this.queueLock, this.writeLock, this.lastAcknowledgedIndexReplicated, this.lastIndexReplicated);
        Map<Object, Consumer> map = this.closers;
        synchronized (map) {
            this.closers.forEach((k, v) -> v.accept(k));
            this.closers.clear();
        }
        this.pool.close();
        Closeable.closeQuietly(this.metaStore);
    }

    @Override
    public final void release(@Nullable CommonStore store) {
        if (store != null) {
            this.pool.release(store);
        }
    }

    @Override
    public final int cycle() {
        return this.cycleCalculator.currentCycle(this.rollCycle, this.time, this.epoch);
    }

    public final int cycle(TimeProvider timeProvider) {
        return this.cycleCalculator.currentCycle(this.rollCycle, timeProvider, this.epoch);
    }

    @Override
    public long firstIndex() {
        int cycle = this.firstCycle();
        if (cycle == Integer.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return this.rollCycle().toIndex(cycle, 0L);
    }

    @Override
    public long entryCount() {
        ExcerptTailer tailer = this.createTailer();
        tailer.toEnd();
        long lastIndex = tailer.index();
        if (lastIndex == 0L) {
            return 0L;
        }
        return this.countExcerpts(this.firstIndex(), lastIndex);
    }

    @Nullable
    String[] getList() {
        return this.path.list();
    }

    private void setFirstAndLastCycle() {
        long now = this.time.currentTimeMillis();
        if (now <= this.firstAndLastCycleTime) {
            return;
        }
        this.firstCycle = this.directoryListing.getMinCreatedCycle();
        this.lastCycle = this.directoryListing.getMaxCreatedCycle();
        this.firstAndLastCycleTime = now;
    }

    @Override
    public int firstCycle() {
        this.setFirstAndLastCycle();
        return this.firstCycle;
    }

    void onRoll(int cycle) {
        if (this.lastCycle < cycle) {
            this.lastCycle = cycle;
        }
        if (this.firstCycle > cycle) {
            this.firstCycle = cycle;
        }
    }

    @Override
    public int lastCycle() {
        this.setFirstAndLastCycle();
        return this.lastCycle;
    }

    protected int fileToCycle(File queueFile) {
        return this.fileToCycleFunction().applyAsInt(queueFile);
    }

    @NotNull
    public Consumer<BytesRingBufferStats> onRingBufferStats() {
        return this.onRingBufferStats;
    }

    public long blockSize() {
        return this.blockSize;
    }

    public long overlapSize() {
        return this.overlapSize;
    }

    @Override
    @NotNull
    public WireType wireType() {
        return this.wireType;
    }

    public long bufferCapacity() {
        return this.bufferCapacity;
    }

    @NotNull
    MappedFile mappedFile(File file) throws FileNotFoundException {
        long chunkSize = OS.pageAlign(this.blockSize);
        long overlapSize = OS.pageAlign(this.blockSize / 4L);
        return MappedFile.of(file, chunkSize, overlapSize, this.readOnly);
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    private int toCycle(@Nullable Map.Entry<Long, File> entry) {
        if (entry == null || entry.getValue() == null) {
            return -1;
        }
        return this.dateCache.parseCount(this.fileToText().apply(entry.getValue()));
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "{sourceId=" + this.sourceId + ", file=" + this.path + '}';
    }

    @Override
    @NotNull
    public TimeProvider time() {
        return this.time;
    }

    @NotNull
    private ToIntFunction<File> fileToCycleFunction() {
        return f -> {
            String name = f.getName();
            return this.dateCache.parseCount(name.substring(0, name.length() - SUFFIX.length()));
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCloseListener(SingleChronicleQueueExcerpts.StoreTailer storeTailer) {
        Map<Object, Consumer> map = this.closers;
        synchronized (map) {
            this.closers.remove(storeTailer);
        }
    }

    public TableStore metaStore() {
        return this.metaStore;
    }

    private class StoreSupplier
    implements WireStoreSupplier {
        private final AtomicReference<CachedCycleTree> cachedTree = new AtomicReference();
        private final ReferenceCountedCache<File, MappedFile, MappedBytes, IOException> mappedFileCache = new ReferenceCountedCache(MappedBytes::mappedBytes, SingleChronicleQueue.this::mappedFile);
        private boolean queuePathExists;

        private StoreSupplier() {
        }

        @Override
        public WireStore acquire(int cycle, boolean createIfAbsent) {
            SingleChronicleQueue that = SingleChronicleQueue.this;
            RollingResourcesCache.Resource dateValue = that.dateCache.resourceFor(cycle);
            try {
                WireStore wireStore;
                File path = dateValue.path;
                if (!(createIfAbsent || cycle <= SingleChronicleQueue.this.directoryListing.getMaxCreatedCycle() && cycle >= SingleChronicleQueue.this.directoryListing.getMinCreatedCycle() && path.exists())) {
                    return null;
                }
                if (createIfAbsent) {
                    this.checkDiskSpace(that.path);
                }
                if (!dateValue.pathExists && createIfAbsent && !path.exists()) {
                    PrecreatedFiles.renamePreCreatedFileToRequiredFile(path);
                }
                dateValue.pathExists = true;
                MappedBytes mappedBytes = this.mappedFileCache.get(path);
                if (SHOULD_CHECK_CYCLE && cycle != SingleChronicleQueue.this.rollCycle.current(SingleChronicleQueue.this.time, SingleChronicleQueue.this.epoch)) {
                    LOG.warn("", new Exception("Creating cycle which is not the current cycle"));
                }
                this.queuePathExists = true;
                AbstractWire wire = (AbstractWire)SingleChronicleQueue.this.wireType.apply(mappedBytes);
                assert (wire.startUse());
                wire.pauser(SingleChronicleQueue.this.pauserSupplier.get());
                wire.headerNumber(SingleChronicleQueue.this.rollCycle.toIndex(cycle, 0L) - 1L);
                if (!SingleChronicleQueue.this.readOnly && wire.writeFirstHeader()) {
                    wireStore = (WireStore)SingleChronicleQueue.this.storeFactory.apply(that, wire);
                    wire.updateFirstHeader();
                    wireStore.initIndex(wire);
                    SingleChronicleQueue.this.directoryListing.onFileCreated(path, cycle);
                    SingleChronicleQueue.this.firstAndLastCycleTime = 0L;
                } else {
                    wire.readFirstHeader(SingleChronicleQueue.this.timeoutMS, TimeUnit.MILLISECONDS);
                    StringBuilder name = Wires.acquireStringBuilder();
                    ValueIn valueIn = wire.readEventName(name);
                    if (StringUtils.isEqual(name, MetaDataKeys.header.name())) {
                        wireStore = (WireStore)valueIn.typedMarshallable();
                    } else {
                        throw new StreamCorruptedException("The first message should be the header, was " + name);
                    }
                }
                return wireStore;
            }
            catch (IOException | TimeoutException e) {
                throw Jvm.rethrow(e);
            }
        }

        private void checkDiskSpace(@NotNull File filePath) {
            DiskSpaceMonitor.INSTANCE.pollDiskSpace(filePath);
        }

        @NotNull
        private NavigableMap<Long, File> cycleTree(boolean force) {
            CachedCycleTree cachedValue;
            block3: {
                CachedCycleTree existing;
                File[] files;
                File parentFile = SingleChronicleQueue.this.path;
                if (!this.queuePathExists && !parentFile.exists()) {
                    throw new IllegalStateException("parentFile=" + parentFile.getName() + " does not exist");
                }
                cachedValue = this.cachedTree.get();
                long directoryModCount = SingleChronicleQueue.this.directoryListing.modCount();
                if (!force && cachedValue != null && directoryModCount != -1L && directoryModCount <= cachedValue.directoryModCount) break block3;
                RollingResourcesCache dateCache = SingleChronicleQueue.this.dateCache;
                TreeMap<Long, File> tree = new TreeMap<Long, File>();
                for (File file2 : files = parentFile.listFiles(file -> file.getPath().endsWith(SingleChronicleQueue.SUFFIX))) {
                    tree.put(dateCache.toLong(file2), file2);
                }
                cachedValue = new CachedCycleTree(directoryModCount, tree);
                while (!((existing = this.cachedTree.get()) != null && existing.directoryModCount > cachedValue.directoryModCount || this.cachedTree.compareAndSet(existing, cachedValue))) {
                }
            }
            return cachedValue.cachedCycleTree;
        }

        @Override
        public int nextCycle(int currentCycle, @NotNull TailerDirection direction) throws ParseException {
            Long key;
            File file;
            if (direction == TailerDirection.NONE) {
                throw new AssertionError((Object)"direction is NONE");
            }
            assert (currentCycle >= 0) : "currentCycle=" + Integer.toHexString(currentCycle);
            NavigableMap<Long, File> tree = this.cycleTree(false);
            File currentCycleFile = ((SingleChronicleQueue)SingleChronicleQueue.this).dateCache.resourceFor((long)((long)currentCycle)).path;
            if (currentCycle > SingleChronicleQueue.this.directoryListing.getMaxCreatedCycle() || currentCycle < SingleChronicleQueue.this.directoryListing.getMinCreatedCycle()) {
                boolean fileFound = false;
                for (int i = 0; i < 20; ++i) {
                    Jvm.pause(10L);
                    fileFound = currentCycle <= SingleChronicleQueue.this.directoryListing.getMaxCreatedCycle() && currentCycle >= SingleChronicleQueue.this.directoryListing.getMinCreatedCycle();
                    if (fileFound) break;
                }
                if (!(fileFound |= currentCycleFile.exists())) {
                    throw new IllegalStateException(String.format("Expected file to exist for cycle: %d, file: %s.%nminCycle: %d, maxCycle: %d%nAvailable files: %s", currentCycle, currentCycleFile, SingleChronicleQueue.this.directoryListing.getMinCreatedCycle(), SingleChronicleQueue.this.directoryListing.getMaxCreatedCycle(), Arrays.toString(SingleChronicleQueue.this.path.list((d, n) -> n.endsWith(SingleChronicleQueue.SUFFIX)))));
                }
            }
            if ((file = (File)tree.get(key = SingleChronicleQueue.this.dateCache.toLong(currentCycleFile))) == null) {
                tree = this.cycleTree(true);
                file = (File)tree.get(key);
            }
            if (file == null) {
                throw new AssertionError((Object)("missing currentCycle, file=" + currentCycleFile));
            }
            switch (direction) {
                case FORWARD: {
                    return SingleChronicleQueue.this.toCycle(tree.higherEntry(key));
                }
                case BACKWARD: {
                    return SingleChronicleQueue.this.toCycle(tree.lowerEntry(key));
                }
            }
            throw new UnsupportedOperationException("Unsupported Direction");
        }

        @Override
        public NavigableSet<Long> cycles(int lowerCycle, int upperCycle) {
            NavigableMap<Long, File> tree = this.cycleTree(false);
            Long lowerKey = this.toKey(lowerCycle, "lowerCycle");
            Long upperKey = this.toKey(upperCycle, "upperCycle");
            assert (lowerKey != null);
            assert (upperKey != null);
            return tree.subMap(lowerKey, true, upperKey, true).navigableKeySet();
        }

        private Long toKey(int cyle, String m) {
            File file = ((SingleChronicleQueue)SingleChronicleQueue.this).dateCache.resourceFor((long)((long)cyle)).path;
            if (!file.exists()) {
                throw new IllegalStateException("'file not found' for the " + m + ", file=" + file);
            }
            return SingleChronicleQueue.this.dateCache.toLong(file);
        }
    }

    private static final class CachedCycleTree {
        private final long directoryModCount;
        private final NavigableMap<Long, File> cachedCycleTree;

        CachedCycleTree(long directoryModCount, NavigableMap<Long, File> cachedCycleTree) {
            this.directoryModCount = directoryModCount;
            this.cachedCycleTree = cachedCycleTree;
        }
    }
}

