/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.crypto.spec.SecretKeySpec;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesRingBufferStats;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.ThrowingBiFunction;
import net.openhft.chronicle.core.util.Updater;
import net.openhft.chronicle.queue.BufferMode;
import net.openhft.chronicle.queue.QueueOffsetSpec;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.WireStoreFactory;
import net.openhft.chronicle.queue.impl.single.MetaDataKeys;
import net.openhft.chronicle.queue.impl.single.NoopQueueLock;
import net.openhft.chronicle.queue.impl.single.QueueLock;
import net.openhft.chronicle.queue.impl.single.ReadOnlyWriteLock;
import net.openhft.chronicle.queue.impl.single.SCQIndexing;
import net.openhft.chronicle.queue.impl.single.SCQMeta;
import net.openhft.chronicle.queue.impl.single.SCQRoll;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.TSQueueLock;
import net.openhft.chronicle.queue.impl.single.TableStoreWriteLock;
import net.openhft.chronicle.queue.impl.single.WriteLock;
import net.openhft.chronicle.queue.impl.table.ReadonlyTableStore;
import net.openhft.chronicle.queue.impl.table.SingleTableBuilder;
import net.openhft.chronicle.threads.EventGroup;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.TimeoutPauser;
import net.openhft.chronicle.threads.TimingPauser;
import net.openhft.chronicle.wire.FieldInfo;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleChronicleQueueBuilder
implements Cloneable,
Marshallable {
    public static final String DEFAULT_ROLL_CYCLE_PROPERTY = "net.openhft.queue.builder.defaultRollCycle";
    private static final Constructor ENTERPRISE_QUEUE_CONSTRUCTOR;
    private static final String DEFAULT_EPOCH_PROPERTY = "net.openhft.queue.builder.defaultEpoch";
    private static final Logger LOGGER;
    public BufferMode writeBufferMode = BufferMode.None;
    public BufferMode readBufferMode = BufferMode.None;
    private WireType wireType = WireType.BINARY_LIGHT;
    private Long blockSize;
    private File path;
    private RollCycle rollCycle = SingleChronicleQueueBuilder.loadDefaultRollCycle();
    private Long epoch;
    private Long bufferCapacity;
    private Integer indexSpacing;
    private Integer indexCount;
    private Boolean enableRingBufferMonitoring;
    private Boolean ringBufferReaderCanDrain;
    private Boolean ringBufferForceCreateReader;
    private Boolean ringBufferReopenReader;
    private Pauser ringBufferPauser = Pauser.busy();
    private HandlerPriority drainerPriority;
    @Nullable
    private EventLoop eventLoop;
    private WireStoreFactory storeFactory = SingleChronicleQueueBuilder::createStore;
    @NotNull
    private Consumer<BytesRingBufferStats> onRingBufferStats = NoBytesRingBufferStats.NONE;
    private TimeProvider timeProvider = SystemTimeProvider.INSTANCE;
    private Supplier<TimingPauser> pauserSupplier = () -> new TimeoutPauser(500000);
    private Long timeoutMS;
    private Integer sourceId;
    private StoreFileListener storeFileListener;
    private Boolean readOnly;
    private Boolean strongAppenders;
    private Boolean checkInterrupts;
    private TableStore<SCQMeta> metaStore;
    private int deltaCheckpointInterval = -1;
    private Supplier<BiConsumer<BytesStore, Bytes>> encodingSupplier;
    private Supplier<BiConsumer<BytesStore, Bytes>> decodingSupplier;
    private Updater<Bytes> messageInitializer;
    private Consumer<Bytes> messageHeaderReader;
    private SecretKeySpec key;
    private int maxTailers;
    private ThrowingBiFunction<Long, Integer, BytesStore, Exception> bufferBytesStoreCreator;
    private Long pretouchIntervalMillis;
    private LocalTime rollTime;
    private ZoneId rollTimeZone;
    private QueueOffsetSpec queueOffsetSpec;

    protected SingleChronicleQueueBuilder() {
    }

    public static void addAliases() {
    }

    public static SingleChronicleQueueBuilder builder() {
        return new SingleChronicleQueueBuilder();
    }

    @NotNull
    public static SingleChronicleQueueBuilder builder(@NotNull Path path, @NotNull WireType wireType) {
        return SingleChronicleQueueBuilder.builder(path.toFile(), wireType);
    }

    @NotNull
    public static SingleChronicleQueueBuilder builder(@NotNull File file, @NotNull WireType wireType) {
        SingleChronicleQueueBuilder result = SingleChronicleQueueBuilder.builder().wireType(wireType);
        if (file.isFile()) {
            if (!file.getName().endsWith(".cq4")) {
                throw new IllegalArgumentException("Invalid file type: " + file.getName());
            }
            LOGGER.warn("Queues should be configured with the queue directory, not a specific filename. Actual file used: {}", (Object)file.getParentFile());
            result.path(file.getParentFile());
        } else {
            result.path(file);
        }
        return result;
    }

    public static SingleChronicleQueueBuilder single() {
        SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.builder();
        builder.wireType(WireType.BINARY_LIGHT);
        return builder;
    }

    public static SingleChronicleQueueBuilder single(@NotNull String basePath) {
        return SingleChronicleQueueBuilder.binary(basePath);
    }

    public static SingleChronicleQueueBuilder single(@NotNull File basePath) {
        return SingleChronicleQueueBuilder.binary(basePath);
    }

    public static SingleChronicleQueueBuilder binary(@NotNull Path path) {
        return SingleChronicleQueueBuilder.binary(path.toFile());
    }

    public static SingleChronicleQueueBuilder binary(@NotNull String basePath) {
        return SingleChronicleQueueBuilder.binary(new File(basePath));
    }

    public static SingleChronicleQueueBuilder binary(@NotNull File basePathFile) {
        return SingleChronicleQueueBuilder.builder(basePathFile, WireType.BINARY_LIGHT);
    }

    public static SingleChronicleQueueBuilder fieldlessBinary(@NotNull File name) {
        return SingleChronicleQueueBuilder.builder(name, WireType.FIELDLESS_BINARY);
    }

    public static SingleChronicleQueueBuilder defaultZeroBinary(@NotNull File basePathFile) {
        return SingleChronicleQueueBuilder.builder(basePathFile, WireType.DEFAULT_ZERO_BINARY);
    }

    public static SingleChronicleQueueBuilder deltaBinary(@NotNull File basePathFile) {
        return SingleChronicleQueueBuilder.builder(basePathFile, WireType.DELTA_BINARY);
    }

    public static SingleChronicleQueueBuilder deltaBinary(@NotNull File name, byte deltaIntervalShift) {
        SingleChronicleQueueBuilder ret = SingleChronicleQueueBuilder.deltaBinary(name);
        if (deltaIntervalShift < 0 || deltaIntervalShift > 63) {
            throw new IllegalArgumentException("deltaIntervalShift=" + deltaIntervalShift + ", but should be a value between 0-63 inclusive");
        }
        ret.deltaCheckpointInterval(1 << deltaIntervalShift);
        return ret;
    }

    @NotNull
    static SingleChronicleQueueStore createStore(@NotNull RollingChronicleQueue queue, @NotNull Wire wire) {
        SingleChronicleQueueStore wireStore = new SingleChronicleQueueStore(queue.rollCycle(), queue.wireType(), (MappedBytes)wire.bytes(), queue.indexCount(), queue.indexSpacing());
        wire.writeEventName(MetaDataKeys.header).typedMarshallable(wireStore);
        return wireStore;
    }

    @Nullable
    static SingleChronicleQueueStore loadStore(@NotNull Wire wire) {
        StringBuilder eventName = new StringBuilder();
        wire.readEventName(eventName);
        if (eventName.toString().equals(MetaDataKeys.header.name())) {
            SingleChronicleQueueStore store = (SingleChronicleQueueStore)wire.read().typedMarshallable();
            if (store == null) {
                throw new IllegalArgumentException("Unable to load wire store");
            }
            return store;
        }
        LOGGER.warn("Unable to load store file from input. Queue file may be corrupted.");
        return null;
    }

    private static boolean isQueueReplicationAvailable() {
        return ENTERPRISE_QUEUE_CONSTRUCTOR != null;
    }

    private static RollCycle loadDefaultRollCycle() {
        if (null == System.getProperty(DEFAULT_ROLL_CYCLE_PROPERTY)) {
            return RollCycles.DAILY;
        }
        String rollCycleProperty = System.getProperty(DEFAULT_ROLL_CYCLE_PROPERTY);
        String[] rollCyclePropertyParts = rollCycleProperty.split(":");
        if (rollCyclePropertyParts.length > 0) {
            try {
                Class<?> rollCycleClass = Class.forName(rollCyclePropertyParts[0]);
                if (Enum.class.isAssignableFrom(rollCycleClass)) {
                    if (rollCyclePropertyParts.length < 2) {
                        LOGGER.warn("Default roll cycle configured as enum, but enum value not specified: " + rollCycleProperty);
                    } else {
                        Class<?> eClass = rollCycleClass;
                        Object instance = ObjectUtils.valueOf(eClass, rollCyclePropertyParts[1]);
                        if (instance instanceof RollCycle) {
                            return (RollCycle)instance;
                        }
                        LOGGER.warn("Configured default rollcycle is not a subclass of RollCycle");
                    }
                } else {
                    Object instance = ObjectUtils.newInstance(rollCycleClass);
                    if (instance instanceof RollCycle) {
                        return (RollCycle)instance;
                    }
                    LOGGER.warn("Configured default rollcycle is not a subclass of RollCycle");
                }
            }
            catch (ClassNotFoundException ignored) {
                LOGGER.warn("Default roll cycle class: " + rollCyclePropertyParts[0] + " was not found");
            }
        }
        return RollCycles.DAILY;
    }

    public WireStoreFactory storeFactory() {
        return this.storeFactory;
    }

    @NotNull
    public SingleChronicleQueue build() {
        boolean needEnterprise = this.checkEnterpriseFeaturesRequested();
        this.preBuild();
        if (needEnterprise) {
            return this.buildEnterprise();
        }
        return new SingleChronicleQueue(this);
    }

    private boolean checkEnterpriseFeaturesRequested() {
        boolean result = false;
        if (this.readBufferMode != BufferMode.None) {
            result = this.onlyAvailableInEnterprise("Buffering");
        }
        if (this.writeBufferMode != BufferMode.None) {
            result = this.onlyAvailableInEnterprise("Buffering");
        }
        if (this.rollTimeZone != null && !this.rollTimeZone.getId().equals("UTC") && !this.rollTimeZone.getId().equals("Z")) {
            result = this.onlyAvailableInEnterprise("Non-UTC roll time zone");
        }
        if (this.wireType == WireType.DELTA_BINARY) {
            result = this.onlyAvailableInEnterprise("Wire type " + this.wireType.name());
        }
        if (this.encodingSupplier != null) {
            result = this.onlyAvailableInEnterprise("Encoding");
        }
        if (this.key != null) {
            result = this.onlyAvailableInEnterprise("Encryption");
        }
        if (this.hasPretouchIntervalMillis()) {
            result = this.onlyAvailableInEnterprise("Out of process pretouching");
        }
        return result;
    }

    private boolean onlyAvailableInEnterprise(String feature) {
        if (ENTERPRISE_QUEUE_CONSTRUCTOR == null) {
            LOGGER.warn(feature + " is only supported in Chronicle Queue Enterprise. If you would like to use this feature, please contact sales@chronicle.software for more information.");
        }
        return true;
    }

    @NotNull
    private SingleChronicleQueue buildEnterprise() {
        if (ENTERPRISE_QUEUE_CONSTRUCTOR == null) {
            throw new IllegalStateException("Enterprise features requested but Chronicle Queue Enterprise is not in the class path!");
        }
        try {
            return (SingleChronicleQueue)ENTERPRISE_QUEUE_CONSTRUCTOR.newInstance(this);
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't create an instance of Enterprise queue", e);
        }
    }

    public SingleChronicleQueueBuilder aesEncryption(@Nullable byte[] keyBytes) {
        if (keyBytes == null) {
            this.codingSuppliers(null, null);
            return this;
        }
        this.key = new SecretKeySpec(keyBytes, "AES");
        return this;
    }

    public Updater<Bytes> messageInitializer() {
        return this.messageInitializer == null ? Bytes::clear : this.messageInitializer;
    }

    public Consumer<Bytes> messageHeaderReader() {
        return this.messageHeaderReader == null ? b -> {} : this.messageHeaderReader;
    }

    public SingleChronicleQueueBuilder messageHeader(Updater<Bytes> messageInitializer, Consumer<Bytes> messageHeaderReader) {
        this.messageInitializer = messageInitializer;
        this.messageHeaderReader = messageHeaderReader;
        return this;
    }

    public SingleChronicleQueueBuilder rollTime(LocalTime rollTime) {
        this.rollTime(rollTime, this.rollTimeZone);
        return this;
    }

    public ZoneId rollTimeZone() {
        return this.rollTimeZone;
    }

    public SingleChronicleQueueBuilder rollTimeZone(ZoneId rollTimeZone) {
        this.rollTime(this.rollTime, rollTimeZone);
        return this;
    }

    public SingleChronicleQueueBuilder rollTime(@NotNull LocalTime rollTime, ZoneId zoneId) {
        this.rollTime = rollTime;
        this.rollTimeZone = zoneId;
        this.epoch = TimeUnit.SECONDS.toMillis(rollTime.toSecondOfDay());
        this.queueOffsetSpec = QueueOffsetSpec.ofRollTime(rollTime, zoneId);
        return this;
    }

    protected void initializeMetadata() {
        File metapath = this.metapath();
        this.validateRollCycle(metapath);
        SCQMeta metadata = new SCQMeta(new SCQRoll(this.rollCycle(), this.epoch(), this.rollTime, this.rollTimeZone), this.deltaCheckpointInterval(), this.sourceId());
        try {
            String format;
            boolean readOnly = this.readOnly();
            this.metaStore = SingleTableBuilder.binary(metapath, metadata).readOnly(readOnly).build();
            SCQMeta newMeta = this.metaStore.metadata();
            if (this.sourceId() == 0) {
                this.sourceId(newMeta.sourceId());
            }
            if (!(format = newMeta.roll().format()).equals(this.rollCycle().format())) {
                this.overrideRollCycleForFileName(format);
            }
            this.rollTime = newMeta.roll().rollTime();
            this.rollTimeZone = newMeta.roll().rollTimeZone();
            this.epoch = newMeta.roll().epoch();
        }
        catch (IORuntimeException ex) {
            if (OS.isWindows()) {
                throw ex;
            }
            Jvm.warn().on(this.getClass(), "Failback to readonly tablestore", ex);
            this.metaStore = new ReadonlyTableStore<SCQMeta>(metadata);
        }
    }

    private void validateRollCycle(File metapath) {
        String[] list;
        if (!metapath.exists() && (list = this.path.list((d, name) -> name.endsWith(".cq4"))) != null && list.length > 0) {
            String filename = list[0];
            for (RollCycles cycle : RollCycles.VALUES) {
                try {
                    DateTimeFormatter.ofPattern(cycle.format()).parse(filename.substring(0, filename.length() - 4));
                    this.overrideRollCycle(cycle);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void overrideRollCycleForFileName(String pattern) {
        for (RollCycles cycle : RollCycles.VALUES) {
            if (!cycle.format().equals(pattern)) continue;
            this.overrideRollCycle(cycle);
            return;
        }
        throw new IllegalStateException("Can't find an appropriate RollCycles to override to of length " + pattern);
    }

    private void overrideRollCycle(RollCycles cycle) {
        LOGGER.warn("Overriding roll cycle from {} to {}", (Object)this.rollCycle, (Object)cycle);
        this.rollCycle = cycle;
    }

    private File metapath() {
        File storeFilePath;
        if ("".equals(this.path.getPath())) {
            storeFilePath = new File("metadata.cq4t");
        } else {
            storeFilePath = new File(this.path, "metadata.cq4t");
            this.path.mkdirs();
        }
        return storeFilePath;
    }

    @NotNull
    QueueLock queueLock() {
        return SingleChronicleQueueBuilder.isQueueReplicationAvailable() && !this.readOnly() ? new TSQueueLock(this.metaStore, this.pauserSupplier(), this.timeoutMS() * 3L / 2L) : new NoopQueueLock();
    }

    @NotNull
    WriteLock writeLock() {
        return this.readOnly() ? new ReadOnlyWriteLock() : new TableStoreWriteLock(this.metaStore, this.pauserSupplier(), this.timeoutMS() * 3L / 2L);
    }

    public int deltaCheckpointInterval() {
        return this.deltaCheckpointInterval == -1 ? 64 : this.deltaCheckpointInterval;
    }

    public QueueOffsetSpec queueOffsetSpec() {
        return this.queueOffsetSpec == null ? QueueOffsetSpec.ofNone() : this.queueOffsetSpec;
    }

    TableStore<SCQMeta> metaStore() {
        return this.metaStore;
    }

    public SingleChronicleQueueBuilder maxTailers(int maxTailers) {
        this.maxTailers = maxTailers;
        return this;
    }

    public int maxTailers() {
        return this.maxTailers;
    }

    public SingleChronicleQueueBuilder bufferBytesStoreCreator(ThrowingBiFunction<Long, Integer, BytesStore, Exception> bufferBytesStoreCreator) {
        this.bufferBytesStoreCreator = bufferBytesStoreCreator;
        return this;
    }

    @Nullable
    public ThrowingBiFunction<Long, Integer, BytesStore, Exception> bufferBytesStoreCreator() {
        return this.bufferBytesStoreCreator;
    }

    public SingleChronicleQueueBuilder enablePreloader(long pretouchIntervalMillis) {
        this.pretouchIntervalMillis = pretouchIntervalMillis;
        return this;
    }

    public long pretouchIntervalMillis() {
        return this.pretouchIntervalMillis;
    }

    public boolean hasPretouchIntervalMillis() {
        return this.pretouchIntervalMillis != null;
    }

    public SingleChronicleQueueBuilder path(String path) {
        return this.path(new File(path));
    }

    public SingleChronicleQueueBuilder path(File path) {
        this.path = path;
        return this;
    }

    public SingleChronicleQueueBuilder path(Path path) {
        this.path = path.toFile();
        return this;
    }

    public SingleChronicleQueueBuilder onRingBufferStats(@NotNull Consumer<BytesRingBufferStats> onRingBufferStats) {
        this.onRingBufferStats = onRingBufferStats;
        return this;
    }

    @NotNull
    public Consumer<BytesRingBufferStats> onRingBufferStats() {
        return this.onRingBufferStats == null ? NoBytesRingBufferStats.NONE : this.onRingBufferStats;
    }

    @NotNull
    public File path() {
        return this.path;
    }

    public SingleChronicleQueueBuilder blockSize(long blockSize) {
        this.blockSize = Math.max(65536L, blockSize);
        return this;
    }

    public SingleChronicleQueueBuilder blockSize(int blockSize) {
        return this.blockSize((long)blockSize);
    }

    public long blockSize() {
        long bs = this.blockSize == null ? (OS.is64Bit() ? 0x4000000L : 65536L) : this.blockSize;
        long minSize = Math.max(65536L, 32L * (long)this.indexCount());
        return Math.max(minSize, bs);
    }

    public SingleChronicleQueueBuilder testBlockSize() {
        return this.blockSize(65536);
    }

    @NotNull
    public SingleChronicleQueueBuilder wireType(@NotNull WireType wireType) {
        if (wireType == WireType.DELTA_BINARY) {
            this.deltaCheckpointInterval(64);
        }
        this.wireType = wireType;
        return this;
    }

    private void deltaCheckpointInterval(int deltaCheckpointInterval) {
        assert (this.checkIsPowerOf2(deltaCheckpointInterval));
        this.deltaCheckpointInterval = deltaCheckpointInterval;
    }

    private boolean checkIsPowerOf2(long value) {
        return (value & value - 1L) == 0L;
    }

    @NotNull
    public WireType wireType() {
        return this.wireType == null ? WireType.BINARY_LIGHT : this.wireType;
    }

    @NotNull
    public SingleChronicleQueueBuilder rollCycle(@NotNull RollCycle rollCycle) {
        this.rollCycle = rollCycle;
        return this;
    }

    @NotNull
    public RollCycle rollCycle() {
        return this.rollCycle;
    }

    public long bufferCapacity() {
        long bufferCapacity = this.bufferCapacity == null ? 0L : this.bufferCapacity;
        Long blockSize = this.blockSize();
        return Math.min(blockSize / 4L, bufferCapacity == -1L ? 0x200000L : Math.max(4096L, bufferCapacity));
    }

    @NotNull
    public SingleChronicleQueueBuilder bufferCapacity(long bufferCapacity) {
        this.bufferCapacity = bufferCapacity;
        return this;
    }

    @NotNull
    public SingleChronicleQueueBuilder epoch(long epoch) {
        this.epoch = epoch;
        this.queueOffsetSpec = QueueOffsetSpec.ofEpoch(epoch);
        return this;
    }

    public long epoch() {
        return this.epoch == null ? Long.getLong(DEFAULT_EPOCH_PROPERTY, 0L) : this.epoch;
    }

    @Deprecated
    @NotNull
    public SingleChronicleQueueBuilder buffered(boolean isBuffered) {
        this.writeBufferMode = isBuffered ? BufferMode.Asynchronous : BufferMode.None;
        return this;
    }

    @Deprecated
    public boolean buffered() {
        return this.writeBufferMode == BufferMode.Asynchronous;
    }

    @NotNull
    public BufferMode writeBufferMode() {
        return this.wireType() == WireType.DELTA_BINARY ? BufferMode.None : (this.writeBufferMode == null ? BufferMode.None : this.writeBufferMode);
    }

    public SingleChronicleQueueBuilder writeBufferMode(BufferMode writeBufferMode) {
        this.writeBufferMode = writeBufferMode;
        return this;
    }

    public BufferMode readBufferMode() {
        return this.readBufferMode == null ? BufferMode.None : this.readBufferMode;
    }

    public SingleChronicleQueueBuilder readBufferMode(BufferMode readBufferMode) {
        this.readBufferMode = readBufferMode;
        return this;
    }

    @NotNull
    public EventLoop eventLoop() {
        return this.eventLoop == null ? new EventGroup(true) : this.eventLoop;
    }

    @NotNull
    public SingleChronicleQueueBuilder eventLoop(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
        return this;
    }

    public boolean enableRingBufferMonitoring() {
        return this.enableRingBufferMonitoring == null ? false : this.enableRingBufferMonitoring;
    }

    public SingleChronicleQueueBuilder enableRingBufferMonitoring(boolean enableRingBufferMonitoring) {
        this.enableRingBufferMonitoring = enableRingBufferMonitoring;
        return this;
    }

    public boolean ringBufferReaderCanDrain() {
        return this.ringBufferReaderCanDrain == null ? true : this.ringBufferReaderCanDrain;
    }

    public SingleChronicleQueueBuilder ringBufferReaderCanDrain(boolean ringBufferReaderCanDrain) {
        this.ringBufferReaderCanDrain = ringBufferReaderCanDrain;
        return this;
    }

    public boolean ringBufferForceCreateReader() {
        return this.ringBufferForceCreateReader == null ? false : this.ringBufferForceCreateReader;
    }

    public SingleChronicleQueueBuilder ringBufferForceCreateReader(boolean ringBufferForceCreateReader) {
        this.ringBufferForceCreateReader = ringBufferForceCreateReader;
        return this;
    }

    public boolean ringBufferReopenReader() {
        return this.ringBufferReopenReader == null ? false : this.ringBufferReopenReader;
    }

    public SingleChronicleQueueBuilder ringBufferReopenReader(boolean ringBufferReopenReader) {
        this.ringBufferReopenReader = ringBufferReopenReader;
        return this;
    }

    public HandlerPriority drainerPriority() {
        return this.drainerPriority == null ? HandlerPriority.REPLICATION : this.drainerPriority;
    }

    public SingleChronicleQueueBuilder drainerPriority(HandlerPriority drainerPriority) {
        this.drainerPriority = drainerPriority;
        return this;
    }

    public Pauser ringBufferPauser() {
        return this.ringBufferPauser;
    }

    public SingleChronicleQueueBuilder ringBufferPauser(Pauser ringBufferPauser) {
        this.ringBufferPauser = ringBufferPauser;
        return this;
    }

    public SingleChronicleQueueBuilder indexCount(int indexCount) {
        this.indexCount = Maths.nextPower2(indexCount, 8);
        return this;
    }

    public int indexCount() {
        return this.indexCount == null || this.indexCount <= 0 ? this.rollCycle().defaultIndexCount() : this.indexCount.intValue();
    }

    public SingleChronicleQueueBuilder indexSpacing(int indexSpacing) {
        this.indexSpacing = Maths.nextPower2(indexSpacing, 1);
        return this;
    }

    public int indexSpacing() {
        return this.indexSpacing == null || this.indexSpacing <= 0 ? this.rollCycle().defaultIndexSpacing() : this.indexSpacing.intValue();
    }

    public TimeProvider timeProvider() {
        return this.timeProvider == null ? SystemTimeProvider.INSTANCE : this.timeProvider;
    }

    public SingleChronicleQueueBuilder timeProvider(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        return this;
    }

    public Supplier<TimingPauser> pauserSupplier() {
        return this.pauserSupplier;
    }

    public SingleChronicleQueueBuilder pauserSupplier(Supplier<TimingPauser> pauser) {
        this.pauserSupplier = pauser;
        return this;
    }

    public SingleChronicleQueueBuilder timeoutMS(long timeoutMS) {
        this.timeoutMS = timeoutMS;
        return this;
    }

    public long timeoutMS() {
        return this.timeoutMS == null ? 10000L : this.timeoutMS;
    }

    public SingleChronicleQueueBuilder storeFileListener(StoreFileListener storeFileListener) {
        this.storeFileListener = storeFileListener;
        return this;
    }

    public StoreFileListener storeFileListener() {
        return this.storeFileListener == null ? (cycle, file) -> {
            if (Jvm.isDebugEnabled(this.getClass())) {
                Jvm.debug().on(this.getClass(), "File released " + file);
            }
        } : this.storeFileListener;
    }

    public SingleChronicleQueueBuilder sourceId(int sourceId) {
        if (sourceId < 0) {
            throw new IllegalArgumentException("Invalid source Id, must be positive");
        }
        this.sourceId = sourceId;
        return this;
    }

    public int sourceId() {
        return this.sourceId == null ? 0 : this.sourceId;
    }

    public boolean readOnly() {
        return this.readOnly == Boolean.TRUE && !OS.isWindows();
    }

    public SingleChronicleQueueBuilder readOnly(boolean readOnly) {
        if (OS.isWindows() && readOnly) {
            Jvm.warn().on(SingleChronicleQueueBuilder.class, "Read-only mode is not supported on Windows\u00ae platforms, defaulting to read/write.");
        } else {
            this.readOnly = readOnly;
        }
        return this;
    }

    public Supplier<BiConsumer<BytesStore, Bytes>> encodingSupplier() {
        return this.encodingSupplier;
    }

    public Supplier<BiConsumer<BytesStore, Bytes>> decodingSupplier() {
        return this.decodingSupplier;
    }

    public SingleChronicleQueueBuilder codingSuppliers(@Nullable Supplier<BiConsumer<BytesStore, Bytes>> encodingSupplier, @Nullable Supplier<BiConsumer<BytesStore, Bytes>> decodingSupplier) {
        if (encodingSupplier == null != (decodingSupplier == null)) {
            throw new UnsupportedOperationException("Both encodingSupplier and decodingSupplier must be set or neither");
        }
        this.encodingSupplier = encodingSupplier;
        this.decodingSupplier = decodingSupplier;
        return this;
    }

    public SecretKeySpec key() {
        return this.key;
    }

    protected void preBuild() {
        this.initializeMetadata();
    }

    public SingleChronicleQueueBuilder strongAppenders(boolean strongAppenders) {
        this.strongAppenders = strongAppenders;
        return this;
    }

    public boolean strongAppenders() {
        return Boolean.TRUE.equals(this.strongAppenders);
    }

    public boolean checkInterrupts() {
        if (this.checkInterrupts == null) {
            if (System.getProperties().contains("chronicle.queue.ignoreInterrupts")) {
                return !Boolean.getBoolean("chronicle.queue.ignoreInterrupts");
            }
            if (System.getProperties().contains("chronicle.queue.checkInterrupts")) {
                return Boolean.getBoolean("chronicle.queue.checkInterrupts");
            }
        }
        return !Boolean.FALSE.equals(this.checkInterrupts);
    }

    public SingleChronicleQueueBuilder checkInterrupts(boolean checkInterrupts) {
        this.checkInterrupts = checkInterrupts;
        return this;
    }

    public SingleChronicleQueueBuilder clone() {
        try {
            return (SingleChronicleQueueBuilder)super.clone();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public SingleChronicleQueueBuilder setAllNullFields(@Nullable SingleChronicleQueueBuilder parentBuilder) {
        if (parentBuilder == null) {
            return this;
        }
        if (!this.getClass().isAssignableFrom(parentBuilder.getClass()) && !parentBuilder.getClass().isAssignableFrom(this.getClass())) {
            throw new IllegalArgumentException("Classes are not in same implementation hierarchy");
        }
        List<FieldInfo> sourceFieldInfo = Wires.fieldInfos(parentBuilder.getClass());
        for (FieldInfo fieldInfo : Wires.fieldInfos(this.getClass())) {
            if (!sourceFieldInfo.contains(fieldInfo)) continue;
            Object resultV = fieldInfo.get(this);
            Object parentV = fieldInfo.get(parentBuilder);
            if (resultV != null || parentV == null) continue;
            fieldInfo.set((Object)this, parentV);
        }
        return this;
    }

    static {
        Constructor<?> co;
        LOGGER = LoggerFactory.getLogger(SingleChronicleQueueBuilder.class);
        ClassAliasPool.CLASS_ALIASES.addAlias(WireType.class);
        ClassAliasPool.CLASS_ALIASES.addAlias(SCQMeta.class, "SCQMeta");
        ClassAliasPool.CLASS_ALIASES.addAlias(SCQRoll.class, "SCQSRoll");
        ClassAliasPool.CLASS_ALIASES.addAlias(SCQIndexing.class, "SCQSIndexing");
        ClassAliasPool.CLASS_ALIASES.addAlias(SingleChronicleQueueStore.class, "SCQStore");
        try {
            co = Class.forName("software.chronicle.enterprise.queue.EnterpriseSingleChronicleQueue").getDeclaredConstructors()[0];
            Jvm.setAccessible(co);
        }
        catch (Exception e) {
            co = null;
        }
        ENTERPRISE_QUEUE_CONSTRUCTOR = co;
    }

    static enum NoBytesRingBufferStats implements Consumer<BytesRingBufferStats>
    {
        NONE;


        @Override
        public void accept(BytesRingBufferStats bytesRingBufferStats) {
        }
    }
}

